ALTER TABLE SDSADM.STD_ZIPTOMSAHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPTOMSAHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPTOMSAHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPTOMSAHISTORY ON SDSADM.STD_ZIPTOMSAHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipToMSAHistory
after DELETE
ON SDSADM.STD_ZIPTOMSAHISTORY
BEGIN
	-- update the table for STD_ZipToMSAHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipToMSAHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipToMSAHistory
after INSERT
ON SDSADM.STD_ZIPTOMSAHISTORY
BEGIN
	-- update the table for STD_ZipToMSAHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipToMSAHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipToMSAHistory
after UPDATE
ON SDSADM.STD_ZIPTOMSAHISTORY
BEGIN
	-- update the table for STD_ZipToMSAHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipToMSAHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPTOMSAHISTORY FOR SDSADM.STD_ZIPTOMSAHISTORY;


ALTER TABLE SDSADM.STD_ZIPTOMSAHISTORY ADD (
  CONSTRAINT PK_STD_ZIPTOMSAHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ZIPTOMSAHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_ZIPTOMSAHISTORY ADD (
  CONSTRAINT FKSTD_ZIPTOMSAHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_ZIPTOMSA (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPTOMSAHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPTOMSAHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPTOMSAHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPTOMSAHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPTOMSAHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPTOMSAHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPTOMSAHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPTOMSAHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPTOMSAHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ZIPTOMSA
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPTOMSA CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPTOMSA
(
  ID               NUMBER(20)                   NOT NULL,
  ZIPCODE          CHAR(5 BYTE)                 NOT NULL,
  MSACODEFROM1990  VARCHAR2(4 BYTE)             NOT NULL,
  VERSION          INTEGER                      NOT NULL,
  CREATED          TIMESTAMP(6)                 NOT NULL,
  UPDATED          TIMESTAMP(6),
  CREATEDBY        VARCHAR2(32 BYTE)            NOT NULL,
  UPDATEDBY        VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPTOMSA ON SDSADM.STD_ZIPTOMSA
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_ZIPTOMSAZIPCODE ON SDSADM.STD_ZIPTOMSA
(ZIPCODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipToMSA
after DELETE
ON SDSADM.STD_ZIPTOMSA
BEGIN
	-- update the table for STD_ZipToMSA operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipToMSA';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipToMSA
after INSERT
ON SDSADM.STD_ZIPTOMSA
BEGIN
	-- update the table for STD_ZipToMSA operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipToMSA';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipToMSA
after UPDATE
ON SDSADM.STD_ZIPTOMSA
BEGIN
	-- update the table for STD_ZipToMSA operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipToMSA';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPTOMSA FOR SDSADM.STD_ZIPTOMSA;


ALTER TABLE SDSADM.STD_ZIPTOMSA ADD (
  CONSTRAINT PK_STD_ZIPTOMSA
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ZIPTOMSA
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_ZIPTOMSAZIPCODE
  UNIQUE (ZIPCODE)
  USING INDEX SDSADM.UQSTD_ZIPTOMSAZIPCODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPTOMSA TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPTOMSA TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPTOMSA TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPTOMSA TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPTOMSA TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPTOMSA TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPTOMSA TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPTOMSA TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPTOMSA TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ZIPPLACEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPPLACEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPPLACEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPPLACEHISTORY ON SDSADM.STD_ZIPPLACEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipPlaceHistory
after DELETE
ON SDSADM.STD_ZIPPLACEHISTORY
BEGIN
	-- update the table for STD_ZipPlaceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlaceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipPlaceHistory
after INSERT
ON SDSADM.STD_ZIPPLACEHISTORY
BEGIN
	-- update the table for STD_ZipPlaceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlaceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipPlaceHistory
after UPDATE
ON SDSADM.STD_ZIPPLACEHISTORY
BEGIN
	-- update the table for STD_ZipPlaceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlaceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPPLACEHISTORY FOR SDSADM.STD_ZIPPLACEHISTORY;


ALTER TABLE SDSADM.STD_ZIPPLACEHISTORY ADD (
  CONSTRAINT PK_STD_ZIPPLACEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ZIPPLACEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_ZIPPLACEHISTORY ADD (
  CONSTRAINT FKSTD_ZIPPLACEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_ZIPPLACE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPPLACEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPPLACEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPPLACEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPPLACEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPPLACEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPPLACEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPPLACEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPPLACEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPPLACEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ZIPPLACEFACILITYHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPPLACEFACILITYHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPPLACEFACILITYHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPPLACEFACILITYHISTORY ON SDSADM.STD_ZIPPLACEFACILITYHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipPlaceFacilityHstry
after DELETE
ON SDSADM.STD_ZIPPLACEFACILITYHISTORY
BEGIN
	-- update the table for STD_ZipPlaceFacilityHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlaceFacilityHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipPlaceFacilityHstry
after INSERT
ON SDSADM.STD_ZIPPLACEFACILITYHISTORY
BEGIN
	-- update the table for STD_ZipPlaceFacilityHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlaceFacilityHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipPlaceFacilityHstry
after UPDATE
ON SDSADM.STD_ZIPPLACEFACILITYHISTORY
BEGIN
	-- update the table for STD_ZipPlaceFacilityHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlaceFacilityHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPPLACEFACILITYHISTORY FOR SDSADM.STD_ZIPPLACEFACILITYHISTORY;


ALTER TABLE SDSADM.STD_ZIPPLACEFACILITYHISTORY ADD (
  CONSTRAINT PK_STD_ZIPPLACEFACILITYHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ZIPPLACEFACILITYHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_ZIPPLACEFACILITYHISTORY ADD (
  CONSTRAINT FKSTD_ZIPPLACEFCLTYHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_ZIPPLACEFACILITY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITYHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ZIPPLACEFACILITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPPLACEFACILITY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPPLACEFACILITY
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(1 BYTE)                     NOT NULL,
  NAME         VARCHAR2(75 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPPLACEFACILITY ON SDSADM.STD_ZIPPLACEFACILITY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_ZIPPLACEFACILITYCODE ON SDSADM.STD_ZIPPLACEFACILITY
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_ZIPPLACEFACILITYNAME ON SDSADM.STD_ZIPPLACEFACILITY
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipPlaceFacility
after DELETE
ON SDSADM.STD_ZIPPLACEFACILITY
BEGIN
	-- update the table for STD_ZipPlaceFacility operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlaceFacility';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipPlaceFacility
after INSERT
ON SDSADM.STD_ZIPPLACEFACILITY
BEGIN
	-- update the table for STD_ZipPlaceFacility operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlaceFacility';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipPlaceFacility
after UPDATE
ON SDSADM.STD_ZIPPLACEFACILITY
BEGIN
	-- update the table for STD_ZipPlaceFacility operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlaceFacility';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPPLACEFACILITY FOR SDSADM.STD_ZIPPLACEFACILITY;


ALTER TABLE SDSADM.STD_ZIPPLACEFACILITY ADD (
  CONSTRAINT PK_STD_ZIPPLACEFACILITY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ZIPPLACEFACILITY
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_ZIPPLACEFACILITYCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_ZIPPLACEFACILITYCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_ZIPPLACEFACILITYNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_ZIPPLACEFACILITYNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPPLACEFACILITY TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITY TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITY TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPPLACEFACILITY TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPPLACEFACILITY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPPLACEFACILITY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ZIPPLACE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPPLACE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPPLACE
(
  ID                     NUMBER(20)             NOT NULL,
  ZIPPLACEKEY            VARCHAR2(6 BYTE)       NOT NULL,
  NAME                   VARCHAR2(28 BYTE)      NOT NULL,
  ISAPPROVEDMAILINGNAME  CHAR(1 BYTE)           NOT NULL,
  ABBREVIATEDNAME        VARCHAR2(13 BYTE),
  ZIPPLACEFACILITY_ID    NUMBER(20),
  VERSION                INTEGER                NOT NULL,
  CREATED                TIMESTAMP(6)           NOT NULL,
  UPDATED                TIMESTAMP(6),
  CREATEDBY              VARCHAR2(32 BYTE)      NOT NULL,
  UPDATEDBY              VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPPLACE ON SDSADM.STD_ZIPPLACE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_ZIPPLACEZIPPLACEKEY ON SDSADM.STD_ZIPPLACE
(ZIPPLACEKEY)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipPlace
after DELETE
ON SDSADM.STD_ZIPPLACE
BEGIN
	-- update the table for STD_ZipPlace operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlace';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipPlace
after INSERT
ON SDSADM.STD_ZIPPLACE
BEGIN
	-- update the table for STD_ZipPlace operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlace';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipPlace
after UPDATE
ON SDSADM.STD_ZIPPLACE
BEGIN
	-- update the table for STD_ZipPlace operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipPlace';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPPLACE FOR SDSADM.STD_ZIPPLACE;


ALTER TABLE SDSADM.STD_ZIPPLACE ADD (
  CONSTRAINT PK_STD_ZIPPLACE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ZIPPLACE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_ZIPPLACEZIPPLACEKEY
  UNIQUE (ZIPPLACEKEY)
  USING INDEX SDSADM.UQSTD_ZIPPLACEZIPPLACEKEY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_ZIPPLACE ADD (
  CONSTRAINT FKSTD_ZIPPLACEZIPPLACEFACILITY 
  FOREIGN KEY (ZIPPLACEFACILITY_ID) 
  REFERENCES SDSADM.STD_ZIPPLACEFACILITY (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPPLACE TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPPLACE TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPPLACE TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPPLACE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPPLACE TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPPLACE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPPLACE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPPLACE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPPLACE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ZIPCODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPCODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPCODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPCODEHISTORY ON SDSADM.STD_ZIPCODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipCodeHistory
after DELETE
ON SDSADM.STD_ZIPCODEHISTORY
BEGIN
	-- update the table for STD_ZipCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipCodeHistory
after INSERT
ON SDSADM.STD_ZIPCODEHISTORY
BEGIN
	-- update the table for STD_ZipCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipCodeHistory
after UPDATE
ON SDSADM.STD_ZIPCODEHISTORY
BEGIN
	-- update the table for STD_ZipCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPCODEHISTORY FOR SDSADM.STD_ZIPCODEHISTORY;


ALTER TABLE SDSADM.STD_ZIPCODEHISTORY ADD (
  CONSTRAINT PK_STD_ZIPCODEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ZIPCODEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_ZIPCODEHISTORY ADD (
  CONSTRAINT FKSTD_ZIPCODEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_ZIPCODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPCODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPCODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPCODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPCODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPCODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPCODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPCODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPCODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPCODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ZIPCODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPCODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPCODE
(
  ID                    NUMBER(20)              NOT NULL,
  ZIPCODE               VARCHAR2(10 BYTE)       NOT NULL,
  ZIPCLASSIFICATION_ID  NUMBER(20),
  PREFERREDZIPPLACE_ID  NUMBER(20),
  STATE_ID              NUMBER(20)              NOT NULL,
  COUNTYNUMBER          CHAR(3 BYTE),
  VERSION               INTEGER                 NOT NULL,
  CREATED               TIMESTAMP(6)            NOT NULL,
  UPDATED               TIMESTAMP(6),
  CREATEDBY             VARCHAR2(32 BYTE)       NOT NULL,
  UPDATEDBY             VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPCODE ON SDSADM.STD_ZIPCODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_ZIPCODEZIPCODE ON SDSADM.STD_ZIPCODE
(ZIPCODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipCode
after DELETE
ON SDSADM.STD_ZIPCODE
BEGIN
	-- update the table for STD_ZipCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipCode
after INSERT
ON SDSADM.STD_ZIPCODE
BEGIN
	-- update the table for STD_ZipCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipCode
after UPDATE
ON SDSADM.STD_ZIPCODE
BEGIN
	-- update the table for STD_ZipCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPCODE FOR SDSADM.STD_ZIPCODE;


ALTER TABLE SDSADM.STD_ZIPCODE ADD (
  CONSTRAINT PK_STD_ZIPCODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ZIPCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_ZIPCODEZIPCODE
  UNIQUE (ZIPCODE)
  USING INDEX SDSADM.UQSTD_ZIPCODEZIPCODE
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_ZIPCODE ADD (
  CONSTRAINT FKSTD_ZIPCODEPREFERREDZIPPLACE 
  FOREIGN KEY (PREFERREDZIPPLACE_ID) 
  REFERENCES SDSADM.STD_ZIPPLACE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FKSTD_ZIPCODESTATE 
  FOREIGN KEY (STATE_ID) 
  REFERENCES SDSADM.STD_STATE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FKSTD_ZIPCODEZIPCLASSIFICATION 
  FOREIGN KEY (ZIPCLASSIFICATION_ID) 
  REFERENCES SDSADM.STD_ZIPCLASSIFICATION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPCODE TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPCODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPCODE TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPCODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPCODE TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPCODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPCODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPCODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPCODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ZIPCLASSIFICATIONHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPCLASSIFICATIONHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPCLASSIFICATIONHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPCLASSIFICATIONHSTRY ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipClssfctnHstry
after DELETE
ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY
BEGIN
	-- update the table for STD_ZipClassificationHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipClassificationHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipClssfctnHstry
after INSERT
ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY
BEGIN
	-- update the table for STD_ZipClassificationHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipClassificationHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipClssfctnHstry
after UPDATE
ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY
BEGIN
	-- update the table for STD_ZipClassificationHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipClassificationHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPCLASSIFICATIONHISTORY FOR SDSADM.STD_ZIPCLASSIFICATIONHISTORY;


ALTER TABLE SDSADM.STD_ZIPCLASSIFICATIONHISTORY ADD (
  CONSTRAINT PK_STD_ZIPCLASSIFICATIONHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ZIPCLASSIFICATIONHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_ZIPCLASSIFICATIONHISTORY ADD (
  CONSTRAINT FKSTD_ZIPCLSSFCTNHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_ZIPCLASSIFICATION (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATIONHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ZIPCLASSIFICATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPCLASSIFICATION CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPCLASSIFICATION
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(4 BYTE)                 NOT NULL,
  NAME         VARCHAR2(20 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(75 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPCLASSIFICATION ON SDSADM.STD_ZIPCLASSIFICATION
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_ZIPCLASSIFICATIONCODE ON SDSADM.STD_ZIPCLASSIFICATION
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_ZIPCLASSIFICATIONNAME ON SDSADM.STD_ZIPCLASSIFICATION
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipClassification
after DELETE
ON SDSADM.STD_ZIPCLASSIFICATION
BEGIN
	-- update the table for STD_ZipClassification operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipClassification';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipClassification
after INSERT
ON SDSADM.STD_ZIPCLASSIFICATION
BEGIN
	-- update the table for STD_ZipClassification operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipClassification';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipClassification
after UPDATE
ON SDSADM.STD_ZIPCLASSIFICATION
BEGIN
	-- update the table for STD_ZipClassification operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipClassification';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPCLASSIFICATION FOR SDSADM.STD_ZIPCLASSIFICATION;


ALTER TABLE SDSADM.STD_ZIPCLASSIFICATION ADD (
  CONSTRAINT PK_STD_ZIPCLASSIFICATION
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ZIPCLASSIFICATION
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_ZIPCLASSIFICATIONCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_ZIPCLASSIFICATIONCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_ZIPCLASSIFICATIONNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_ZIPCLASSIFICATIONNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPCLASSIFICATION TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATION TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATION TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATION TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPCLASSIFICATION TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATION TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPCLASSIFICATION TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATION TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPCLASSIFICATION TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ZIPASSIGNMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ZIPASSIGNMENT CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ZIPASSIGNMENT
(
  ZIPCODE_ID   NUMBER(20)                       NOT NULL,
  ZIPPLACE_ID  NUMBER(20)                       NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ZIPASSIGNMENT ON SDSADM.STD_ZIPASSIGNMENT
(ZIPCODE_ID, ZIPPLACE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ZipAssignment
after DELETE
ON SDSADM.STD_ZIPASSIGNMENT
BEGIN
	-- update the table for STD_ZipAssignment operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipAssignment';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ZipAssignment
after INSERT
ON SDSADM.STD_ZIPASSIGNMENT
BEGIN
	-- update the table for STD_ZipAssignment operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipAssignment';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ZipAssignment
after UPDATE
ON SDSADM.STD_ZIPASSIGNMENT
BEGIN
	-- update the table for STD_ZipAssignment operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ZipAssignment';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ZIPASSIGNMENT FOR SDSADM.STD_ZIPASSIGNMENT;


ALTER TABLE SDSADM.STD_ZIPASSIGNMENT ADD (
  CONSTRAINT PK_STD_ZIPASSIGNMENT
  PRIMARY KEY
  (ZIPCODE_ID, ZIPPLACE_ID)
  USING INDEX SDSADM.PK_STD_ZIPASSIGNMENT
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_ZIPASSIGNMENT ADD (
  CONSTRAINT FKSTD_ZIPASSIGNMENTZIPCODE 
  FOREIGN KEY (ZIPCODE_ID) 
  REFERENCES SDSADM.STD_ZIPCODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FKSTD_ZIPASSIGNMENTZIPPLACE 
  FOREIGN KEY (ZIPPLACE_ID) 
  REFERENCES SDSADM.STD_ZIPPLACE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ZIPASSIGNMENT TO ADR;

GRANT SELECT ON SDSADM.STD_ZIPASSIGNMENT TO ADREXT;

GRANT SELECT ON SDSADM.STD_ZIPASSIGNMENT TO EESRV;

GRANT SELECT ON SDSADM.STD_ZIPASSIGNMENT TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ZIPASSIGNMENT TO LOBR;

GRANT SELECT ON SDSADM.STD_ZIPASSIGNMENT TO PSIM;

GRANT DELETE, INSERT, SELECT, UPDATE ON SDSADM.STD_ZIPASSIGNMENT TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ZIPASSIGNMENT TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ZIPASSIGNMENT TO SDS_SELECT;
ALTER TABLE SDSADM.STD_YESNOCODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_YESNOCODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_YESNOCODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_YESNOCODEHISTORY ON SDSADM.STD_YESNOCODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_YesNoCodeHistory
after DELETE
ON SDSADM.STD_YESNOCODEHISTORY
BEGIN
	-- update the table for STD_YesNoCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_YesNoCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_YesNoCodeHistory
after INSERT
ON SDSADM.STD_YESNOCODEHISTORY
BEGIN
	-- update the table for STD_YesNoCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_YesNoCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_YesNoCodeHistory
after UPDATE
ON SDSADM.STD_YESNOCODEHISTORY
BEGIN
	-- update the table for STD_YesNoCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_YesNoCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_YESNOCODEHISTORY FOR SDSADM.STD_YESNOCODEHISTORY;


ALTER TABLE SDSADM.STD_YESNOCODEHISTORY ADD (
  CONSTRAINT PK_STD_YESNOCODEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_YESNOCODEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_YESNOCODEHISTORY ADD (
  CONSTRAINT FKSTD_YESNOCODEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_YESNOCODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_YESNOCODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_YESNOCODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_YESNOCODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_YESNOCODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_YESNOCODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_YESNOCODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_YESNOCODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_YESNOCODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_YESNOCODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_YESNOCODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_YESNOCODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_YESNOCODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  ALPHACODE    VARCHAR2(1 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_YESNOCODE ON SDSADM.STD_YESNOCODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_YESNOCODEALPHACODE ON SDSADM.STD_YESNOCODE
(ALPHACODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_YESNOCODECODE ON SDSADM.STD_YESNOCODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_YESNOCODENAME ON SDSADM.STD_YESNOCODE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_YesNoCode
after DELETE
ON SDSADM.STD_YESNOCODE
BEGIN
	-- update the table for STD_YesNoCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_YesNoCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_YesNoCode
after INSERT
ON SDSADM.STD_YESNOCODE
BEGIN
	-- update the table for STD_YesNoCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_YesNoCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_YesNoCode
after UPDATE
ON SDSADM.STD_YESNOCODE
BEGIN
	-- update the table for STD_YesNoCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_YesNoCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_YESNOCODE FOR SDSADM.STD_YESNOCODE;


ALTER TABLE SDSADM.STD_YESNOCODE ADD (
  CONSTRAINT PK_STD_YESNOCODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_YESNOCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_YESNOCODEALPHACODE
  UNIQUE (ALPHACODE)
  USING INDEX SDSADM.UQSTD_YESNOCODEALPHACODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_YESNOCODECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_YESNOCODECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_YESNOCODENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_YESNOCODENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_YESNOCODE TO ADR;

GRANT SELECT ON SDSADM.STD_YESNOCODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_YESNOCODE TO EESRV;

GRANT SELECT ON SDSADM.STD_YESNOCODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_YESNOCODE TO LOBR;

GRANT SELECT ON SDSADM.STD_YESNOCODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_YESNOCODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_YESNOCODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_YESNOCODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_VBAQUERYSTATUSTYPEHSTRY ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_VBAQuerySttsTypHstry
after DELETE
ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY
BEGIN
	-- update the table for STD_VBAQueryStatusTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_VBAQueryStatusTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_VBAQuerySttsTypHstry
after INSERT
ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY
BEGIN
	-- update the table for STD_VBAQueryStatusTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_VBAQueryStatusTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_VBAQuerySttsTypHstry
after UPDATE
ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY
BEGIN
	-- update the table for STD_VBAQueryStatusTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_VBAQueryStatusTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_VBAQUERYSTATUSTYPEHISTORY FOR SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY;


ALTER TABLE SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY ADD (
  CONSTRAINT PK_STD_VBAQUERYSTATUSTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_VBAQUERYSTATUSTYPEHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY ADD (
  CONSTRAINT FKSTD_VBAQUERYSTTSTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_VBAQUERYSTATUSTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_VBAQUERYSTATUSTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_VBAQUERYSTATUSTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_VBAQUERYSTATUSTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(60 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_VBAQUERYSTATUSTYPE ON SDSADM.STD_VBAQUERYSTATUSTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_VBAQUERYSTATUSTYPECODE ON SDSADM.STD_VBAQUERYSTATUSTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_VBAQUERYSTATUSTYPENAME ON SDSADM.STD_VBAQUERYSTATUSTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_VBAQueryStatusType
after DELETE
ON SDSADM.STD_VBAQUERYSTATUSTYPE
BEGIN
	-- update the table for STD_VBAQueryStatusType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_VBAQueryStatusType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_VBAQueryStatusType
after INSERT
ON SDSADM.STD_VBAQUERYSTATUSTYPE
BEGIN
	-- update the table for STD_VBAQueryStatusType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_VBAQueryStatusType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_VBAQueryStatusType
after UPDATE
ON SDSADM.STD_VBAQUERYSTATUSTYPE
BEGIN
	-- update the table for STD_VBAQueryStatusType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_VBAQueryStatusType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_VBAQUERYSTATUSTYPE FOR SDSADM.STD_VBAQUERYSTATUSTYPE;


ALTER TABLE SDSADM.STD_VBAQUERYSTATUSTYPE ADD (
  CONSTRAINT PK_STD_VBAQUERYSTATUSTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_VBAQUERYSTATUSTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_VBAQUERYSTATUSTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_VBAQUERYSTATUSTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_VBAQUERYSTATUSTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_VBAQUERYSTATUSTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_VBAQUERYSTATUSTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_VBAQUERYSTATUSTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_VBAQUERYSTATUSTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_VBAQUERYSTATUSTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_USERGROUPTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_USERGROUPTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_USERGROUPTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_USERGROUPTYPEHISTORY ON SDSADM.STD_USERGROUPTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_UserGroupTypeHistory
after DELETE
ON SDSADM.STD_USERGROUPTYPEHISTORY
BEGIN
	-- update the table for STD_UserGroupTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_UserGroupTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_UserGroupTypeHistory
after INSERT
ON SDSADM.STD_USERGROUPTYPEHISTORY
BEGIN
	-- update the table for STD_UserGroupTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_UserGroupTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_UserGroupTypeHistory
after UPDATE
ON SDSADM.STD_USERGROUPTYPEHISTORY
BEGIN
	-- update the table for STD_UserGroupTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_UserGroupTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_USERGROUPTYPEHISTORY FOR SDSADM.STD_USERGROUPTYPEHISTORY;


ALTER TABLE SDSADM.STD_USERGROUPTYPEHISTORY ADD (
  CONSTRAINT PK_STD_USERGROUPTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_USERGROUPTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_USERGROUPTYPEHISTORY ADD (
  CONSTRAINT FKSTD_USERGROUPTYPEHISTORYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_USERGROUPTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_USERGROUPTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_USERGROUPTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_USERGROUPTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_USERGROUPTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_USERGROUPTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_USERGROUPTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(40 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_USERGROUPTYPE ON SDSADM.STD_USERGROUPTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_USERGROUPTYPECODE ON SDSADM.STD_USERGROUPTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_USERGROUPTYPENAME ON SDSADM.STD_USERGROUPTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_UserGroupType
after DELETE
ON SDSADM.STD_USERGROUPTYPE
BEGIN
	-- update the table for STD_UserGroupType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_UserGroupType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_UserGroupType
after INSERT
ON SDSADM.STD_USERGROUPTYPE
BEGIN
	-- update the table for STD_UserGroupType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_UserGroupType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_UserGroupType
after UPDATE
ON SDSADM.STD_USERGROUPTYPE
BEGIN
	-- update the table for STD_UserGroupType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_UserGroupType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_USERGROUPTYPE FOR SDSADM.STD_USERGROUPTYPE;


ALTER TABLE SDSADM.STD_USERGROUPTYPE ADD (
  CONSTRAINT PK_STD_USERGROUPTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_USERGROUPTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_USERGROUPTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_USERGROUPTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_USERGROUPTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_USERGROUPTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_USERGROUPTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_USERGROUPTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_USERGROUPTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_USERGROUPTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_TRANSACTIONTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_TRANSACTIONTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_TRANSACTIONTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_TRANSACTIONTYPEHISTORY ON SDSADM.STD_TRANSACTIONTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_TransactionTypeHstry
after DELETE
ON SDSADM.STD_TRANSACTIONTYPEHISTORY
BEGIN
	-- update the table for STD_TransactionTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TransactionTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_TransactionTypeHstry
after INSERT
ON SDSADM.STD_TRANSACTIONTYPEHISTORY
BEGIN
	-- update the table for STD_TransactionTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TransactionTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_TransactionTypeHstry
after UPDATE
ON SDSADM.STD_TRANSACTIONTYPEHISTORY
BEGIN
	-- update the table for STD_TransactionTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TransactionTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_TRANSACTIONTYPEHISTORY FOR SDSADM.STD_TRANSACTIONTYPEHISTORY;


ALTER TABLE SDSADM.STD_TRANSACTIONTYPEHISTORY ADD (
  CONSTRAINT PK_STD_TRANSACTIONTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_TRANSACTIONTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_TRANSACTIONTYPEHISTORY ADD (
  CONSTRAINT FKSTD_TRANSACTIONTYPEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_TRANSACTIONTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_TRANSACTIONTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_TRANSACTIONTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_TRANSACTIONTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(2 BYTE)                     NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_TRANSACTIONTYPE ON SDSADM.STD_TRANSACTIONTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_TRANSACTIONTYPECODE ON SDSADM.STD_TRANSACTIONTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_TRANSACTIONTYPENAME ON SDSADM.STD_TRANSACTIONTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_TransactionType
after DELETE
ON SDSADM.STD_TRANSACTIONTYPE
BEGIN
	-- update the table for STD_TransactionType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TransactionType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_TransactionType
after INSERT
ON SDSADM.STD_TRANSACTIONTYPE
BEGIN
	-- update the table for STD_TransactionType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TransactionType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_TransactionType
after UPDATE
ON SDSADM.STD_TRANSACTIONTYPE
BEGIN
	-- update the table for STD_TransactionType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TransactionType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_TRANSACTIONTYPE FOR SDSADM.STD_TRANSACTIONTYPE;


ALTER TABLE SDSADM.STD_TRANSACTIONTYPE ADD (
  CONSTRAINT PK_STD_TRANSACTIONTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_TRANSACTIONTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_TRANSACTIONTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_TRANSACTIONTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_TRANSACTIONTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_TRANSACTIONTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_TRANSACTIONTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_TRANSACTIONTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_TRANSACTIONTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_TRANSACTIONTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_TERMINATIONREASONHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_TERMINATIONREASONHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_TERMINATIONREASONHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_TERMINATIONREASONHSTRY ON SDSADM.STD_TERMINATIONREASONHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_TerminationRsnHstry
after DELETE
ON SDSADM.STD_TERMINATIONREASONHISTORY
BEGIN
	-- update the table for STD_TerminationReasonHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TerminationReasonHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_TerminationRsnHstry
after INSERT
ON SDSADM.STD_TERMINATIONREASONHISTORY
BEGIN
	-- update the table for STD_TerminationReasonHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TerminationReasonHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_TerminationRsnHstry
after UPDATE
ON SDSADM.STD_TERMINATIONREASONHISTORY
BEGIN
	-- update the table for STD_TerminationReasonHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TerminationReasonHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_TERMINATIONREASONHISTORY FOR SDSADM.STD_TERMINATIONREASONHISTORY;


ALTER TABLE SDSADM.STD_TERMINATIONREASONHISTORY ADD (
  CONSTRAINT PK_STD_TERMINATIONREASONHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_TERMINATIONREASONHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_TERMINATIONREASONHISTORY ADD (
  CONSTRAINT FKSTD_TERMINATIONRSNHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_TERMINATIONREASON (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_TERMINATIONREASONHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASONHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASONHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASONHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_TERMINATIONREASONHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASONHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_TERMINATIONREASONHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASONHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASONHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_TERMINATIONREASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_TERMINATIONREASON CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_TERMINATIONREASON
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(8 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_TERMINATIONREASON ON SDSADM.STD_TERMINATIONREASON
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_TERMINATIONREASONCODE ON SDSADM.STD_TERMINATIONREASON
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_TERMINATIONREASONNAME ON SDSADM.STD_TERMINATIONREASON
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_TerminationReason
after DELETE
ON SDSADM.STD_TERMINATIONREASON
BEGIN
	-- update the table for STD_TerminationReason operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TerminationReason';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_TerminationReason
after INSERT
ON SDSADM.STD_TERMINATIONREASON
BEGIN
	-- update the table for STD_TerminationReason operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TerminationReason';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_TerminationReason
after UPDATE
ON SDSADM.STD_TERMINATIONREASON
BEGIN
	-- update the table for STD_TerminationReason operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_TerminationReason';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_TERMINATIONREASON FOR SDSADM.STD_TERMINATIONREASON;


ALTER TABLE SDSADM.STD_TERMINATIONREASON ADD (
  CONSTRAINT PK_STD_TERMINATIONREASON
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_TERMINATIONREASON
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_TERMINATIONREASONCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_TERMINATIONREASONCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_TERMINATIONREASONNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_TERMINATIONREASONNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_TERMINATIONREASON TO ADR;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASON TO ADREXT;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASON TO EESRV;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASON TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_TERMINATIONREASON TO LOBR;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASON TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_TERMINATIONREASON TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASON TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_TERMINATIONREASON TO SDS_SELECT;
ALTER TABLE SDSADM.STD_TABLEMANAGER
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_TABLEMANAGER CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_TABLEMANAGER
(
  ID             NUMBER(20)                     NOT NULL,
  TABLENAME      VARCHAR2(31 BYTE)              NOT NULL,
  RELEASENUMBER  VARCHAR2(5 BYTE)               NOT NULL,
  RELEASEDATE    VARCHAR2(15 BYTE),
  LASTPOPULATED  VARCHAR2(15 BYTE),
  LASTUPDATED    TIMESTAMP(6)                   NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_TABLEMANAGER ON SDSADM.STD_TABLEMANAGER
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_TABLEMANAGERTABLENAME ON SDSADM.STD_TABLEMANAGER
(TABLENAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM STD_TABLEMANAGER FOR SDSADM.STD_TABLEMANAGER;


ALTER TABLE SDSADM.STD_TABLEMANAGER ADD (
  CONSTRAINT PK_STD_TABLEMANAGER
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_TABLEMANAGER
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_TABLEMANAGERTABLENAME
  UNIQUE (TABLENAME)
  USING INDEX SDSADM.UQSTD_TABLEMANAGERTABLENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_TABLEMANAGER TO ADR;

GRANT SELECT ON SDSADM.STD_TABLEMANAGER TO ADREXT;

GRANT SELECT ON SDSADM.STD_TABLEMANAGER TO EESRV;

GRANT SELECT ON SDSADM.STD_TABLEMANAGER TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_TABLEMANAGER TO LOBR;

GRANT SELECT ON SDSADM.STD_TABLEMANAGER TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_TABLEMANAGER TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_TABLEMANAGER TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SVCDSCHRGCDHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SVCDSCHRGCDHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SVCDSCHRGCDHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SVCDSCHRGCDHISTORY ON SDSADM.STD_SVCDSCHRGCDHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SvcDschrgCdHistory
after DELETE
ON SDSADM.STD_SVCDSCHRGCDHISTORY
BEGIN
	-- update the table for STD_SvcDschrgCdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SvcDschrgCdHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SvcDschrgCdHistory
after INSERT
ON SDSADM.STD_SVCDSCHRGCDHISTORY
BEGIN
	-- update the table for STD_SvcDschrgCdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SvcDschrgCdHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SvcDschrgCdHistory
after UPDATE
ON SDSADM.STD_SVCDSCHRGCDHISTORY
BEGIN
	-- update the table for STD_SvcDschrgCdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SvcDschrgCdHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SVCDSCHRGCDHISTORY FOR SDSADM.STD_SVCDSCHRGCDHISTORY;


ALTER TABLE SDSADM.STD_SVCDSCHRGCDHISTORY ADD (
  CONSTRAINT PK_STD_SVCDSCHRGCDHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SVCDSCHRGCDHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SVCDSCHRGCDHISTORY ADD (
  CONSTRAINT FKSTD_SVCDSCHRGCDHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SERVICEDISCHARGECODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SVCDSCHRGCDHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SVCDSCHRGCDHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SVCDSCHRGCDHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SVCDSCHRGCDHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SVCDSCHRGCDHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SVCDSCHRGCDHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SVCDSCHRGCDHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SVCDSCHRGCDHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SVCDSCHRGCDHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_STATISTICALAREATYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_STATISTICALAREATYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_STATISTICALAREATYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_STATISTICALAREATYPHSTRY ON SDSADM.STD_STATISTICALAREATYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_StatisticalArTypHstry
after DELETE
ON SDSADM.STD_STATISTICALAREATYPEHISTORY
BEGIN
	-- update the table for STD_StatisticalAreaTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalAreaTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_StatisticalArTypHstry
after INSERT
ON SDSADM.STD_STATISTICALAREATYPEHISTORY
BEGIN
	-- update the table for STD_StatisticalAreaTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalAreaTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_StatisticalArTypHstry
after UPDATE
ON SDSADM.STD_STATISTICALAREATYPEHISTORY
BEGIN
	-- update the table for STD_StatisticalAreaTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalAreaTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_STATISTICALAREATYPEHISTORY FOR SDSADM.STD_STATISTICALAREATYPEHISTORY;


ALTER TABLE SDSADM.STD_STATISTICALAREATYPEHISTORY ADD (
  CONSTRAINT PK_STD_STATISTICALAREATYPHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_STATISTICALAREATYPHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_STATISTICALAREATYPEHISTORY ADD (
  CONSTRAINT FKSTD_STTSTCLARTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_STATISTICALAREATYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_STATISTICALAREATYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_STATISTICALAREATYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_STATISTICALAREATYPE
(
  ID             NUMBER(20)                     NOT NULL,
  CODE           VARCHAR2(11 BYTE)              NOT NULL,
  NAME           VARCHAR2(45 BYTE)              NOT NULL,
  DESCRIPTION    VARCHAR2(60 BYTE),
  PARENTTYPE_ID  NUMBER(20),
  VERSION        INTEGER                        NOT NULL,
  CREATED        TIMESTAMP(6)                   NOT NULL,
  UPDATED        TIMESTAMP(6),
  CREATEDBY      VARCHAR2(32 BYTE)              NOT NULL,
  UPDATEDBY      VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_STATISTICALAREATYPE ON SDSADM.STD_STATISTICALAREATYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_STATISTICALAREATYPECODE ON SDSADM.STD_STATISTICALAREATYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_STATISTICALAREATYPENAME ON SDSADM.STD_STATISTICALAREATYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_StatisticalAreaType
after DELETE
ON SDSADM.STD_STATISTICALAREATYPE
BEGIN
	-- update the table for STD_StatisticalAreaType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalAreaType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_StatisticalAreaType
after INSERT
ON SDSADM.STD_STATISTICALAREATYPE
BEGIN
	-- update the table for STD_StatisticalAreaType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalAreaType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_StatisticalAreaType
after UPDATE
ON SDSADM.STD_STATISTICALAREATYPE
BEGIN
	-- update the table for STD_StatisticalAreaType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalAreaType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_STATISTICALAREATYPE FOR SDSADM.STD_STATISTICALAREATYPE;


ALTER TABLE SDSADM.STD_STATISTICALAREATYPE ADD (
  CONSTRAINT PK_STD_STATISTICALAREATYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_STATISTICALAREATYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_STATISTICALAREATYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_STATISTICALAREATYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_STATISTICALAREATYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_STATISTICALAREATYPENAME
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_STATISTICALAREATYPE ADD (
  CONSTRAINT FKSTD_STATISTICALARTYPPRNTTYP 
  FOREIGN KEY (PARENTTYPE_ID) 
  REFERENCES SDSADM.STD_STATISTICALAREATYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_STATISTICALAREATYPE TO ADR;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_STATISTICALAREATYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATISTICALAREATYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_STATISTICALAREATYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_STATISTICALAREAHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_STATISTICALAREAHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_STATISTICALAREAHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_STATISTICALAREAHISTORY ON SDSADM.STD_STATISTICALAREAHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_StatisticalAreaHstry
after DELETE
ON SDSADM.STD_STATISTICALAREAHISTORY
BEGIN
	-- update the table for STD_StatisticalAreaHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalAreaHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_StatisticalAreaHstry
after INSERT
ON SDSADM.STD_STATISTICALAREAHISTORY
BEGIN
	-- update the table for STD_StatisticalAreaHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalAreaHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_StatisticalAreaHstry
after UPDATE
ON SDSADM.STD_STATISTICALAREAHISTORY
BEGIN
	-- update the table for STD_StatisticalAreaHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalAreaHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_STATISTICALAREAHISTORY FOR SDSADM.STD_STATISTICALAREAHISTORY;


ALTER TABLE SDSADM.STD_STATISTICALAREAHISTORY ADD (
  CONSTRAINT PK_STD_STATISTICALAREAHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_STATISTICALAREAHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_STATISTICALAREAHISTORY ADD (
  CONSTRAINT FKSTD_STATISTICALAREAHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_STATISTICALAREA (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_STATISTICALAREAHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_STATISTICALAREAHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_STATISTICALAREAHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_STATISTICALAREAHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_STATISTICALAREAHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_STATISTICALAREAHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATISTICALAREAHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_STATISTICALAREAHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_STATISTICALAREAHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_STATISTICALAREA
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_STATISTICALAREA CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_STATISTICALAREA
(
  ID                      NUMBER(20)            NOT NULL,
  CODE                    NUMBER(10)            NOT NULL,
  TITLE                   VARCHAR2(100 BYTE)    NOT NULL,
  STATISTICALAREATYPE_ID  NUMBER(20)            NOT NULL,
  PARENT_ID               NUMBER(20),
  VERSION                 INTEGER               NOT NULL,
  CREATED                 TIMESTAMP(6)          NOT NULL,
  UPDATED                 TIMESTAMP(6),
  CREATEDBY               VARCHAR2(32 BYTE)     NOT NULL,
  UPDATEDBY               VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_STATISTICALAREA ON SDSADM.STD_STATISTICALAREA
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_STATISTICALAREACODE ON SDSADM.STD_STATISTICALAREA
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_StatisticalArea
after DELETE
ON SDSADM.STD_STATISTICALAREA
BEGIN
	-- update the table for STD_StatisticalArea operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalArea';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_StatisticalArea
after INSERT
ON SDSADM.STD_STATISTICALAREA
BEGIN
	-- update the table for STD_StatisticalArea operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalArea';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_StatisticalArea
after UPDATE
ON SDSADM.STD_STATISTICALAREA
BEGIN
	-- update the table for STD_StatisticalArea operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatisticalArea';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_STATISTICALAREA FOR SDSADM.STD_STATISTICALAREA;


ALTER TABLE SDSADM.STD_STATISTICALAREA ADD (
  CONSTRAINT PK_STD_STATISTICALAREA
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_STATISTICALAREA
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_STATISTICALAREACODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_STATISTICALAREACODE
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_STATISTICALAREA ADD (
  CONSTRAINT FKSTD_STATISTICALAREAPARENT 
  FOREIGN KEY (PARENT_ID) 
  REFERENCES SDSADM.STD_STATISTICALAREA (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FKSTD_STTSTCLARSTTSTCLARTYP 
  FOREIGN KEY (STATISTICALAREATYPE_ID) 
  REFERENCES SDSADM.STD_STATISTICALAREATYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_STATISTICALAREA TO ADR;

GRANT SELECT ON SDSADM.STD_STATISTICALAREA TO ADREXT;

GRANT SELECT ON SDSADM.STD_STATISTICALAREA TO EESRV;

GRANT SELECT ON SDSADM.STD_STATISTICALAREA TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_STATISTICALAREA TO LOBR;

GRANT SELECT ON SDSADM.STD_STATISTICALAREA TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATISTICALAREA TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_STATISTICALAREA TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_STATISTICALAREA TO SDS_SELECT;
ALTER TABLE SDSADM.STD_STATEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_STATEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_STATEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_STATEHISTORY ON SDSADM.STD_STATEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_StateHistory
after DELETE
ON SDSADM.STD_STATEHISTORY
BEGIN
	-- update the table for STD_StateHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StateHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_StateHistory
after INSERT
ON SDSADM.STD_STATEHISTORY
BEGIN
	-- update the table for STD_StateHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StateHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_StateHistory
after UPDATE
ON SDSADM.STD_STATEHISTORY
BEGIN
	-- update the table for STD_StateHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StateHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_STATEHISTORY FOR SDSADM.STD_STATEHISTORY;


ALTER TABLE SDSADM.STD_STATEHISTORY ADD (
  CONSTRAINT PK_STD_STATEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_STATEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_STATEHISTORY ADD (
  CONSTRAINT FKSTD_STATEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_STATE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_STATEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_STATEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_STATEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_STATEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_STATEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_STATEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_STATEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_STATEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_STATE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_STATE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_STATE
(
  ID          NUMBER(20)                        NOT NULL,
  NAME        VARCHAR2(50 BYTE)                 NOT NULL,
  POSTALNAME  VARCHAR2(30 BYTE)                 NOT NULL,
  FIPSCODE    CHAR(2 BYTE),
  COUNTRY_ID  NUMBER(20)                        NOT NULL,
  VERSION     INTEGER                           NOT NULL,
  CREATED     TIMESTAMP(6)                      NOT NULL,
  UPDATED     TIMESTAMP(6),
  CREATEDBY   VARCHAR2(32 BYTE)                 NOT NULL,
  UPDATEDBY   VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_STATE ON SDSADM.STD_STATE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_STATEPOSTALNAME ON SDSADM.STD_STATE
(POSTALNAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_State
after DELETE
ON SDSADM.STD_STATE
BEGIN
	-- update the table for STD_State operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_State';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_State
after INSERT
ON SDSADM.STD_STATE
BEGIN
	-- update the table for STD_State operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_State';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_State
after UPDATE
ON SDSADM.STD_STATE
BEGIN
	-- update the table for STD_State operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_State';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_STATE FOR SDSADM.STD_STATE;


ALTER TABLE SDSADM.STD_STATE ADD (
  CONSTRAINT PK_STD_STATE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_STATE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_STATEPOSTALNAME
  UNIQUE (POSTALNAME)
  USING INDEX SDSADM.UQSTD_STATEPOSTALNAME
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_STATE ADD (
  CONSTRAINT FKSTD_STATECOUNTRY 
  FOREIGN KEY (COUNTRY_ID) 
  REFERENCES SDSADM.STD_COUNTRY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_STATE TO ADR;

GRANT SELECT ON SDSADM.STD_STATE TO ADREXT;

GRANT SELECT ON SDSADM.STD_STATE TO EESRV;

GRANT SELECT ON SDSADM.STD_STATE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_STATE TO LOBR;

GRANT SELECT ON SDSADM.STD_STATE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_STATE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_STATE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_STATE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_STATCNTYXREF
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_STATCNTYXREF CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_STATCNTYXREF
(
  COUNTY_ID           NUMBER(20)                NOT NULL,
  STATISTICALAREA_ID  NUMBER(20)                NOT NULL,
  CREATED             TIMESTAMP(6)              NOT NULL,
  UPDATED             TIMESTAMP(6),
  CREATEDBY           VARCHAR2(32 BYTE)         NOT NULL,
  UPDATEDBY           VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_STATCNTYXREF ON SDSADM.STD_STATCNTYXREF
(COUNTY_ID, STATISTICALAREA_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_StatCntyXref
after DELETE
ON SDSADM.STD_STATCNTYXREF
BEGIN
	-- update the table for STD_StatCntyXref operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatCntyXref';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_StatCntyXref
after INSERT
ON SDSADM.STD_STATCNTYXREF
BEGIN
	-- update the table for STD_StatCntyXref operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatCntyXref';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_StatCntyXref
after UPDATE
ON SDSADM.STD_STATCNTYXREF
BEGIN
	-- update the table for STD_StatCntyXref operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_StatCntyXref';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_STATCNTYXREF FOR SDSADM.STD_STATCNTYXREF;


ALTER TABLE SDSADM.STD_STATCNTYXREF ADD (
  CONSTRAINT PK_STD_STATCNTYXREF
  PRIMARY KEY
  (COUNTY_ID, STATISTICALAREA_ID)
  USING INDEX SDSADM.PK_STD_STATCNTYXREF
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_STATCNTYXREF ADD (
  CONSTRAINT FKSTD_STATCNTYXREFCOUNTY 
  FOREIGN KEY (COUNTY_ID) 
  REFERENCES SDSADM.STD_COUNTY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FKSTD_STATCNTYXREFSTTSTCLAR 
  FOREIGN KEY (STATISTICALAREA_ID) 
  REFERENCES SDSADM.STD_STATISTICALAREA (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_STATCNTYXREF TO ADR;

GRANT SELECT ON SDSADM.STD_STATCNTYXREF TO ADREXT;

GRANT SELECT ON SDSADM.STD_STATCNTYXREF TO EESRV;

GRANT SELECT ON SDSADM.STD_STATCNTYXREF TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_STATCNTYXREF TO LOBR;

GRANT SELECT ON SDSADM.STD_STATCNTYXREF TO PSIM;

GRANT DELETE, INSERT, SELECT, UPDATE ON SDSADM.STD_STATCNTYXREF TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_STATCNTYXREF TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_STATCNTYXREF TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SSNVERIFSTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SSNVERIFSTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SSNVERIFSTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SSNVERIFSTATUSHISTORY ON SDSADM.STD_SSNVERIFSTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SSNVerifStatusHistory
after DELETE
ON SDSADM.STD_SSNVERIFSTATUSHISTORY
BEGIN
	-- update the table for STD_SSNVerifStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNVerifStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SSNVerifStatusHistory
after INSERT
ON SDSADM.STD_SSNVERIFSTATUSHISTORY
BEGIN
	-- update the table for STD_SSNVerifStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNVerifStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SSNVerifStatusHistory
after UPDATE
ON SDSADM.STD_SSNVERIFSTATUSHISTORY
BEGIN
	-- update the table for STD_SSNVerifStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNVerifStatusHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SSNVERIFSTATUSHISTORY FOR SDSADM.STD_SSNVERIFSTATUSHISTORY;


ALTER TABLE SDSADM.STD_SSNVERIFSTATUSHISTORY ADD (
  CONSTRAINT PK_STD_SSNVERIFSTATUSHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SSNVERIFSTATUSHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SSNVERIFSTATUSHISTORY ADD (
  CONSTRAINT FKSTD_SSNVERIFSTATUSHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SSNVERIFICATIONSTATUS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SSNVERIFSTATUSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SSNVERIFICATIONSTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SSNVERIFICATIONSTATUS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SSNVERIFICATIONSTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(70 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SSNVERIFSTATUS ON SDSADM.STD_SSNVERIFICATIONSTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SSNVERIFSTATUSCODE ON SDSADM.STD_SSNVERIFICATIONSTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SSNVERIFSTATUSNAME ON SDSADM.STD_SSNVERIFICATIONSTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SSNVerifStatus
after DELETE
ON SDSADM.STD_SSNVERIFICATIONSTATUS
BEGIN
	-- update the table for STD_SSNVerificationStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNVerificationStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SSNVerifStatus
after INSERT
ON SDSADM.STD_SSNVERIFICATIONSTATUS
BEGIN
	-- update the table for STD_SSNVerificationStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNVerificationStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SSNVerifStatus
after UPDATE
ON SDSADM.STD_SSNVERIFICATIONSTATUS
BEGIN
	-- update the table for STD_SSNVerificationStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNVerificationStatus';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SSNVERIFICATIONSTATUS FOR SDSADM.STD_SSNVERIFICATIONSTATUS;


ALTER TABLE SDSADM.STD_SSNVERIFICATIONSTATUS ADD (
  CONSTRAINT PK_STD_SSNVERIFSTATUS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SSNVERIFSTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SSNVERIFSTATUSCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SSNVERIFSTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SSNVERIFSTATUSNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SSNVERIFSTATUSNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SSNVERIFICATIONSTATUS TO ADR;

GRANT SELECT ON SDSADM.STD_SSNVERIFICATIONSTATUS TO ADREXT;

GRANT SELECT ON SDSADM.STD_SSNVERIFICATIONSTATUS TO EESRV;

GRANT SELECT ON SDSADM.STD_SSNVERIFICATIONSTATUS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SSNVERIFICATIONSTATUS TO LOBR;

GRANT SELECT ON SDSADM.STD_SSNVERIFICATIONSTATUS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNVERIFICATIONSTATUS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SSNVERIFICATIONSTATUS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SSNVERIFICATIONSTATUS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SSNTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SSNTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SSNTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SSNTYPEHISTORY ON SDSADM.STD_SSNTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SSNTypeHistory
after DELETE
ON SDSADM.STD_SSNTYPEHISTORY
BEGIN
	-- update the table for STD_SSNTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SSNTypeHistory
after INSERT
ON SDSADM.STD_SSNTYPEHISTORY
BEGIN
	-- update the table for STD_SSNTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SSNTypeHistory
after UPDATE
ON SDSADM.STD_SSNTYPEHISTORY
BEGIN
	-- update the table for STD_SSNTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SSNTYPEHISTORY FOR SDSADM.STD_SSNTYPEHISTORY;


ALTER TABLE SDSADM.STD_SSNTYPEHISTORY ADD (
  CONSTRAINT PK_STD_SSNTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SSNTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SSNTYPEHISTORY ADD (
  CONSTRAINT FKSTD_SSNTYPEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SSNTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SSNTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SSNTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SSNTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SSNTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SSNTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SSNTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SSNTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SSNTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SSNTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SSNTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SSNTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(30 BYTE)                NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SSNTYPE ON SDSADM.STD_SSNTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SSNTYPECODE ON SDSADM.STD_SSNTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SSNTYPENAME ON SDSADM.STD_SSNTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SSNType
after DELETE
ON SDSADM.STD_SSNTYPE
BEGIN
	-- update the table for STD_SSNType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SSNType
after INSERT
ON SDSADM.STD_SSNTYPE
BEGIN
	-- update the table for STD_SSNType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SSNType
after UPDATE
ON SDSADM.STD_SSNTYPE
BEGIN
	-- update the table for STD_SSNType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SSNTYPE FOR SDSADM.STD_SSNTYPE;


ALTER TABLE SDSADM.STD_SSNTYPE ADD (
  CONSTRAINT PK_STD_SSNTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SSNTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SSNTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SSNTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SSNTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SSNTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SSNTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_SSNTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SSNTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_SSNTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SSNTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_SSNTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SSNTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SSNTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SSNCHANGESOURCEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SSNCHANGESOURCEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SSNCHANGESOURCEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SSNCHANGESOURCEHISTORY ON SDSADM.STD_SSNCHANGESOURCEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SSNChangeSourceHstry
after DELETE
ON SDSADM.STD_SSNCHANGESOURCEHISTORY
BEGIN
	-- update the table for STD_SSNChangeSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNChangeSourceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SSNChangeSourceHstry
after INSERT
ON SDSADM.STD_SSNCHANGESOURCEHISTORY
BEGIN
	-- update the table for STD_SSNChangeSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNChangeSourceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SSNChangeSourceHstry
after UPDATE
ON SDSADM.STD_SSNCHANGESOURCEHISTORY
BEGIN
	-- update the table for STD_SSNChangeSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNChangeSourceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SSNCHANGESOURCEHISTORY FOR SDSADM.STD_SSNCHANGESOURCEHISTORY;


ALTER TABLE SDSADM.STD_SSNCHANGESOURCEHISTORY ADD (
  CONSTRAINT PK_STD_SSNCHANGESOURCEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SSNCHANGESOURCEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SSNCHANGESOURCEHISTORY ADD (
  CONSTRAINT FKSTD_SSNCHANGESOURCEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SSNCHANGESOURCE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SSNCHANGESOURCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SSNCHANGESOURCE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SSNCHANGESOURCE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SSNCHANGESOURCE ON SDSADM.STD_SSNCHANGESOURCE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SSNCHANGESOURCECODE ON SDSADM.STD_SSNCHANGESOURCE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SSNCHANGESOURCENAME ON SDSADM.STD_SSNCHANGESOURCE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SSNChangeSource
after DELETE
ON SDSADM.STD_SSNCHANGESOURCE
BEGIN
	-- update the table for STD_SSNChangeSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNChangeSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SSNChangeSource
after INSERT
ON SDSADM.STD_SSNCHANGESOURCE
BEGIN
	-- update the table for STD_SSNChangeSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNChangeSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SSNChangeSource
after UPDATE
ON SDSADM.STD_SSNCHANGESOURCE
BEGIN
	-- update the table for STD_SSNChangeSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSNChangeSource';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SSNCHANGESOURCE FOR SDSADM.STD_SSNCHANGESOURCE;


ALTER TABLE SDSADM.STD_SSNCHANGESOURCE ADD (
  CONSTRAINT PK_STD_SSNCHANGESOURCE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SSNCHANGESOURCE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SSNCHANGESOURCECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SSNCHANGESOURCECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SSNCHANGESOURCENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SSNCHANGESOURCENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SSNCHANGESOURCE TO ADR;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCE TO EESRV;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SSNCHANGESOURCE TO LOBR;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSNCHANGESOURCE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SSNCHANGESOURCE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SSAVERIFCODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SSAVERIFCODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SSAVERIFCODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SSAVERIFCODEHISTORY ON SDSADM.STD_SSAVERIFCODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SSAVerifCodeHistory
after DELETE
ON SDSADM.STD_SSAVERIFCODEHISTORY
BEGIN
	-- update the table for STD_SSAVerifCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAVerifCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SSAVerifCodeHistory
after INSERT
ON SDSADM.STD_SSAVERIFCODEHISTORY
BEGIN
	-- update the table for STD_SSAVerifCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAVerifCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SSAVerifCodeHistory
after UPDATE
ON SDSADM.STD_SSAVERIFCODEHISTORY
BEGIN
	-- update the table for STD_SSAVerifCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAVerifCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SSAVERIFCODEHISTORY FOR SDSADM.STD_SSAVERIFCODEHISTORY;


ALTER TABLE SDSADM.STD_SSAVERIFCODEHISTORY ADD (
  CONSTRAINT PK_STD_SSAVERIFCODEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SSAVERIFCODEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SSAVERIFCODEHISTORY ADD (
  CONSTRAINT FKSTD_SSAVERIFCODEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SSAVERIFCODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SSAVERIFCODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SSAVERIFCODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSAVERIFCODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SSAVERIFCODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SSAVERIFCODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SSAVERIFCODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(1 BYTE)                     NOT NULL,
  NAME         VARCHAR2(70 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SSAVERIFCODE ON SDSADM.STD_SSAVERIFCODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SSAVERIFCODECODE ON SDSADM.STD_SSAVERIFCODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SSAVERIFCODENAME ON SDSADM.STD_SSAVERIFCODE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SSAVerifCode
after DELETE
ON SDSADM.STD_SSAVERIFCODE
BEGIN
	-- update the table for STD_SSAVerifCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAVerifCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SSAVerifCode
after INSERT
ON SDSADM.STD_SSAVERIFCODE
BEGIN
	-- update the table for STD_SSAVerifCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAVerifCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SSAVerifCode
after UPDATE
ON SDSADM.STD_SSAVERIFCODE
BEGIN
	-- update the table for STD_SSAVerifCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAVerifCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SSAVERIFCODE FOR SDSADM.STD_SSAVERIFCODE;


ALTER TABLE SDSADM.STD_SSAVERIFCODE ADD (
  CONSTRAINT PK_STD_SSAVERIFCODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SSAVERIFCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SSAVERIFCODECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SSAVERIFCODECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SSAVERIFCODENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SSAVERIFCODENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SSAVERIFCODE TO ADR;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODE TO EESRV;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SSAVERIFCODE TO LOBR;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSAVERIFCODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SSAVERIFCODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SSAMESSAGETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SSAMESSAGETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SSAMESSAGETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SSAMESSAGETYPEHISTORY ON SDSADM.STD_SSAMESSAGETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SSAMessageTypeHistory
after DELETE
ON SDSADM.STD_SSAMESSAGETYPEHISTORY
BEGIN
	-- update the table for STD_SSAMessageTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAMessageTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SSAMessageTypeHistory
after INSERT
ON SDSADM.STD_SSAMESSAGETYPEHISTORY
BEGIN
	-- update the table for STD_SSAMessageTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAMessageTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SSAMessageTypeHistory
after UPDATE
ON SDSADM.STD_SSAMESSAGETYPEHISTORY
BEGIN
	-- update the table for STD_SSAMessageTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAMessageTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SSAMESSAGETYPEHISTORY FOR SDSADM.STD_SSAMESSAGETYPEHISTORY;


ALTER TABLE SDSADM.STD_SSAMESSAGETYPEHISTORY ADD (
  CONSTRAINT PK_STD_SSAMESSAGETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SSAMESSAGETYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SSAMESSAGETYPEHISTORY ADD (
  CONSTRAINT FKSTD_SSAMESSAGETYPEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SSAMESSAGETYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SSAMESSAGETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SSAMESSAGETYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SSAMESSAGETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SSAMESSAGETYPE ON SDSADM.STD_SSAMESSAGETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SSAMESSAGETYPECODE ON SDSADM.STD_SSAMESSAGETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SSAMESSAGETYPENAME ON SDSADM.STD_SSAMESSAGETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SSAMessageType
after DELETE
ON SDSADM.STD_SSAMESSAGETYPE
BEGIN
	-- update the table for STD_SSAMessageType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAMessageType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SSAMessageType
after INSERT
ON SDSADM.STD_SSAMESSAGETYPE
BEGIN
	-- update the table for STD_SSAMessageType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAMessageType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SSAMessageType
after UPDATE
ON SDSADM.STD_SSAMESSAGETYPE
BEGIN
	-- update the table for STD_SSAMessageType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SSAMessageType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SSAMESSAGETYPE FOR SDSADM.STD_SSAMESSAGETYPE;


ALTER TABLE SDSADM.STD_SSAMESSAGETYPE ADD (
  CONSTRAINT PK_STD_SSAMESSAGETYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SSAMESSAGETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SSAMESSAGETYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SSAMESSAGETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SSAMESSAGETYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SSAMESSAGETYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SSAMESSAGETYPE TO ADR;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SSAMESSAGETYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SSAMESSAGETYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SSAMESSAGETYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SPINALINJURYCODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SPINALINJURYCODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SPINALINJURYCODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SPINALINJURYCODEHISTORY ON SDSADM.STD_SPINALINJURYCODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SpinalInjuryCodeHstry
after DELETE
ON SDSADM.STD_SPINALINJURYCODEHISTORY
BEGIN
	-- update the table for STD_SpinalInjuryCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpinalInjuryCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SpinalInjuryCodeHstry
after INSERT
ON SDSADM.STD_SPINALINJURYCODEHISTORY
BEGIN
	-- update the table for STD_SpinalInjuryCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpinalInjuryCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SpinalInjuryCodeHstry
after UPDATE
ON SDSADM.STD_SPINALINJURYCODEHISTORY
BEGIN
	-- update the table for STD_SpinalInjuryCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpinalInjuryCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SPINALINJURYCODEHISTORY FOR SDSADM.STD_SPINALINJURYCODEHISTORY;


ALTER TABLE SDSADM.STD_SPINALINJURYCODEHISTORY ADD (
  CONSTRAINT PK_STD_SPINALINJURYCODEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SPINALINJURYCODEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SPINALINJURYCODEHISTORY ADD (
  CONSTRAINT FKSTD_SPINALINJURYCDHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SPINALINJURYCODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SPINALINJURYCODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SPINALINJURYCODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPINALINJURYCODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SPINALINJURYCODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SPINALINJURYCODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SPINALINJURYCODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(200 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SPINALINJURYCODE ON SDSADM.STD_SPINALINJURYCODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SPINALINJURYCODECODE ON SDSADM.STD_SPINALINJURYCODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SPINALINJURYCODENAME ON SDSADM.STD_SPINALINJURYCODE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SpinalInjuryCode
after DELETE
ON SDSADM.STD_SPINALINJURYCODE
BEGIN
	-- update the table for STD_SpinalInjuryCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpinalInjuryCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SpinalInjuryCode
after INSERT
ON SDSADM.STD_SPINALINJURYCODE
BEGIN
	-- update the table for STD_SpinalInjuryCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpinalInjuryCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SpinalInjuryCode
after UPDATE
ON SDSADM.STD_SPINALINJURYCODE
BEGIN
	-- update the table for STD_SpinalInjuryCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpinalInjuryCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SPINALINJURYCODE FOR SDSADM.STD_SPINALINJURYCODE;


ALTER TABLE SDSADM.STD_SPINALINJURYCODE ADD (
  CONSTRAINT PK_STD_SPINALINJURYCODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SPINALINJURYCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SPINALINJURYCODECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SPINALINJURYCODECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SPINALINJURYCODENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SPINALINJURYCODENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SPINALINJURYCODE TO ADR;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODE TO EESRV;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SPINALINJURYCODE TO LOBR;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPINALINJURYCODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SPINALINJURYCODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SPECIALTYSERVICEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SPECIALTYSERVICEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SPECIALTYSERVICEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SPECIALTYSERVICEHISTORY ON SDSADM.STD_SPECIALTYSERVICEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SpecialtyServiceHstry
after DELETE
ON SDSADM.STD_SPECIALTYSERVICEHISTORY
BEGIN
	-- update the table for STD_SpecialtyServiceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialtyServiceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SpecialtyServiceHstry
after INSERT
ON SDSADM.STD_SPECIALTYSERVICEHISTORY
BEGIN
	-- update the table for STD_SpecialtyServiceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialtyServiceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SpecialtyServiceHstry
after UPDATE
ON SDSADM.STD_SPECIALTYSERVICEHISTORY
BEGIN
	-- update the table for STD_SpecialtyServiceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialtyServiceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SPECIALTYSERVICEHISTORY FOR SDSADM.STD_SPECIALTYSERVICEHISTORY;


ALTER TABLE SDSADM.STD_SPECIALTYSERVICEHISTORY ADD (
  CONSTRAINT PK_STD_SPECIALTYSERVICEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SPECIALTYSERVICEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SPECIALTYSERVICEHISTORY ADD (
  CONSTRAINT FKSTD_SPECIALTYSRVCHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SPECIALTYSERVICE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SPECIALTYSERVICE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SPECIALTYSERVICE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SPECIALTYSERVICE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(20 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SPECIALTYSERVICE ON SDSADM.STD_SPECIALTYSERVICE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SPECIALTYSERVICECODE ON SDSADM.STD_SPECIALTYSERVICE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SPECIALTYSERVICENAME ON SDSADM.STD_SPECIALTYSERVICE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SpecialtyService
after DELETE
ON SDSADM.STD_SPECIALTYSERVICE
BEGIN
	-- update the table for STD_SpecialtyService operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialtyService';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SpecialtyService
after INSERT
ON SDSADM.STD_SPECIALTYSERVICE
BEGIN
	-- update the table for STD_SpecialtyService operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialtyService';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SpecialtyService
after UPDATE
ON SDSADM.STD_SPECIALTYSERVICE
BEGIN
	-- update the table for STD_SpecialtyService operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialtyService';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SPECIALTYSERVICE FOR SDSADM.STD_SPECIALTYSERVICE;


ALTER TABLE SDSADM.STD_SPECIALTYSERVICE ADD (
  CONSTRAINT PK_STD_SPECIALTYSERVICE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SPECIALTYSERVICE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SPECIALTYSERVICECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SPECIALTYSERVICECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SPECIALTYSERVICENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SPECIALTYSERVICENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SPECIALTYSERVICE TO ADR;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICE TO EESRV;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SPECIALTYSERVICE TO LOBR;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALTYSERVICE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SPECIALTYSERVICE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SPECIALOPERATIONHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SPECIALOPERATIONHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SPECIALOPERATIONHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SPECIALOPERATIONHISTORY ON SDSADM.STD_SPECIALOPERATIONHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SpecialOperationHstry
after DELETE
ON SDSADM.STD_SPECIALOPERATIONHISTORY
BEGIN
	-- update the table for STD_SpecialOperationHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialOperationHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SpecialOperationHstry
after INSERT
ON SDSADM.STD_SPECIALOPERATIONHISTORY
BEGIN
	-- update the table for STD_SpecialOperationHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialOperationHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SpecialOperationHstry
after UPDATE
ON SDSADM.STD_SPECIALOPERATIONHISTORY
BEGIN
	-- update the table for STD_SpecialOperationHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialOperationHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SPECIALOPERATIONHISTORY FOR SDSADM.STD_SPECIALOPERATIONHISTORY;


ALTER TABLE SDSADM.STD_SPECIALOPERATIONHISTORY ADD (
  CONSTRAINT PK_STD_SPECIALOPERATIONHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SPECIALOPERATIONHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SPECIALOPERATIONHISTORY ADD (
  CONSTRAINT FKSTD_SPECIALOPRTNHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SPECIALOPERATION (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SPECIALOPERATIONHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATIONHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATIONHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATIONHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SPECIALOPERATIONHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATIONHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALOPERATIONHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATIONHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATIONHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SPECIALOPERATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SPECIALOPERATION CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SPECIALOPERATION
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(8 BYTE)                 NOT NULL,
  NAME         VARCHAR2(35 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SPECIALOPERATION ON SDSADM.STD_SPECIALOPERATION
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SPECIALOPERATIONCODE ON SDSADM.STD_SPECIALOPERATION
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SPECIALOPERATIONNAME ON SDSADM.STD_SPECIALOPERATION
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SpecialOperation
after DELETE
ON SDSADM.STD_SPECIALOPERATION
BEGIN
	-- update the table for STD_SpecialOperation operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialOperation';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SpecialOperation
after INSERT
ON SDSADM.STD_SPECIALOPERATION
BEGIN
	-- update the table for STD_SpecialOperation operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialOperation';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SpecialOperation
after UPDATE
ON SDSADM.STD_SPECIALOPERATION
BEGIN
	-- update the table for STD_SpecialOperation operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialOperation';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SPECIALOPERATION FOR SDSADM.STD_SPECIALOPERATION;


ALTER TABLE SDSADM.STD_SPECIALOPERATION ADD (
  CONSTRAINT PK_STD_SPECIALOPERATION
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SPECIALOPERATION
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SPECIALOPERATIONCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SPECIALOPERATIONCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SPECIALOPERATIONNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SPECIALOPERATIONNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SPECIALOPERATION TO ADR;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATION TO ADREXT;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATION TO EESRV;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATION TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SPECIALOPERATION TO LOBR;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATION TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALOPERATION TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATION TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SPECIALOPERATION TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SPECIALFACTORMAPHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SPECIALFACTORMAPHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SPECIALFACTORMAPHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SPECIALFACTORMAPHISTORY ON SDSADM.STD_SPECIALFACTORMAPHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SpecialFactorMapHstry
after DELETE
ON SDSADM.STD_SPECIALFACTORMAPHISTORY
BEGIN
	-- update the table for STD_SpecialFactorMapHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialFactorMapHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SpecialFactorMapHstry
after INSERT
ON SDSADM.STD_SPECIALFACTORMAPHISTORY
BEGIN
	-- update the table for STD_SpecialFactorMapHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialFactorMapHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SpecialFactorMapHstry
after UPDATE
ON SDSADM.STD_SPECIALFACTORMAPHISTORY
BEGIN
	-- update the table for STD_SpecialFactorMapHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialFactorMapHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SPECIALFACTORMAPHISTORY FOR SDSADM.STD_SPECIALFACTORMAPHISTORY;


ALTER TABLE SDSADM.STD_SPECIALFACTORMAPHISTORY ADD (
  CONSTRAINT PK_STD_SPECIALFACTORMAPHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SPECIALFACTORMAPHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SPECIALFACTORMAPHISTORY ADD (
  CONSTRAINT FKSTD_SPECIALFACTORMPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SPECIALFACTORMAP (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAPHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SPECIALFACTORMAP
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SPECIALFACTORMAP CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SPECIALFACTORMAP
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(5 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SPECIALFACTORMAP ON SDSADM.STD_SPECIALFACTORMAP
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SPECIALFACTORMAPCODE ON SDSADM.STD_SPECIALFACTORMAP
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SPECIALFACTORMAPNAME ON SDSADM.STD_SPECIALFACTORMAP
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SpecialFactorMap
after DELETE
ON SDSADM.STD_SPECIALFACTORMAP
BEGIN
	-- update the table for STD_SpecialFactorMap operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialFactorMap';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SpecialFactorMap
after INSERT
ON SDSADM.STD_SPECIALFACTORMAP
BEGIN
	-- update the table for STD_SpecialFactorMap operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialFactorMap';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SpecialFactorMap
after UPDATE
ON SDSADM.STD_SPECIALFACTORMAP
BEGIN
	-- update the table for STD_SpecialFactorMap operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SpecialFactorMap';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SPECIALFACTORMAP FOR SDSADM.STD_SPECIALFACTORMAP;


ALTER TABLE SDSADM.STD_SPECIALFACTORMAP ADD (
  CONSTRAINT PK_STD_SPECIALFACTORMAP
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SPECIALFACTORMAP
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SPECIALFACTORMAPCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SPECIALFACTORMAPCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SPECIALFACTORMAPNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SPECIALFACTORMAPNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SPECIALFACTORMAP TO ADR;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAP TO ADREXT;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAP TO EESRV;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAP TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SPECIALFACTORMAP TO LOBR;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAP TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SPECIALFACTORMAP TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAP TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SPECIALFACTORMAP TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SITEUPLOADSTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SITEUPLOADSTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SITEUPLOADSTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SITEUPLOADSTATUSHISTORY ON SDSADM.STD_SITEUPLOADSTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SiteUploadStatusHstry
after DELETE
ON SDSADM.STD_SITEUPLOADSTATUSHISTORY
BEGIN
	-- update the table for STD_SiteUploadStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SiteUploadStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SiteUploadStatusHstry
after INSERT
ON SDSADM.STD_SITEUPLOADSTATUSHISTORY
BEGIN
	-- update the table for STD_SiteUploadStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SiteUploadStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SiteUploadStatusHstry
after UPDATE
ON SDSADM.STD_SITEUPLOADSTATUSHISTORY
BEGIN
	-- update the table for STD_SiteUploadStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SiteUploadStatusHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SITEUPLOADSTATUSHISTORY FOR SDSADM.STD_SITEUPLOADSTATUSHISTORY;


ALTER TABLE SDSADM.STD_SITEUPLOADSTATUSHISTORY ADD (
  CONSTRAINT PK_STD_SITEUPLOADSTATUSHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SITEUPLOADSTATUSHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SITEUPLOADSTATUSHISTORY ADD (
  CONSTRAINT FKSTD_SITEUPLOADSTTSHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SITEUPLOADSTATUS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SITEUPLOADSTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SITEUPLOADSTATUS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SITEUPLOADSTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SITEUPLOADSTATUS ON SDSADM.STD_SITEUPLOADSTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SITEUPLOADSTATUSCODE ON SDSADM.STD_SITEUPLOADSTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SITEUPLOADSTATUSNAME ON SDSADM.STD_SITEUPLOADSTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SiteUploadStatus
after DELETE
ON SDSADM.STD_SITEUPLOADSTATUS
BEGIN
	-- update the table for STD_SiteUploadStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SiteUploadStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SiteUploadStatus
after INSERT
ON SDSADM.STD_SITEUPLOADSTATUS
BEGIN
	-- update the table for STD_SiteUploadStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SiteUploadStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SiteUploadStatus
after UPDATE
ON SDSADM.STD_SITEUPLOADSTATUS
BEGIN
	-- update the table for STD_SiteUploadStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SiteUploadStatus';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SITEUPLOADSTATUS FOR SDSADM.STD_SITEUPLOADSTATUS;


ALTER TABLE SDSADM.STD_SITEUPLOADSTATUS ADD (
  CONSTRAINT PK_STD_SITEUPLOADSTATUS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SITEUPLOADSTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SITEUPLOADSTATUSCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SITEUPLOADSTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SITEUPLOADSTATUSNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SITEUPLOADSTATUSNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SITEUPLOADSTATUS TO ADR;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUS TO ADREXT;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUS TO EESRV;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SITEUPLOADSTATUS TO LOBR;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SITEUPLOADSTATUS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SITEUPLOADSTATUS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SIGNATUREINDTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SIGNATUREINDTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SIGNATUREINDTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SIGNATUREINDTYPEHISTORY ON SDSADM.STD_SIGNATUREINDTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SignatureIndTypeHstry
after DELETE
ON SDSADM.STD_SIGNATUREINDTYPEHISTORY
BEGIN
	-- update the table for STD_SignatureIndTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SignatureIndTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SignatureIndTypeHstry
after INSERT
ON SDSADM.STD_SIGNATUREINDTYPEHISTORY
BEGIN
	-- update the table for STD_SignatureIndTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SignatureIndTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SignatureIndTypeHstry
after UPDATE
ON SDSADM.STD_SIGNATUREINDTYPEHISTORY
BEGIN
	-- update the table for STD_SignatureIndTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SignatureIndTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SIGNATUREINDTYPEHISTORY FOR SDSADM.STD_SIGNATUREINDTYPEHISTORY;


ALTER TABLE SDSADM.STD_SIGNATUREINDTYPEHISTORY ADD (
  CONSTRAINT PK_STD_SIGNATUREINDTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SIGNATUREINDTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SIGNATUREINDTYPEHISTORY ADD (
  CONSTRAINT FKSTD_SIGNATUREINDTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SIGNATUREINDTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SIGNATUREINDTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SIGNATUREINDTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SIGNATUREINDTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(40 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SIGNATUREINDTYPE ON SDSADM.STD_SIGNATUREINDTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SIGNATUREINDTYPECODE ON SDSADM.STD_SIGNATUREINDTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SIGNATUREINDTYPENAME ON SDSADM.STD_SIGNATUREINDTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SignatureIndType
after DELETE
ON SDSADM.STD_SIGNATUREINDTYPE
BEGIN
	-- update the table for STD_SignatureIndType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SignatureIndType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SignatureIndType
after INSERT
ON SDSADM.STD_SIGNATUREINDTYPE
BEGIN
	-- update the table for STD_SignatureIndType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SignatureIndType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SignatureIndType
after UPDATE
ON SDSADM.STD_SIGNATUREINDTYPE
BEGIN
	-- update the table for STD_SignatureIndType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SignatureIndType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SIGNATUREINDTYPE FOR SDSADM.STD_SIGNATUREINDTYPE;


ALTER TABLE SDSADM.STD_SIGNATUREINDTYPE ADD (
  CONSTRAINT PK_STD_SIGNATUREINDTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SIGNATUREINDTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SIGNATUREINDTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SIGNATUREINDTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SIGNATUREINDTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SIGNATUREINDTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SIGNATUREINDTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SIGNATUREINDTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SIGNATUREINDTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SIGNATUREINDTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SHADDOCUMENTTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SHADDOCUMENTTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SHADDOCUMENTTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SHADDOCUMENTTYPEHISTORY ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SHADDocumentTypeHstry
after DELETE
ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY
BEGIN
	-- update the table for STD_SHADDocumentTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SHADDocumentTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SHADDocumentTypeHstry
after INSERT
ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY
BEGIN
	-- update the table for STD_SHADDocumentTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SHADDocumentTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SHADDocumentTypeHstry
after UPDATE
ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY
BEGIN
	-- update the table for STD_SHADDocumentTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SHADDocumentTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SHADDOCUMENTTYPEHISTORY FOR SDSADM.STD_SHADDOCUMENTTYPEHISTORY;


ALTER TABLE SDSADM.STD_SHADDOCUMENTTYPEHISTORY ADD (
  CONSTRAINT PK_STD_SHADDOCUMENTTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SHADDOCUMENTTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SHADDOCUMENTTYPEHISTORY ADD (
  CONSTRAINT FKSTD_SHADDOCUMENTTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SHADDOCUMENTTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SHADDOCUMENTTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SHADDOCUMENTTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SHADDOCUMENTTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(1 BYTE)                 NOT NULL,
  NAME         VARCHAR2(60 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SHADDOCUMENTTYPE ON SDSADM.STD_SHADDOCUMENTTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SHADDOCUMENTTYPECODE ON SDSADM.STD_SHADDOCUMENTTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SHADDOCUMENTTYPENAME ON SDSADM.STD_SHADDOCUMENTTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SHADDocumentType
after DELETE
ON SDSADM.STD_SHADDOCUMENTTYPE
BEGIN
	-- update the table for STD_SHADDocumentType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SHADDocumentType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SHADDocumentType
after INSERT
ON SDSADM.STD_SHADDOCUMENTTYPE
BEGIN
	-- update the table for STD_SHADDocumentType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SHADDocumentType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SHADDocumentType
after UPDATE
ON SDSADM.STD_SHADDOCUMENTTYPE
BEGIN
	-- update the table for STD_SHADDocumentType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SHADDocumentType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SHADDOCUMENTTYPE FOR SDSADM.STD_SHADDOCUMENTTYPE;


ALTER TABLE SDSADM.STD_SHADDOCUMENTTYPE ADD (
  CONSTRAINT PK_STD_SHADDOCUMENTTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SHADDOCUMENTTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SHADDOCUMENTTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SHADDOCUMENTTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SHADDOCUMENTTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SHADDOCUMENTTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SHADDOCUMENTTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SHADDOCUMENTTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SHADDOCUMENTTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SHADDOCUMENTTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SERVICEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SERVICEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SERVICEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SERVICEHISTORY ON SDSADM.STD_SERVICEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ServiceHistory
after DELETE
ON SDSADM.STD_SERVICEHISTORY
BEGIN
	-- update the table for STD_ServiceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ServiceHistory
after INSERT
ON SDSADM.STD_SERVICEHISTORY
BEGIN
	-- update the table for STD_ServiceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ServiceHistory
after UPDATE
ON SDSADM.STD_SERVICEHISTORY
BEGIN
	-- update the table for STD_ServiceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SERVICEHISTORY FOR SDSADM.STD_SERVICEHISTORY;


ALTER TABLE SDSADM.STD_SERVICEHISTORY ADD (
  CONSTRAINT PK_STD_SERVICEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SERVICEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SERVICEHISTORY ADD (
  CONSTRAINT FKSTD_SERVICEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SERVICE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SERVICEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SERVICEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SERVICEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SERVICEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SERVICEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SERVICEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SERVICEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SERVICEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SERVICEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SERVICEDISCHARGECODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SERVICEDISCHARGECODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SERVICEDISCHARGECODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SVCDSCHRGCD ON SDSADM.STD_SERVICEDISCHARGECODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SVCDSCHRGCDCODE ON SDSADM.STD_SERVICEDISCHARGECODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SVCDSCHRGCDNAME ON SDSADM.STD_SERVICEDISCHARGECODE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SvcDschrgCd
after DELETE
ON SDSADM.STD_SERVICEDISCHARGECODE
BEGIN
	-- update the table for STD_ServiceDischargeCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceDischargeCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SvcDschrgCd
after INSERT
ON SDSADM.STD_SERVICEDISCHARGECODE
BEGIN
	-- update the table for STD_ServiceDischargeCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceDischargeCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SvcDschrgCd
after UPDATE
ON SDSADM.STD_SERVICEDISCHARGECODE
BEGIN
	-- update the table for STD_ServiceDischargeCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceDischargeCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SERVICEDISCHARGECODE FOR SDSADM.STD_SERVICEDISCHARGECODE;


ALTER TABLE SDSADM.STD_SERVICEDISCHARGECODE ADD (
  CONSTRAINT PK_STD_SVCDSCHRGCD
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SVCDSCHRGCD
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SVCDSCHRGCDCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SVCDSCHRGCDCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SVCDSCHRGCDNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SVCDSCHRGCDNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SERVICEDISCHARGECODE TO ADR;

GRANT SELECT ON SDSADM.STD_SERVICEDISCHARGECODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SERVICEDISCHARGECODE TO EESRV;

GRANT SELECT ON SDSADM.STD_SERVICEDISCHARGECODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SERVICEDISCHARGECODE TO LOBR;

GRANT SELECT ON SDSADM.STD_SERVICEDISCHARGECODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SERVICEDISCHARGECODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SERVICEDISCHARGECODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SERVICEDISCHARGECODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SERVICEBRANCHHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SERVICEBRANCHHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SERVICEBRANCHHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SERVICEBRANCHHISTORY ON SDSADM.STD_SERVICEBRANCHHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ServiceBranchHistory
after DELETE
ON SDSADM.STD_SERVICEBRANCHHISTORY
BEGIN
	-- update the table for STD_ServiceBranchHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceBranchHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ServiceBranchHistory
after INSERT
ON SDSADM.STD_SERVICEBRANCHHISTORY
BEGIN
	-- update the table for STD_ServiceBranchHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceBranchHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ServiceBranchHistory
after UPDATE
ON SDSADM.STD_SERVICEBRANCHHISTORY
BEGIN
	-- update the table for STD_ServiceBranchHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceBranchHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SERVICEBRANCHHISTORY FOR SDSADM.STD_SERVICEBRANCHHISTORY;


ALTER TABLE SDSADM.STD_SERVICEBRANCHHISTORY ADD (
  CONSTRAINT PK_STD_SERVICEBRANCHHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SERVICEBRANCHHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SERVICEBRANCHHISTORY ADD (
  CONSTRAINT FKSTD_SERVICEBRANCHHISTORYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SERVICEBRANCH (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SERVICEBRANCHHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCHHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCHHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCHHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SERVICEBRANCHHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCHHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SERVICEBRANCHHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCHHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCHHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SERVICEBRANCH
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SERVICEBRANCH CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SERVICEBRANCH
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SERVICEBRANCH ON SDSADM.STD_SERVICEBRANCH
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SERVICEBRANCHCODE ON SDSADM.STD_SERVICEBRANCH
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SERVICEBRANCHNAME ON SDSADM.STD_SERVICEBRANCH
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ServiceBranch
after DELETE
ON SDSADM.STD_SERVICEBRANCH
BEGIN
	-- update the table for STD_ServiceBranch operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceBranch';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ServiceBranch
after INSERT
ON SDSADM.STD_SERVICEBRANCH
BEGIN
	-- update the table for STD_ServiceBranch operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceBranch';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ServiceBranch
after UPDATE
ON SDSADM.STD_SERVICEBRANCH
BEGIN
	-- update the table for STD_ServiceBranch operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ServiceBranch';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SERVICEBRANCH FOR SDSADM.STD_SERVICEBRANCH;


ALTER TABLE SDSADM.STD_SERVICEBRANCH ADD (
  CONSTRAINT PK_STD_SERVICEBRANCH
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SERVICEBRANCH
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SERVICEBRANCHCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SERVICEBRANCHCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SERVICEBRANCHNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SERVICEBRANCHNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SERVICEBRANCH TO ADR;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCH TO ADREXT;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCH TO EESRV;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCH TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SERVICEBRANCH TO LOBR;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCH TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SERVICEBRANCH TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCH TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SERVICEBRANCH TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SERVICE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SERVICE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SERVICE
(
  ID                NUMBER(20)                  NOT NULL,
  NAME              VARCHAR2(50 BYTE)           NOT NULL,
  ROUTINGSYMBOL     VARCHAR2(7 BYTE),
  DSSSERVICECODE    CHAR(1 BYTE),
  VACOSTCENTER      CHAR(3 BYTE),
  GENERALPRIVILEGE  VARCHAR2(1000 BYTE),
  VERSION           INTEGER                     NOT NULL,
  CREATED           TIMESTAMP(6)                NOT NULL,
  UPDATED           TIMESTAMP(6),
  CREATEDBY         VARCHAR2(32 BYTE)           NOT NULL,
  UPDATEDBY         VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SERVICE ON SDSADM.STD_SERVICE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SERVICENAME ON SDSADM.STD_SERVICE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_Service
after DELETE
ON SDSADM.STD_SERVICE
BEGIN
	-- update the table for STD_Service operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Service';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_Service
after INSERT
ON SDSADM.STD_SERVICE
BEGIN
	-- update the table for STD_Service operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Service';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_Service
after UPDATE
ON SDSADM.STD_SERVICE
BEGIN
	-- update the table for STD_Service operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Service';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SERVICE FOR SDSADM.STD_SERVICE;


ALTER TABLE SDSADM.STD_SERVICE ADD (
  CONSTRAINT PK_STD_SERVICE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SERVICE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SERVICENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SERVICENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SERVICE TO ADR;

GRANT SELECT ON SDSADM.STD_SERVICE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SERVICE TO EESRV;

GRANT SELECT ON SDSADM.STD_SERVICE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SERVICE TO LOBR;

GRANT SELECT ON SDSADM.STD_SERVICE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SERVICE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SERVICE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SERVICE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SENSITIVITYCHNGSRCHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SENSITIVITYCHNGSRCHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SENSITIVITYCHNGSRCHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SENSITIVITYCHNGSRCHSTRY ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SnstvtyChngSrcHstry
after DELETE
ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY
BEGIN
	-- update the table for STD_SensitivityChngSrcHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SensitivityChngSrcHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SnstvtyChngSrcHstry
after INSERT
ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY
BEGIN
	-- update the table for STD_SensitivityChngSrcHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SensitivityChngSrcHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SnstvtyChngSrcHstry
after UPDATE
ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY
BEGIN
	-- update the table for STD_SensitivityChngSrcHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SensitivityChngSrcHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SENSITIVITYCHNGSRCHISTORY FOR SDSADM.STD_SENSITIVITYCHNGSRCHISTORY;


ALTER TABLE SDSADM.STD_SENSITIVITYCHNGSRCHISTORY ADD (
  CONSTRAINT PK_STD_SENSITIVITYCHNGSRCHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SENSITIVITYCHNGSRCHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SENSITIVITYCHNGSRCHISTORY ADD (
  CONSTRAINT FKSTD_SNSTVTYCHNGSRCHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SENSITIVITYCHANGESOURCE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHNGSRCHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SENSITIVITYCHANGESOURCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SENSITIVITYCHANGESOURCE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SENSITIVITYCHANGESOURCE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SENSITIVITYCHNGSRC ON SDSADM.STD_SENSITIVITYCHANGESOURCE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SENSITIVITYCHNGSRCCODE ON SDSADM.STD_SENSITIVITYCHANGESOURCE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SENSITIVITYCHNGSRCNAME ON SDSADM.STD_SENSITIVITYCHANGESOURCE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SensitivityChngSrc
after DELETE
ON SDSADM.STD_SENSITIVITYCHANGESOURCE
BEGIN
	-- update the table for STD_SensitivityChangeSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SensitivityChangeSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SensitivityChngSrc
after INSERT
ON SDSADM.STD_SENSITIVITYCHANGESOURCE
BEGIN
	-- update the table for STD_SensitivityChangeSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SensitivityChangeSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SensitivityChngSrc
after UPDATE
ON SDSADM.STD_SENSITIVITYCHANGESOURCE
BEGIN
	-- update the table for STD_SensitivityChangeSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SensitivityChangeSource';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SENSITIVITYCHANGESOURCE FOR SDSADM.STD_SENSITIVITYCHANGESOURCE;


ALTER TABLE SDSADM.STD_SENSITIVITYCHANGESOURCE ADD (
  CONSTRAINT PK_STD_SENSITIVITYCHNGSRC
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SENSITIVITYCHNGSRC
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SENSITIVITYCHNGSRCCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SENSITIVITYCHNGSRCCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SENSITIVITYCHNGSRCNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SENSITIVITYCHNGSRCNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO ADR;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO EESRV;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO LOBR;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SENSITIVITYCHANGESOURCE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SEEDSTATUSCODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SEEDSTATUSCODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SEEDSTATUSCODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SEEDSTATUSCODEHISTORY ON SDSADM.STD_SEEDSTATUSCODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SeedStatusCodeHistory
after DELETE
ON SDSADM.STD_SEEDSTATUSCODEHISTORY
BEGIN
	-- update the table for STD_SeedStatusCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SeedStatusCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SeedStatusCodeHistory
after INSERT
ON SDSADM.STD_SEEDSTATUSCODEHISTORY
BEGIN
	-- update the table for STD_SeedStatusCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SeedStatusCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SeedStatusCodeHistory
after UPDATE
ON SDSADM.STD_SEEDSTATUSCODEHISTORY
BEGIN
	-- update the table for STD_SeedStatusCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SeedStatusCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SEEDSTATUSCODEHISTORY FOR SDSADM.STD_SEEDSTATUSCODEHISTORY;


ALTER TABLE SDSADM.STD_SEEDSTATUSCODEHISTORY ADD (
  CONSTRAINT PK_STD_SEEDSTATUSCODEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SEEDSTATUSCODEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_SEEDSTATUSCODEHISTORY ADD (
  CONSTRAINT FKSTD_SEEDSTATUSCODEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_SEEDSTATUSCODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_SEEDSTATUSCODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_SEEDSTATUSCODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_SEEDSTATUSCODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(8 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(30 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_SEEDSTATUSCODE ON SDSADM.STD_SEEDSTATUSCODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SEEDSTATUSCODECODE ON SDSADM.STD_SEEDSTATUSCODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_SEEDSTATUSCODENAME ON SDSADM.STD_SEEDSTATUSCODE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_SeedStatusCode
after DELETE
ON SDSADM.STD_SEEDSTATUSCODE
BEGIN
	-- update the table for STD_SeedStatusCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SeedStatusCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_SeedStatusCode
after INSERT
ON SDSADM.STD_SEEDSTATUSCODE
BEGIN
	-- update the table for STD_SeedStatusCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SeedStatusCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_SeedStatusCode
after UPDATE
ON SDSADM.STD_SEEDSTATUSCODE
BEGIN
	-- update the table for STD_SeedStatusCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_SeedStatusCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_SEEDSTATUSCODE FOR SDSADM.STD_SEEDSTATUSCODE;


ALTER TABLE SDSADM.STD_SEEDSTATUSCODE ADD (
  CONSTRAINT PK_STD_SEEDSTATUSCODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_SEEDSTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SEEDSTATUSCODECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_SEEDSTATUSCODECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_SEEDSTATUSCODENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_SEEDSTATUSCODENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_SEEDSTATUSCODE TO ADR;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODE TO EESRV;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_SEEDSTATUSCODE TO LOBR;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_SEEDSTATUSCODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_SEEDSTATUSCODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RELTOVETINSURANCEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RELTOVETINSURANCEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RELTOVETINSURANCEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RELTOVETINSURANCEHSTRY ON SDSADM.STD_RELTOVETINSURANCEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RelToVetInsrncHstry
after DELETE
ON SDSADM.STD_RELTOVETINSURANCEHISTORY
BEGIN
	-- update the table for STD_RelToVetInsuranceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelToVetInsuranceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RelToVetInsrncHstry
after INSERT
ON SDSADM.STD_RELTOVETINSURANCEHISTORY
BEGIN
	-- update the table for STD_RelToVetInsuranceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelToVetInsuranceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RelToVetInsrncHstry
after UPDATE
ON SDSADM.STD_RELTOVETINSURANCEHISTORY
BEGIN
	-- update the table for STD_RelToVetInsuranceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelToVetInsuranceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RELTOVETINSURANCEHISTORY FOR SDSADM.STD_RELTOVETINSURANCEHISTORY;


ALTER TABLE SDSADM.STD_RELTOVETINSURANCEHISTORY ADD (
  CONSTRAINT PK_STD_RELTOVETINSURANCEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RELTOVETINSURANCEHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_RELTOVETINSURANCEHISTORY ADD (
  CONSTRAINT FKSTD_RELTOVETINSRNCHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_RELTOVETINSURANCE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RELTOVETINSURANCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RELTOVETINSURANCE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RELTOVETINSURANCE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(2 BYTE)                     NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RELTOVETINSURANCE ON SDSADM.STD_RELTOVETINSURANCE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RELTOVETINSURANCECODE ON SDSADM.STD_RELTOVETINSURANCE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RelToVetInsurance
after DELETE
ON SDSADM.STD_RELTOVETINSURANCE
BEGIN
	-- update the table for STD_RelToVetInsurance operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelToVetInsurance';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RelToVetInsurance
after INSERT
ON SDSADM.STD_RELTOVETINSURANCE
BEGIN
	-- update the table for STD_RelToVetInsurance operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelToVetInsurance';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RelToVetInsurance
after UPDATE
ON SDSADM.STD_RELTOVETINSURANCE
BEGIN
	-- update the table for STD_RelToVetInsurance operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelToVetInsurance';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RELTOVETINSURANCE FOR SDSADM.STD_RELTOVETINSURANCE;


ALTER TABLE SDSADM.STD_RELTOVETINSURANCE ADD (
  CONSTRAINT PK_STD_RELTOVETINSURANCE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RELTOVETINSURANCE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RELTOVETINSURANCECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_RELTOVETINSURANCECODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RELTOVETINSURANCE TO ADR;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCE TO ADREXT;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCE TO EESRV;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RELTOVETINSURANCE TO LOBR;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELTOVETINSURANCE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RELTOVETINSURANCE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RELIGIONHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RELIGIONHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RELIGIONHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RELIGIONHISTORY ON SDSADM.STD_RELIGIONHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ReligionHistory
after DELETE
ON SDSADM.STD_RELIGIONHISTORY
BEGIN
	-- update the table for STD_ReligionHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ReligionHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ReligionHistory
after INSERT
ON SDSADM.STD_RELIGIONHISTORY
BEGIN
	-- update the table for STD_ReligionHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ReligionHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ReligionHistory
after UPDATE
ON SDSADM.STD_RELIGIONHISTORY
BEGIN
	-- update the table for STD_ReligionHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ReligionHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RELIGIONHISTORY FOR SDSADM.STD_RELIGIONHISTORY;


ALTER TABLE SDSADM.STD_RELIGIONHISTORY ADD (
  CONSTRAINT PK_STD_RELIGIONHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RELIGIONHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_RELIGIONHISTORY ADD (
  CONSTRAINT FKSTD_RELIGIONHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_RELIGION (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RELIGIONHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_RELIGIONHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_RELIGIONHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_RELIGIONHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RELIGIONHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_RELIGIONHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELIGIONHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RELIGIONHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RELIGIONHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RELIGION
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RELIGION CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RELIGION
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(4 BYTE)                 NOT NULL,
  NAME         VARCHAR2(49 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RELIGION ON SDSADM.STD_RELIGION
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RELIGIONCODE ON SDSADM.STD_RELIGION
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RELIGIONNAME ON SDSADM.STD_RELIGION
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_Religion
after DELETE
ON SDSADM.STD_RELIGION
BEGIN
	-- update the table for STD_Religion operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Religion';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_Religion
after INSERT
ON SDSADM.STD_RELIGION
BEGIN
	-- update the table for STD_Religion operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Religion';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_Religion
after UPDATE
ON SDSADM.STD_RELIGION
BEGIN
	-- update the table for STD_Religion operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Religion';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RELIGION FOR SDSADM.STD_RELIGION;


ALTER TABLE SDSADM.STD_RELIGION ADD (
  CONSTRAINT PK_STD_RELIGION
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RELIGION
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RELIGIONCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_RELIGIONCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RELIGIONNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_RELIGIONNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RELIGION TO ADR;

GRANT SELECT ON SDSADM.STD_RELIGION TO ADREXT;

GRANT SELECT ON SDSADM.STD_RELIGION TO EESRV;

GRANT SELECT ON SDSADM.STD_RELIGION TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RELIGION TO LOBR;

GRANT SELECT ON SDSADM.STD_RELIGION TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELIGION TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RELIGION TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RELIGION TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RELATNLOPERATORHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RELATNLOPERATORHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RELATNLOPERATORHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RELATNLOPERATORHISTORY ON SDSADM.STD_RELATNLOPERATORHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RelatnlOperatorHstry
after DELETE
ON SDSADM.STD_RELATNLOPERATORHISTORY
BEGIN
	-- update the table for STD_RelatnlOperatorHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelatnlOperatorHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RelatnlOperatorHstry
after INSERT
ON SDSADM.STD_RELATNLOPERATORHISTORY
BEGIN
	-- update the table for STD_RelatnlOperatorHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelatnlOperatorHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RelatnlOperatorHstry
after UPDATE
ON SDSADM.STD_RELATNLOPERATORHISTORY
BEGIN
	-- update the table for STD_RelatnlOperatorHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelatnlOperatorHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RELATNLOPERATORHISTORY FOR SDSADM.STD_RELATNLOPERATORHISTORY;


ALTER TABLE SDSADM.STD_RELATNLOPERATORHISTORY ADD (
  CONSTRAINT PK_STD_RELATNLOPERATORHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RELATNLOPERATORHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_RELATNLOPERATORHISTORY ADD (
  CONSTRAINT FKSTD_RELATNLOPERATORHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_RELATIONALOPERATOR (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RELATNLOPERATORHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_RELATNLOPERATORHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_RELATNLOPERATORHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_RELATNLOPERATORHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RELATNLOPERATORHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_RELATNLOPERATORHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATNLOPERATORHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RELATNLOPERATORHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RELATNLOPERATORHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RELATNLCONJUNCTNHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RELATNLCONJUNCTNHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RELATNLCONJUNCTNHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RELATNLCONJUNCTNHISTORY ON SDSADM.STD_RELATNLCONJUNCTNHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RelatnlConjunctnHstry
after DELETE
ON SDSADM.STD_RELATNLCONJUNCTNHISTORY
BEGIN
	-- update the table for STD_RelatnlConjunctnHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelatnlConjunctnHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RelatnlConjunctnHstry
after INSERT
ON SDSADM.STD_RELATNLCONJUNCTNHISTORY
BEGIN
	-- update the table for STD_RelatnlConjunctnHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelatnlConjunctnHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RelatnlConjunctnHstry
after UPDATE
ON SDSADM.STD_RELATNLCONJUNCTNHISTORY
BEGIN
	-- update the table for STD_RelatnlConjunctnHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelatnlConjunctnHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RELATNLCONJUNCTNHISTORY FOR SDSADM.STD_RELATNLCONJUNCTNHISTORY;


ALTER TABLE SDSADM.STD_RELATNLCONJUNCTNHISTORY ADD (
  CONSTRAINT PK_STD_RELATNLCONJUNCTNHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RELATNLCONJUNCTNHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_RELATNLCONJUNCTNHISTORY ADD (
  CONSTRAINT FKSTD_RELATNLCNJNCTNHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_RELATIONALCONJUNCTION (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RELATNLCONJUNCTNHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RELATIONSHIPHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RELATIONSHIPHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RELATIONSHIPHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RELATIONSHIPHISTORY ON SDSADM.STD_RELATIONSHIPHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RelationshipHistory
after DELETE
ON SDSADM.STD_RELATIONSHIPHISTORY
BEGIN
	-- update the table for STD_RelationshipHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelationshipHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RelationshipHistory
after INSERT
ON SDSADM.STD_RELATIONSHIPHISTORY
BEGIN
	-- update the table for STD_RelationshipHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelationshipHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RelationshipHistory
after UPDATE
ON SDSADM.STD_RELATIONSHIPHISTORY
BEGIN
	-- update the table for STD_RelationshipHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelationshipHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RELATIONSHIPHISTORY FOR SDSADM.STD_RELATIONSHIPHISTORY;


ALTER TABLE SDSADM.STD_RELATIONSHIPHISTORY ADD (
  CONSTRAINT PK_STD_RELATIONSHIPHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RELATIONSHIPHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_RELATIONSHIPHISTORY ADD (
  CONSTRAINT FKSTD_RELATIONSHIPHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_RELATIONSHIP (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RELATIONSHIPHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_RELATIONSHIPHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_RELATIONSHIPHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_RELATIONSHIPHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RELATIONSHIPHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_RELATIONSHIPHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATIONSHIPHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RELATIONSHIPHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RELATIONSHIPHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RELATIONSHIP
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RELATIONSHIP CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RELATIONSHIP
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RELATIONSHIP ON SDSADM.STD_RELATIONSHIP
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RELATIONSHIPCODE ON SDSADM.STD_RELATIONSHIP
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RELATIONSHIPNAME ON SDSADM.STD_RELATIONSHIP
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_Relationship
after DELETE
ON SDSADM.STD_RELATIONSHIP
BEGIN
	-- update the table for STD_Relationship operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Relationship';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_Relationship
after INSERT
ON SDSADM.STD_RELATIONSHIP
BEGIN
	-- update the table for STD_Relationship operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Relationship';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_Relationship
after UPDATE
ON SDSADM.STD_RELATIONSHIP
BEGIN
	-- update the table for STD_Relationship operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Relationship';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RELATIONSHIP FOR SDSADM.STD_RELATIONSHIP;


ALTER TABLE SDSADM.STD_RELATIONSHIP ADD (
  CONSTRAINT PK_STD_RELATIONSHIP
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RELATIONSHIP
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RELATIONSHIPCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_RELATIONSHIPCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RELATIONSHIPNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_RELATIONSHIPNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RELATIONSHIP TO ADR;

GRANT SELECT ON SDSADM.STD_RELATIONSHIP TO ADREXT;

GRANT SELECT ON SDSADM.STD_RELATIONSHIP TO EESRV;

GRANT SELECT ON SDSADM.STD_RELATIONSHIP TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RELATIONSHIP TO LOBR;

GRANT SELECT ON SDSADM.STD_RELATIONSHIP TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATIONSHIP TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RELATIONSHIP TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RELATIONSHIP TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RELATIONALOPERATOR
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RELATIONALOPERATOR CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RELATIONALOPERATOR
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(25 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(150 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RELATNLOPERATOR ON SDSADM.STD_RELATIONALOPERATOR
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RELATNLOPERATORCODE ON SDSADM.STD_RELATIONALOPERATOR
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RELATNLOPERATORNAME ON SDSADM.STD_RELATIONALOPERATOR
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RelatnlOperator
after DELETE
ON SDSADM.STD_RELATIONALOPERATOR
BEGIN
	-- update the table for STD_RelationalOperator operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelationalOperator';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RelatnlOperator
after INSERT
ON SDSADM.STD_RELATIONALOPERATOR
BEGIN
	-- update the table for STD_RelationalOperator operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelationalOperator';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RelatnlOperator
after UPDATE
ON SDSADM.STD_RELATIONALOPERATOR
BEGIN
	-- update the table for STD_RelationalOperator operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelationalOperator';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RELATIONALOPERATOR FOR SDSADM.STD_RELATIONALOPERATOR;


ALTER TABLE SDSADM.STD_RELATIONALOPERATOR ADD (
  CONSTRAINT PK_STD_RELATNLOPERATOR
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RELATNLOPERATOR
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RELATNLOPERATORCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_RELATNLOPERATORCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RELATNLOPERATORNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_RELATNLOPERATORNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RELATIONALOPERATOR TO ADR;

GRANT SELECT ON SDSADM.STD_RELATIONALOPERATOR TO ADREXT;

GRANT SELECT ON SDSADM.STD_RELATIONALOPERATOR TO EESRV;

GRANT SELECT ON SDSADM.STD_RELATIONALOPERATOR TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RELATIONALOPERATOR TO LOBR;

GRANT SELECT ON SDSADM.STD_RELATIONALOPERATOR TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATIONALOPERATOR TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RELATIONALOPERATOR TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RELATIONALOPERATOR TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RELATIONALCONJUNCTION
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RELATIONALCONJUNCTION CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RELATIONALCONJUNCTION
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(25 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RELATNLCONJUNCTN ON SDSADM.STD_RELATIONALCONJUNCTION
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RELATNLCONJUNCTNCODE ON SDSADM.STD_RELATIONALCONJUNCTION
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RELATNLCONJUNCTNNAME ON SDSADM.STD_RELATIONALCONJUNCTION
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RelatnlConjunctn
after DELETE
ON SDSADM.STD_RELATIONALCONJUNCTION
BEGIN
	-- update the table for STD_RelationalConjunction operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelationalConjunction';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RelatnlConjunctn
after INSERT
ON SDSADM.STD_RELATIONALCONJUNCTION
BEGIN
	-- update the table for STD_RelationalConjunction operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelationalConjunction';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RelatnlConjunctn
after UPDATE
ON SDSADM.STD_RELATIONALCONJUNCTION
BEGIN
	-- update the table for STD_RelationalConjunction operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RelationalConjunction';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RELATIONALCONJUNCTION FOR SDSADM.STD_RELATIONALCONJUNCTION;


ALTER TABLE SDSADM.STD_RELATIONALCONJUNCTION ADD (
  CONSTRAINT PK_STD_RELATNLCONJUNCTN
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RELATNLCONJUNCTN
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RELATNLCONJUNCTNCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_RELATNLCONJUNCTNCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RELATNLCONJUNCTNNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_RELATNLCONJUNCTNNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RELATIONALCONJUNCTION TO ADR;

GRANT SELECT ON SDSADM.STD_RELATIONALCONJUNCTION TO ADREXT;

GRANT SELECT ON SDSADM.STD_RELATIONALCONJUNCTION TO EESRV;

GRANT SELECT ON SDSADM.STD_RELATIONALCONJUNCTION TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RELATIONALCONJUNCTION TO LOBR;

GRANT SELECT ON SDSADM.STD_RELATIONALCONJUNCTION TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RELATIONALCONJUNCTION TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RELATIONALCONJUNCTION TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RELATIONALCONJUNCTION TO SDS_SELECT;
ALTER TABLE SDSADM.STD_REJECTEDREMARKSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_REJECTEDREMARKSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_REJECTEDREMARKSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_REJECTEDREMARKSHISTORY ON SDSADM.STD_REJECTEDREMARKSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RejectedRemarksHstry
after DELETE
ON SDSADM.STD_REJECTEDREMARKSHISTORY
BEGIN
	-- update the table for STD_RejectedRemarksHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RejectedRemarksHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RejectedRemarksHstry
after INSERT
ON SDSADM.STD_REJECTEDREMARKSHISTORY
BEGIN
	-- update the table for STD_RejectedRemarksHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RejectedRemarksHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RejectedRemarksHstry
after UPDATE
ON SDSADM.STD_REJECTEDREMARKSHISTORY
BEGIN
	-- update the table for STD_RejectedRemarksHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RejectedRemarksHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_REJECTEDREMARKSHISTORY FOR SDSADM.STD_REJECTEDREMARKSHISTORY;


ALTER TABLE SDSADM.STD_REJECTEDREMARKSHISTORY ADD (
  CONSTRAINT PK_STD_REJECTEDREMARKSHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_REJECTEDREMARKSHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_REJECTEDREMARKSHISTORY ADD (
  CONSTRAINT FKSTD_REJECTEDREMARKSHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_REJECTEDREMARKS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_REJECTEDREMARKSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_REJECTEDREMARKSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_REJECTEDREMARKSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_REJECTEDREMARKS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_REJECTEDREMARKS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_REJECTEDREMARKS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_REJECTEDREMARKS ON SDSADM.STD_REJECTEDREMARKS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_REJECTEDREMARKSCODE ON SDSADM.STD_REJECTEDREMARKS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_REJECTEDREMARKSNAME ON SDSADM.STD_REJECTEDREMARKS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RejectedRemarks
after DELETE
ON SDSADM.STD_REJECTEDREMARKS
BEGIN
	-- update the table for STD_RejectedRemarks operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RejectedRemarks';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RejectedRemarks
after INSERT
ON SDSADM.STD_REJECTEDREMARKS
BEGIN
	-- update the table for STD_RejectedRemarks operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RejectedRemarks';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RejectedRemarks
after UPDATE
ON SDSADM.STD_REJECTEDREMARKS
BEGIN
	-- update the table for STD_RejectedRemarks operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RejectedRemarks';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_REJECTEDREMARKS FOR SDSADM.STD_REJECTEDREMARKS;


ALTER TABLE SDSADM.STD_REJECTEDREMARKS ADD (
  CONSTRAINT PK_STD_REJECTEDREMARKS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_REJECTEDREMARKS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_REJECTEDREMARKSCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_REJECTEDREMARKSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_REJECTEDREMARKSNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_REJECTEDREMARKSNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_REJECTEDREMARKS TO ADR;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKS TO ADREXT;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKS TO EESRV;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_REJECTEDREMARKS TO LOBR;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_REJECTEDREMARKS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_REJECTEDREMARKS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_REGISTRYTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_REGISTRYTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_REGISTRYTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_REGISTRYTYPEHISTORY ON SDSADM.STD_REGISTRYTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RegistryTypeHistory
after DELETE
ON SDSADM.STD_REGISTRYTYPEHISTORY
BEGIN
	-- update the table for STD_RegistryTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RegistryTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RegistryTypeHistory
after INSERT
ON SDSADM.STD_REGISTRYTYPEHISTORY
BEGIN
	-- update the table for STD_RegistryTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RegistryTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RegistryTypeHistory
after UPDATE
ON SDSADM.STD_REGISTRYTYPEHISTORY
BEGIN
	-- update the table for STD_RegistryTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RegistryTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_REGISTRYTYPEHISTORY FOR SDSADM.STD_REGISTRYTYPEHISTORY;


ALTER TABLE SDSADM.STD_REGISTRYTYPEHISTORY ADD (
  CONSTRAINT PK_STD_REGISTRYTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_REGISTRYTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_REGISTRYTYPEHISTORY ADD (
  CONSTRAINT FKSTD_REGISTRYTYPEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_REGISTRYTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_REGISTRYTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_REGISTRYTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_REGISTRYTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_REGISTRYTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_REGISTRYTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_REGISTRYTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_REGISTRYTYPE ON SDSADM.STD_REGISTRYTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_REGISTRYTYPECODE ON SDSADM.STD_REGISTRYTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RegistryType
after DELETE
ON SDSADM.STD_REGISTRYTYPE
BEGIN
	-- update the table for STD_RegistryType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RegistryType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RegistryType
after INSERT
ON SDSADM.STD_REGISTRYTYPE
BEGIN
	-- update the table for STD_RegistryType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RegistryType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RegistryType
after UPDATE
ON SDSADM.STD_REGISTRYTYPE
BEGIN
	-- update the table for STD_RegistryType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RegistryType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_REGISTRYTYPE FOR SDSADM.STD_REGISTRYTYPE;


ALTER TABLE SDSADM.STD_REGISTRYTYPE ADD (
  CONSTRAINT PK_STD_REGISTRYTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_REGISTRYTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_REGISTRYTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_REGISTRYTYPECODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_REGISTRYTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_REGISTRYTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_REGISTRYTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_REGISTRYTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RADIATNEXPSRMTHDHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RADIATNEXPSRMTHDHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RADIATNEXPSRMTHDHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RADIATNEXPSRMTHDHISTORY ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RadiatnExpsrMthdHstry
after DELETE
ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY
BEGIN
	-- update the table for STD_RadiatnExpsrMthdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RadiatnExpsrMthdHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RadiatnExpsrMthdHstry
after INSERT
ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY
BEGIN
	-- update the table for STD_RadiatnExpsrMthdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RadiatnExpsrMthdHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RadiatnExpsrMthdHstry
after UPDATE
ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY
BEGIN
	-- update the table for STD_RadiatnExpsrMthdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RadiatnExpsrMthdHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RADIATNEXPSRMTHDHISTORY FOR SDSADM.STD_RADIATNEXPSRMTHDHISTORY;


ALTER TABLE SDSADM.STD_RADIATNEXPSRMTHDHISTORY ADD (
  CONSTRAINT PK_STD_RADIATNEXPSRMTHDHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RADIATNEXPSRMTHDHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_RADIATNEXPSRMTHDHISTORY ADD (
  CONSTRAINT FKSTD_RDTNEXPSRMTHDHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_RADIATIONEXPOSUREMETHOD (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RADIATNEXPSRMTHDHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RADIATIONEXPOSUREMETHOD
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RADIATIONEXPOSUREMETHOD CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RADIATIONEXPOSUREMETHOD
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RADIATNEXPSRMTHD ON SDSADM.STD_RADIATIONEXPOSUREMETHOD
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RADIATNEXPSRMTHDCODE ON SDSADM.STD_RADIATIONEXPOSUREMETHOD
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RADIATNEXPSRMTHDNAME ON SDSADM.STD_RADIATIONEXPOSUREMETHOD
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RadiatnExpsrMthd
after DELETE
ON SDSADM.STD_RADIATIONEXPOSUREMETHOD
BEGIN
	-- update the table for STD_RadiationExposureMethod operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RadiationExposureMethod';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RadiatnExpsrMthd
after INSERT
ON SDSADM.STD_RADIATIONEXPOSUREMETHOD
BEGIN
	-- update the table for STD_RadiationExposureMethod operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RadiationExposureMethod';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RadiatnExpsrMthd
after UPDATE
ON SDSADM.STD_RADIATIONEXPOSUREMETHOD
BEGIN
	-- update the table for STD_RadiationExposureMethod operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RadiationExposureMethod';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RADIATIONEXPOSUREMETHOD FOR SDSADM.STD_RADIATIONEXPOSUREMETHOD;


ALTER TABLE SDSADM.STD_RADIATIONEXPOSUREMETHOD ADD (
  CONSTRAINT PK_STD_RADIATNEXPSRMTHD
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RADIATNEXPSRMTHD
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RADIATNEXPSRMTHDCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_RADIATNEXPSRMTHDCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RADIATNEXPSRMTHDNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_RADIATNEXPSRMTHDNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO ADR;

GRANT SELECT ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO ADREXT;

GRANT SELECT ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO EESRV;

GRANT SELECT ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO LOBR;

GRANT SELECT ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RADIATIONEXPOSUREMETHOD TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RACEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RACEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RACEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RACEHISTORY ON SDSADM.STD_RACEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_RaceHistory
after DELETE
ON SDSADM.STD_RACEHISTORY
BEGIN
	-- update the table for STD_RaceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RaceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_RaceHistory
after INSERT
ON SDSADM.STD_RACEHISTORY
BEGIN
	-- update the table for STD_RaceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RaceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_RaceHistory
after UPDATE
ON SDSADM.STD_RACEHISTORY
BEGIN
	-- update the table for STD_RaceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_RaceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RACEHISTORY FOR SDSADM.STD_RACEHISTORY;


ALTER TABLE SDSADM.STD_RACEHISTORY ADD (
  CONSTRAINT PK_STD_RACEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RACEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_RACEHISTORY ADD (
  CONSTRAINT FKSTD_RACEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_RACE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RACEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_RACEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_RACEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_RACEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RACEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_RACEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RACEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RACEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RACEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_RACE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_RACE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_RACE
(
  ID           NUMBER(20)                       NOT NULL,
  HL7CODE      VARCHAR2(8 BYTE)                 NOT NULL,
  NAME         VARCHAR2(45 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_RACE ON SDSADM.STD_RACE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RACEHL7CODE ON SDSADM.STD_RACE
(HL7CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_RACENAME ON SDSADM.STD_RACE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_Race
after DELETE
ON SDSADM.STD_RACE
BEGIN
	-- update the table for STD_Race operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Race';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_Race
after INSERT
ON SDSADM.STD_RACE
BEGIN
	-- update the table for STD_Race operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Race';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_Race
after UPDATE
ON SDSADM.STD_RACE
BEGIN
	-- update the table for STD_Race operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Race';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RACE FOR SDSADM.STD_RACE;


ALTER TABLE SDSADM.STD_RACE ADD (
  CONSTRAINT PK_STD_RACE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_RACE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RACEHL7CODE
  UNIQUE (HL7CODE)
  USING INDEX SDSADM.UQSTD_RACEHL7CODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RACENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_RACENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_RACE TO ADR;

GRANT SELECT ON SDSADM.STD_RACE TO ADREXT;

GRANT SELECT ON SDSADM.STD_RACE TO EESRV;

GRANT SELECT ON SDSADM.STD_RACE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_RACE TO LOBR;

GRANT REFERENCES, SELECT ON SDSADM.STD_RACE TO PATS;

GRANT REFERENCES, SELECT ON SDSADM.STD_RACE TO PATSRPTS;

GRANT SELECT ON SDSADM.STD_RACE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_RACE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_RACE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_RACE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PUBLICATIONTOPICHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PUBLICATIONTOPICHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PUBLICATIONTOPICHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PUBLICATIONTOPICHISTORY ON SDSADM.STD_PUBLICATIONTOPICHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PublicationTopicHstry
after DELETE
ON SDSADM.STD_PUBLICATIONTOPICHISTORY
BEGIN
	-- update the table for STD_PublicationTopicHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PublicationTopicHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PublicationTopicHstry
after INSERT
ON SDSADM.STD_PUBLICATIONTOPICHISTORY
BEGIN
	-- update the table for STD_PublicationTopicHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PublicationTopicHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PublicationTopicHstry
after UPDATE
ON SDSADM.STD_PUBLICATIONTOPICHISTORY
BEGIN
	-- update the table for STD_PublicationTopicHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PublicationTopicHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PUBLICATIONTOPICHISTORY FOR SDSADM.STD_PUBLICATIONTOPICHISTORY;


ALTER TABLE SDSADM.STD_PUBLICATIONTOPICHISTORY ADD (
  CONSTRAINT PK_STD_PUBLICATIONTOPICHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PUBLICATIONTOPICHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PUBLICATIONTOPICHISTORY ADD (
  CONSTRAINT FKSTD_PUBLICATIONTPCHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PUBLICATIONTOPIC (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPICHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PUBLICATIONTOPIC
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PUBLICATIONTOPIC CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PUBLICATIONTOPIC
(
  ID         NUMBER(20)                         NOT NULL,
  DATATYPE   VARCHAR2(256 BYTE)                 NOT NULL,
  TOPIC      VARCHAR2(256 BYTE)                 NOT NULL,
  VERSION    INTEGER                            NOT NULL,
  CREATED    TIMESTAMP(6)                       NOT NULL,
  UPDATED    TIMESTAMP(6),
  CREATEDBY  VARCHAR2(32 BYTE)                  NOT NULL,
  UPDATEDBY  VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PUBLICATIONTOPIC ON SDSADM.STD_PUBLICATIONTOPIC
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PUBLICATIONTOPICDATATYPE ON SDSADM.STD_PUBLICATIONTOPIC
(DATATYPE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PublicationTopic
after DELETE
ON SDSADM.STD_PUBLICATIONTOPIC
BEGIN
	-- update the table for STD_PublicationTopic operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PublicationTopic';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PublicationTopic
after INSERT
ON SDSADM.STD_PUBLICATIONTOPIC
BEGIN
	-- update the table for STD_PublicationTopic operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PublicationTopic';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PublicationTopic
after UPDATE
ON SDSADM.STD_PUBLICATIONTOPIC
BEGIN
	-- update the table for STD_PublicationTopic operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PublicationTopic';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PUBLICATIONTOPIC FOR SDSADM.STD_PUBLICATIONTOPIC;


ALTER TABLE SDSADM.STD_PUBLICATIONTOPIC ADD (
  CONSTRAINT PK_STD_PUBLICATIONTOPIC
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PUBLICATIONTOPIC
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PUBLICATIONTOPICDATATYPE
  UNIQUE (DATATYPE)
  USING INDEX SDSADM.UQSTD_PUBLICATIONTOPICDATATYPE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PUBLICATIONTOPIC TO ADR;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPIC TO ADREXT;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPIC TO EESRV;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPIC TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PUBLICATIONTOPIC TO LOBR;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPIC TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PUBLICATIONTOPIC TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPIC TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PUBLICATIONTOPIC TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PTFDISCHARGECODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PTFDISCHARGECODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PTFDISCHARGECODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PTFDISCHARGECODEHISTORY ON SDSADM.STD_PTFDISCHARGECODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PTFDischargeCodeHstry
after DELETE
ON SDSADM.STD_PTFDISCHARGECODEHISTORY
BEGIN
	-- update the table for STD_PTFDischargeCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PTFDischargeCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PTFDischargeCodeHstry
after INSERT
ON SDSADM.STD_PTFDISCHARGECODEHISTORY
BEGIN
	-- update the table for STD_PTFDischargeCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PTFDischargeCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PTFDischargeCodeHstry
after UPDATE
ON SDSADM.STD_PTFDISCHARGECODEHISTORY
BEGIN
	-- update the table for STD_PTFDischargeCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PTFDischargeCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PTFDISCHARGECODEHISTORY FOR SDSADM.STD_PTFDISCHARGECODEHISTORY;


ALTER TABLE SDSADM.STD_PTFDISCHARGECODEHISTORY ADD (
  CONSTRAINT PK_STD_PTFDISCHARGECODEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PTFDISCHARGECODEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PTFDISCHARGECODEHISTORY ADD (
  CONSTRAINT FKSTD_PTFDISCHARGECDHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PTFDISCHARGECODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PTFDISCHARGECODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PTFDISCHARGECODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PTFDISCHARGECODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PTFDISCHARGECODE ON SDSADM.STD_PTFDISCHARGECODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PTFDISCHARGECODECODE ON SDSADM.STD_PTFDISCHARGECODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PTFDISCHARGECODENAME ON SDSADM.STD_PTFDISCHARGECODE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PTFDischargeCode
after DELETE
ON SDSADM.STD_PTFDISCHARGECODE
BEGIN
	-- update the table for STD_PTFDischargeCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PTFDischargeCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PTFDischargeCode
after INSERT
ON SDSADM.STD_PTFDISCHARGECODE
BEGIN
	-- update the table for STD_PTFDischargeCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PTFDischargeCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PTFDischargeCode
after UPDATE
ON SDSADM.STD_PTFDISCHARGECODE
BEGIN
	-- update the table for STD_PTFDischargeCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PTFDischargeCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PTFDISCHARGECODE FOR SDSADM.STD_PTFDISCHARGECODE;


ALTER TABLE SDSADM.STD_PTFDISCHARGECODE ADD (
  CONSTRAINT PK_STD_PTFDISCHARGECODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PTFDISCHARGECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PTFDISCHARGECODECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PTFDISCHARGECODECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PTFDISCHARGECODENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PTFDISCHARGECODENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PTFDISCHARGECODE TO ADR;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODE TO EESRV;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PTFDISCHARGECODE TO LOBR;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PTFDISCHARGECODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PTFDISCHARGECODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PSEUDOSSNREASONHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PSEUDOSSNREASONHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PSEUDOSSNREASONHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PSEUDOSSNREASONHISTORY ON SDSADM.STD_PSEUDOSSNREASONHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PseudoSSNReasonHstry
after DELETE
ON SDSADM.STD_PSEUDOSSNREASONHISTORY
BEGIN
	-- update the table for STD_PseudoSSNReasonHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PseudoSSNReasonHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PseudoSSNReasonHstry
after INSERT
ON SDSADM.STD_PSEUDOSSNREASONHISTORY
BEGIN
	-- update the table for STD_PseudoSSNReasonHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PseudoSSNReasonHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PseudoSSNReasonHstry
after UPDATE
ON SDSADM.STD_PSEUDOSSNREASONHISTORY
BEGIN
	-- update the table for STD_PseudoSSNReasonHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PseudoSSNReasonHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PSEUDOSSNREASONHISTORY FOR SDSADM.STD_PSEUDOSSNREASONHISTORY;


ALTER TABLE SDSADM.STD_PSEUDOSSNREASONHISTORY ADD (
  CONSTRAINT PK_STD_PSEUDOSSNREASONHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PSEUDOSSNREASONHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PSEUDOSSNREASONHISTORY ADD (
  CONSTRAINT FKSTD_PSEUDOSSNREASONHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PSEUDOSSNREASON (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASONHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PSEUDOSSNREASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PSEUDOSSNREASON CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PSEUDOSSNREASON
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(1 BYTE)                     NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PSEUDOSSNREASON ON SDSADM.STD_PSEUDOSSNREASON
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PSEUDOSSNREASONCODE ON SDSADM.STD_PSEUDOSSNREASON
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PSEUDOSSNREASONNAME ON SDSADM.STD_PSEUDOSSNREASON
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PseudoSSNReason
after DELETE
ON SDSADM.STD_PSEUDOSSNREASON
BEGIN
	-- update the table for STD_PseudoSSNReason operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PseudoSSNReason';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PseudoSSNReason
after INSERT
ON SDSADM.STD_PSEUDOSSNREASON
BEGIN
	-- update the table for STD_PseudoSSNReason operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PseudoSSNReason';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PseudoSSNReason
after UPDATE
ON SDSADM.STD_PSEUDOSSNREASON
BEGIN
	-- update the table for STD_PseudoSSNReason operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PseudoSSNReason';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PSEUDOSSNREASON FOR SDSADM.STD_PSEUDOSSNREASON;


ALTER TABLE SDSADM.STD_PSEUDOSSNREASON ADD (
  CONSTRAINT PK_STD_PSEUDOSSNREASON
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PSEUDOSSNREASON
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PSEUDOSSNREASONCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PSEUDOSSNREASONCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PSEUDOSSNREASONNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PSEUDOSSNREASONNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PSEUDOSSNREASON TO ADR;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASON TO ADREXT;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASON TO EESRV;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASON TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PSEUDOSSNREASON TO LOBR;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASON TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PSEUDOSSNREASON TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASON TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PSEUDOSSNREASON TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PROGRAMOFSTUDYHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PROGRAMOFSTUDYHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PROGRAMOFSTUDYHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PROGRAMOFSTUDYHISTORY ON SDSADM.STD_PROGRAMOFSTUDYHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ProgramOfStudyHistory
after DELETE
ON SDSADM.STD_PROGRAMOFSTUDYHISTORY
BEGIN
	-- update the table for STD_ProgramOfStudyHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProgramOfStudyHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ProgramOfStudyHistory
after INSERT
ON SDSADM.STD_PROGRAMOFSTUDYHISTORY
BEGIN
	-- update the table for STD_ProgramOfStudyHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProgramOfStudyHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ProgramOfStudyHistory
after UPDATE
ON SDSADM.STD_PROGRAMOFSTUDYHISTORY
BEGIN
	-- update the table for STD_ProgramOfStudyHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProgramOfStudyHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PROGRAMOFSTUDYHISTORY FOR SDSADM.STD_PROGRAMOFSTUDYHISTORY;


ALTER TABLE SDSADM.STD_PROGRAMOFSTUDYHISTORY ADD (
  CONSTRAINT PK_STD_PROGRAMOFSTUDYHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PROGRAMOFSTUDYHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PROGRAMOFSTUDYHISTORY ADD (
  CONSTRAINT FKSTD_PROGRAMOFSTUDYHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PROGRAMOFSTUDY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDYHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PROGRAMOFSTUDY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PROGRAMOFSTUDY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PROGRAMOFSTUDY
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(10 BYTE)                NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(150 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PROGRAMOFSTUDY ON SDSADM.STD_PROGRAMOFSTUDY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PROGRAMOFSTUDYCODE ON SDSADM.STD_PROGRAMOFSTUDY
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PROGRAMOFSTUDYNAME ON SDSADM.STD_PROGRAMOFSTUDY
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ProgramOfStudy
after DELETE
ON SDSADM.STD_PROGRAMOFSTUDY
BEGIN
	-- update the table for STD_ProgramOfStudy operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProgramOfStudy';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ProgramOfStudy
after INSERT
ON SDSADM.STD_PROGRAMOFSTUDY
BEGIN
	-- update the table for STD_ProgramOfStudy operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProgramOfStudy';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ProgramOfStudy
after UPDATE
ON SDSADM.STD_PROGRAMOFSTUDY
BEGIN
	-- update the table for STD_ProgramOfStudy operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProgramOfStudy';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PROGRAMOFSTUDY FOR SDSADM.STD_PROGRAMOFSTUDY;


ALTER TABLE SDSADM.STD_PROGRAMOFSTUDY ADD (
  CONSTRAINT PK_STD_PROGRAMOFSTUDY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PROGRAMOFSTUDY
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PROGRAMOFSTUDYCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PROGRAMOFSTUDYCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PROGRAMOFSTUDYNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PROGRAMOFSTUDYNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PROGRAMOFSTUDY TO ADR;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDY TO EESRV;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PROGRAMOFSTUDY TO LOBR;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PROGRAMOFSTUDY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PROGRAMOFSTUDY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PROCEDURECODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PROCEDURECODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PROCEDURECODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PROCEDURECODEHISTORY ON SDSADM.STD_PROCEDURECODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ProcedureCodeHistory
after DELETE
ON SDSADM.STD_PROCEDURECODEHISTORY
BEGIN
	-- update the table for STD_ProcedureCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProcedureCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ProcedureCodeHistory
after INSERT
ON SDSADM.STD_PROCEDURECODEHISTORY
BEGIN
	-- update the table for STD_ProcedureCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProcedureCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ProcedureCodeHistory
after UPDATE
ON SDSADM.STD_PROCEDURECODEHISTORY
BEGIN
	-- update the table for STD_ProcedureCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProcedureCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PROCEDURECODEHISTORY FOR SDSADM.STD_PROCEDURECODEHISTORY;


ALTER TABLE SDSADM.STD_PROCEDURECODEHISTORY ADD (
  CONSTRAINT PK_STD_PROCEDURECODEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PROCEDURECODEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PROCEDURECODEHISTORY ADD (
  CONSTRAINT FKSTD_PROCEDURECODEHISTORYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PROCEDURECODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PROCEDURECODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PROCEDURECODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PROCEDURECODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PROCEDURECODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PROCEDURECODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PROCEDURECODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PROCEDURECODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PROCEDURECODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PROCEDURECODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PROCEDURECODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PROCEDURECODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PROCEDURECODE
(
  ID            NUMBER(20)                      NOT NULL,
  CODE          VARCHAR2(50 BYTE)               NOT NULL,
  NAME          VARCHAR2(60 BYTE)               NOT NULL,
  CODESET_TYPE  VARCHAR2(6 BYTE)                NOT NULL,
  DESCRIPTION   VARCHAR2(100 BYTE),
  VERSION       INTEGER                         NOT NULL,
  CREATED       TIMESTAMP(6)                    NOT NULL,
  UPDATED       TIMESTAMP(6),
  CREATEDBY     VARCHAR2(32 BYTE)               NOT NULL,
  UPDATEDBY     VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PROCEDURECODE ON SDSADM.STD_PROCEDURECODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PROCEDURECODECODE ON SDSADM.STD_PROCEDURECODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ProcedureCode
after DELETE
ON SDSADM.STD_PROCEDURECODE
BEGIN
	-- update the table for STD_ProcedureCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProcedureCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ProcedureCode
after INSERT
ON SDSADM.STD_PROCEDURECODE
BEGIN
	-- update the table for STD_ProcedureCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProcedureCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ProcedureCode
after UPDATE
ON SDSADM.STD_PROCEDURECODE
BEGIN
	-- update the table for STD_ProcedureCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ProcedureCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PROCEDURECODE FOR SDSADM.STD_PROCEDURECODE;


ALTER TABLE SDSADM.STD_PROCEDURECODE ADD (
  CONSTRAINT PK_STD_PROCEDURECODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PROCEDURECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PROCEDURECODECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PROCEDURECODECODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PROCEDURECODE TO ADR;

GRANT SELECT ON SDSADM.STD_PROCEDURECODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PROCEDURECODE TO EESRV;

GRANT SELECT ON SDSADM.STD_PROCEDURECODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PROCEDURECODE TO LOBR;

GRANT SELECT ON SDSADM.STD_PROCEDURECODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PROCEDURECODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PROCEDURECODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PROCEDURECODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PRIMCARETMPURPCODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PRIMCARETMPURPCODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PRIMCARETMPURPCODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PRIMCARETMPURPCODEHSTRY ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PrimCareTmPurpCdHstry
after DELETE
ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY
BEGIN
	-- update the table for STD_PrimCareTmPurpCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrimCareTmPurpCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PrimCareTmPurpCdHstry
after INSERT
ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY
BEGIN
	-- update the table for STD_PrimCareTmPurpCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrimCareTmPurpCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PrimCareTmPurpCdHstry
after UPDATE
ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY
BEGIN
	-- update the table for STD_PrimCareTmPurpCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrimCareTmPurpCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PRIMCARETMPURPCODEHISTORY FOR SDSADM.STD_PRIMCARETMPURPCODEHISTORY;


ALTER TABLE SDSADM.STD_PRIMCARETMPURPCODEHISTORY ADD (
  CONSTRAINT PK_STD_PRIMCARETMPURPCODEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PRIMCARETMPURPCODEHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PRIMCARETMPURPCODEHISTORY ADD (
  CONSTRAINT FKSTD_PRIMCARETMPRPCDHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PRIMCARETMPURPCODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PRIMCARETMPURPCODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PRIMCARETMPURPCODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PRIMCARETMPURPCODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(5 BYTE)                 NOT NULL,
  NAME         VARCHAR2(35 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(200 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PRIMCARETMPURPCODE ON SDSADM.STD_PRIMCARETMPURPCODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PRIMCARETMPURPCODECODE ON SDSADM.STD_PRIMCARETMPURPCODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PRIMCARETMPURPCODENAME ON SDSADM.STD_PRIMCARETMPURPCODE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PrimCareTmPurpCode
after DELETE
ON SDSADM.STD_PRIMCARETMPURPCODE
BEGIN
	-- update the table for STD_PrimCareTmPurpCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrimCareTmPurpCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PrimCareTmPurpCode
after INSERT
ON SDSADM.STD_PRIMCARETMPURPCODE
BEGIN
	-- update the table for STD_PrimCareTmPurpCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrimCareTmPurpCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PrimCareTmPurpCode
after UPDATE
ON SDSADM.STD_PRIMCARETMPURPCODE
BEGIN
	-- update the table for STD_PrimCareTmPurpCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrimCareTmPurpCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PRIMCARETMPURPCODE FOR SDSADM.STD_PRIMCARETMPURPCODE;


ALTER TABLE SDSADM.STD_PRIMCARETMPURPCODE ADD (
  CONSTRAINT PK_STD_PRIMCARETMPURPCODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PRIMCARETMPURPCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PRIMCARETMPURPCODECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PRIMCARETMPURPCODECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PRIMCARETMPURPCODENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PRIMCARETMPURPCODENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PRIMCARETMPURPCODE TO ADR;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODE TO EESRV;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PRIMCARETMPURPCODE TO LOBR;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PRIMCARETMPURPCODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PRIMCARETMPURPCODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PREFFACSRCDESIGHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PREFFACSRCDESIGHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PREFFACSRCDESIGHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PREFFACSRCDESIGHISTORY ON SDSADM.STD_PREFFACSRCDESIGHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PrefFacSrcDesigHstry
after DELETE
ON SDSADM.STD_PREFFACSRCDESIGHISTORY
BEGIN
	-- update the table for STD_PrefFacSrcDesigHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrefFacSrcDesigHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PrefFacSrcDesigHstry
after INSERT
ON SDSADM.STD_PREFFACSRCDESIGHISTORY
BEGIN
	-- update the table for STD_PrefFacSrcDesigHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrefFacSrcDesigHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PrefFacSrcDesigHstry
after UPDATE
ON SDSADM.STD_PREFFACSRCDESIGHISTORY
BEGIN
	-- update the table for STD_PrefFacSrcDesigHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrefFacSrcDesigHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PREFFACSRCDESIGHISTORY FOR SDSADM.STD_PREFFACSRCDESIGHISTORY;


ALTER TABLE SDSADM.STD_PREFFACSRCDESIGHISTORY ADD (
  CONSTRAINT PK_STD_PREFFACSRCDESIGHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PREFFACSRCDESIGHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PREFFACSRCDESIGHISTORY ADD (
  CONSTRAINT FKSTD_PREFFACSRCDESIGHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PREFFACSRCDESIG (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIGHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PREFFACSRCDESIG
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PREFFACSRCDESIG CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PREFFACSRCDESIG
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(5 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PREFFACSRCDESIG ON SDSADM.STD_PREFFACSRCDESIG
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PREFFACSRCDESIGCODE ON SDSADM.STD_PREFFACSRCDESIG
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PREFFACSRCDESIGNAME ON SDSADM.STD_PREFFACSRCDESIG
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PrefFacSrcDesig
after DELETE
ON SDSADM.STD_PREFFACSRCDESIG
BEGIN
	-- update the table for STD_PrefFacSrcDesig operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrefFacSrcDesig';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PrefFacSrcDesig
after INSERT
ON SDSADM.STD_PREFFACSRCDESIG
BEGIN
	-- update the table for STD_PrefFacSrcDesig operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrefFacSrcDesig';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PrefFacSrcDesig
after UPDATE
ON SDSADM.STD_PREFFACSRCDESIG
BEGIN
	-- update the table for STD_PrefFacSrcDesig operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PrefFacSrcDesig';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PREFFACSRCDESIG FOR SDSADM.STD_PREFFACSRCDESIG;


ALTER TABLE SDSADM.STD_PREFFACSRCDESIG ADD (
  CONSTRAINT PK_STD_PREFFACSRCDESIG
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PREFFACSRCDESIG
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PREFFACSRCDESIGCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PREFFACSRCDESIGCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PREFFACSRCDESIGNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PREFFACSRCDESIGNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PREFFACSRCDESIG TO ADR;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIG TO ADREXT;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIG TO EESRV;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIG TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PREFFACSRCDESIG TO LOBR;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIG TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PREFFACSRCDESIG TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIG TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PREFFACSRCDESIG TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POWPERIODHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POWPERIODHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POWPERIODHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POWPERIODHISTORY ON SDSADM.STD_POWPERIODHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_POWPeriodHistory
after DELETE
ON SDSADM.STD_POWPERIODHISTORY
BEGIN
	-- update the table for STD_POWPeriodHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWPeriodHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_POWPeriodHistory
after INSERT
ON SDSADM.STD_POWPERIODHISTORY
BEGIN
	-- update the table for STD_POWPeriodHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWPeriodHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_POWPeriodHistory
after UPDATE
ON SDSADM.STD_POWPERIODHISTORY
BEGIN
	-- update the table for STD_POWPeriodHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWPeriodHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POWPERIODHISTORY FOR SDSADM.STD_POWPERIODHISTORY;


ALTER TABLE SDSADM.STD_POWPERIODHISTORY ADD (
  CONSTRAINT PK_STD_POWPERIODHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POWPERIODHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_POWPERIODHISTORY ADD (
  CONSTRAINT FKSTD_POWPERIODHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_POWPERIOD (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POWPERIODHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_POWPERIODHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_POWPERIODHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_POWPERIODHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POWPERIODHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_POWPERIODHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWPERIODHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POWPERIODHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POWPERIODHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POWPERIOD
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POWPERIOD CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POWPERIOD
(
  ID             NUMBER(20)                     NOT NULL,
  CODE           CHAR(1 BYTE)                   NOT NULL,
  NAME           VARCHAR2(30 BYTE)              NOT NULL,
  ALTERNATENAME  VARCHAR2(14 BYTE)              NOT NULL,
  SHORTENEDNAME  VARCHAR2(28 BYTE)              NOT NULL,
  VERSION        INTEGER                        NOT NULL,
  CREATED        TIMESTAMP(6)                   NOT NULL,
  UPDATED        TIMESTAMP(6),
  CREATEDBY      VARCHAR2(32 BYTE)              NOT NULL,
  UPDATEDBY      VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POWPERIOD ON SDSADM.STD_POWPERIOD
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_POWPERIODCODE ON SDSADM.STD_POWPERIOD
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_POWPeriod
after DELETE
ON SDSADM.STD_POWPERIOD
BEGIN
	-- update the table for STD_POWPeriod operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWPeriod';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_POWPeriod
after INSERT
ON SDSADM.STD_POWPERIOD
BEGIN
	-- update the table for STD_POWPeriod operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWPeriod';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_POWPeriod
after UPDATE
ON SDSADM.STD_POWPERIOD
BEGIN
	-- update the table for STD_POWPeriod operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWPeriod';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POWPERIOD FOR SDSADM.STD_POWPERIOD;


ALTER TABLE SDSADM.STD_POWPERIOD ADD (
  CONSTRAINT PK_STD_POWPERIOD
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POWPERIOD
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_POWPERIODCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_POWPERIODCODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POWPERIOD TO ADR;

GRANT SELECT ON SDSADM.STD_POWPERIOD TO ADREXT;

GRANT SELECT ON SDSADM.STD_POWPERIOD TO EESRV;

GRANT SELECT ON SDSADM.STD_POWPERIOD TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POWPERIOD TO LOBR;

GRANT SELECT ON SDSADM.STD_POWPERIOD TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWPERIOD TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POWPERIOD TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POWPERIOD TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POWDOCUMENTTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POWDOCUMENTTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POWDOCUMENTTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POWDOCUMENTTYPEHISTORY ON SDSADM.STD_POWDOCUMENTTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_POWDocumentTypeHstry
after DELETE
ON SDSADM.STD_POWDOCUMENTTYPEHISTORY
BEGIN
	-- update the table for STD_POWDocumentTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDocumentTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_POWDocumentTypeHstry
after INSERT
ON SDSADM.STD_POWDOCUMENTTYPEHISTORY
BEGIN
	-- update the table for STD_POWDocumentTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDocumentTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_POWDocumentTypeHstry
after UPDATE
ON SDSADM.STD_POWDOCUMENTTYPEHISTORY
BEGIN
	-- update the table for STD_POWDocumentTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDocumentTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POWDOCUMENTTYPEHISTORY FOR SDSADM.STD_POWDOCUMENTTYPEHISTORY;


ALTER TABLE SDSADM.STD_POWDOCUMENTTYPEHISTORY ADD (
  CONSTRAINT PK_STD_POWDOCUMENTTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POWDOCUMENTTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_POWDOCUMENTTYPEHISTORY ADD (
  CONSTRAINT FKSTD_POWDOCUMENTTYPEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_POWDOCUMENTTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POWDOCUMENTTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POWDOCUMENTTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POWDOCUMENTTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POWDOCUMENTTYPE ON SDSADM.STD_POWDOCUMENTTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_POWDOCUMENTTYPECODE ON SDSADM.STD_POWDOCUMENTTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_POWDocumentType
after DELETE
ON SDSADM.STD_POWDOCUMENTTYPE
BEGIN
	-- update the table for STD_POWDocumentType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDocumentType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_POWDocumentType
after INSERT
ON SDSADM.STD_POWDOCUMENTTYPE
BEGIN
	-- update the table for STD_POWDocumentType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDocumentType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_POWDocumentType
after UPDATE
ON SDSADM.STD_POWDOCUMENTTYPE
BEGIN
	-- update the table for STD_POWDocumentType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDocumentType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POWDOCUMENTTYPE FOR SDSADM.STD_POWDOCUMENTTYPE;


ALTER TABLE SDSADM.STD_POWDOCUMENTTYPE ADD (
  CONSTRAINT PK_STD_POWDOCUMENTTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POWDOCUMENTTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_POWDOCUMENTTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_POWDOCUMENTTYPECODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POWDOCUMENTTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POWDOCUMENTTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWDOCUMENTTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POWDOCUMENTTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POWDATASOURCETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POWDATASOURCETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POWDATASOURCETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POWDATASOURCETYPEHSTRY ON SDSADM.STD_POWDATASOURCETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_POWDataSourceTypHstry
after DELETE
ON SDSADM.STD_POWDATASOURCETYPEHISTORY
BEGIN
	-- update the table for STD_POWDataSourceTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDataSourceTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_POWDataSourceTypHstry
after INSERT
ON SDSADM.STD_POWDATASOURCETYPEHISTORY
BEGIN
	-- update the table for STD_POWDataSourceTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDataSourceTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_POWDataSourceTypHstry
after UPDATE
ON SDSADM.STD_POWDATASOURCETYPEHISTORY
BEGIN
	-- update the table for STD_POWDataSourceTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDataSourceTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POWDATASOURCETYPEHISTORY FOR SDSADM.STD_POWDATASOURCETYPEHISTORY;


ALTER TABLE SDSADM.STD_POWDATASOURCETYPEHISTORY ADD (
  CONSTRAINT PK_STD_POWDATASOURCETYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POWDATASOURCETYPEHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_POWDATASOURCETYPEHISTORY ADD (
  CONSTRAINT FKSTD_POWDATASRCTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_POWDATASOURCETYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POWDATASOURCETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POWDATASOURCETYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POWDATASOURCETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(10 BYTE)                NOT NULL,
  NAME         VARCHAR2(60 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POWDATASOURCETYPE ON SDSADM.STD_POWDATASOURCETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_POWDATASOURCETYPECODE ON SDSADM.STD_POWDATASOURCETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_POWDATASOURCETYPENAME ON SDSADM.STD_POWDATASOURCETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_POWDataSourceType
after DELETE
ON SDSADM.STD_POWDATASOURCETYPE
BEGIN
	-- update the table for STD_POWDataSourceType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDataSourceType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_POWDataSourceType
after INSERT
ON SDSADM.STD_POWDATASOURCETYPE
BEGIN
	-- update the table for STD_POWDataSourceType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDataSourceType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_POWDataSourceType
after UPDATE
ON SDSADM.STD_POWDATASOURCETYPE
BEGIN
	-- update the table for STD_POWDataSourceType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWDataSourceType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POWDATASOURCETYPE FOR SDSADM.STD_POWDATASOURCETYPE;


ALTER TABLE SDSADM.STD_POWDATASOURCETYPE ADD (
  CONSTRAINT PK_STD_POWDATASOURCETYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POWDATASOURCETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_POWDATASOURCETYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_POWDATASOURCETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_POWDATASOURCETYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_POWDATASOURCETYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POWDATASOURCETYPE TO ADR;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POWDATASOURCETYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWDATASOURCETYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POWDATASOURCETYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POWCONFINELOCNTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POWCONFINELOCNTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POWCONFINELOCNTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POWCONFINELOCNTYPEHSTRY ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_POWConfineLcnTypHstry
after DELETE
ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY
BEGIN
	-- update the table for STD_POWConfineLocnTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWConfineLocnTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_POWConfineLcnTypHstry
after INSERT
ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY
BEGIN
	-- update the table for STD_POWConfineLocnTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWConfineLocnTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_POWConfineLcnTypHstry
after UPDATE
ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY
BEGIN
	-- update the table for STD_POWConfineLocnTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWConfineLocnTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POWCONFINELOCNTYPEHISTORY FOR SDSADM.STD_POWCONFINELOCNTYPEHISTORY;


ALTER TABLE SDSADM.STD_POWCONFINELOCNTYPEHISTORY ADD (
  CONSTRAINT PK_STD_POWCONFINELOCNTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POWCONFINELOCNTYPEHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_POWCONFINELOCNTYPEHISTORY ADD (
  CONSTRAINT FKSTD_POWCNFNLCNTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_POWCONFINELOCNTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POWCONFINELOCNTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POWCONFINELOCNTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POWCONFINELOCNTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POWCONFINELOCNTYPE ON SDSADM.STD_POWCONFINELOCNTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_POWCONFINELOCNTYPECODE ON SDSADM.STD_POWCONFINELOCNTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_POWConfineLocnType
after DELETE
ON SDSADM.STD_POWCONFINELOCNTYPE
BEGIN
	-- update the table for STD_POWConfineLocnType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWConfineLocnType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_POWConfineLocnType
after INSERT
ON SDSADM.STD_POWCONFINELOCNTYPE
BEGIN
	-- update the table for STD_POWConfineLocnType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWConfineLocnType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_POWConfineLocnType
after UPDATE
ON SDSADM.STD_POWCONFINELOCNTYPE
BEGIN
	-- update the table for STD_POWConfineLocnType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_POWConfineLocnType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POWCONFINELOCNTYPE FOR SDSADM.STD_POWCONFINELOCNTYPE;


ALTER TABLE SDSADM.STD_POWCONFINELOCNTYPE ADD (
  CONSTRAINT PK_STD_POWCONFINELOCNTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POWCONFINELOCNTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_POWCONFINELOCNTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_POWCONFINELOCNTYPECODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POWCONFINELOCNTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POWCONFINELOCNTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWCONFINELOCNTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POWCONFINELOCNTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POWCASUALTYLOCATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POWCASUALTYLOCATION CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POWCASUALTYLOCATION
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(60 BYTE)                NOT NULL,
  LOCATION     VARCHAR2(60 BYTE),
  CITY         VARCHAR2(60 BYTE),
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POWCASLOCN ON SDSADM.STD_POWCASUALTYLOCATION
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_POWCASLOCNCODE ON SDSADM.STD_POWCASUALTYLOCATION
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PowCasLocn
after DELETE
ON SDSADM.STD_POWCASUALTYLOCATION
BEGIN
	-- update the table for STD_PowCasualtyLocation operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PowCasualtyLocation';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PowCasLocn
after INSERT
ON SDSADM.STD_POWCASUALTYLOCATION
BEGIN
	-- update the table for STD_PowCasualtyLocation operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PowCasualtyLocation';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PowCasLocn
after UPDATE
ON SDSADM.STD_POWCASUALTYLOCATION
BEGIN
	-- update the table for STD_PowCasualtyLocation operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PowCasualtyLocation';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POWCASUALTYLOCATION FOR SDSADM.STD_POWCASUALTYLOCATION;


ALTER TABLE SDSADM.STD_POWCASUALTYLOCATION ADD (
  CONSTRAINT PK_STD_POWCASLOCN
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POWCASLOCN
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_POWCASLOCNCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_POWCASLOCNCODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POWCASUALTYLOCATION TO ADR;

GRANT SELECT ON SDSADM.STD_POWCASUALTYLOCATION TO ADREXT;

GRANT SELECT ON SDSADM.STD_POWCASUALTYLOCATION TO EESRV;

GRANT SELECT ON SDSADM.STD_POWCASUALTYLOCATION TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POWCASUALTYLOCATION TO LOBR;

GRANT SELECT ON SDSADM.STD_POWCASUALTYLOCATION TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWCASUALTYLOCATION TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POWCASUALTYLOCATION TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POWCASUALTYLOCATION TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POWCASLOCNHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POWCASLOCNHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POWCASLOCNHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POWCASLOCNHISTORY ON SDSADM.STD_POWCASLOCNHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PowCasLocnHistory
after DELETE
ON SDSADM.STD_POWCASLOCNHISTORY
BEGIN
	-- update the table for STD_PowCasLocnHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PowCasLocnHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PowCasLocnHistory
after INSERT
ON SDSADM.STD_POWCASLOCNHISTORY
BEGIN
	-- update the table for STD_PowCasLocnHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PowCasLocnHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PowCasLocnHistory
after UPDATE
ON SDSADM.STD_POWCASLOCNHISTORY
BEGIN
	-- update the table for STD_PowCasLocnHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PowCasLocnHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POWCASLOCNHISTORY FOR SDSADM.STD_POWCASLOCNHISTORY;


ALTER TABLE SDSADM.STD_POWCASLOCNHISTORY ADD (
  CONSTRAINT PK_STD_POWCASLOCNHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POWCASLOCNHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_POWCASLOCNHISTORY ADD (
  CONSTRAINT FKSTD_POWCASLOCNHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_POWCASUALTYLOCATION (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POWCASLOCNHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_POWCASLOCNHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_POWCASLOCNHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_POWCASLOCNHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POWCASLOCNHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_POWCASLOCNHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POWCASLOCNHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POWCASLOCNHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POWCASLOCNHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POLICYHOLDERTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POLICYHOLDERTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POLICYHOLDERTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POLICYHOLDERTYPEHISTORY ON SDSADM.STD_POLICYHOLDERTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PolicyHolderTypeHstry
after DELETE
ON SDSADM.STD_POLICYHOLDERTYPEHISTORY
BEGIN
	-- update the table for STD_PolicyHolderTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PolicyHolderTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PolicyHolderTypeHstry
after INSERT
ON SDSADM.STD_POLICYHOLDERTYPEHISTORY
BEGIN
	-- update the table for STD_PolicyHolderTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PolicyHolderTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PolicyHolderTypeHstry
after UPDATE
ON SDSADM.STD_POLICYHOLDERTYPEHISTORY
BEGIN
	-- update the table for STD_PolicyHolderTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PolicyHolderTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POLICYHOLDERTYPEHISTORY FOR SDSADM.STD_POLICYHOLDERTYPEHISTORY;


ALTER TABLE SDSADM.STD_POLICYHOLDERTYPEHISTORY ADD (
  CONSTRAINT PK_STD_POLICYHOLDERTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POLICYHOLDERTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_POLICYHOLDERTYPEHISTORY ADD (
  CONSTRAINT FKSTD_POLICYHOLDERTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_POLICYHOLDERTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_POLICYHOLDERTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_POLICYHOLDERTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_POLICYHOLDERTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_POLICYHOLDERTYPE ON SDSADM.STD_POLICYHOLDERTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_POLICYHOLDERTYPECODE ON SDSADM.STD_POLICYHOLDERTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PolicyHolderType
after DELETE
ON SDSADM.STD_POLICYHOLDERTYPE
BEGIN
	-- update the table for STD_PolicyHolderType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PolicyHolderType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PolicyHolderType
after INSERT
ON SDSADM.STD_POLICYHOLDERTYPE
BEGIN
	-- update the table for STD_PolicyHolderType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PolicyHolderType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PolicyHolderType
after UPDATE
ON SDSADM.STD_POLICYHOLDERTYPE
BEGIN
	-- update the table for STD_PolicyHolderType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PolicyHolderType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_POLICYHOLDERTYPE FOR SDSADM.STD_POLICYHOLDERTYPE;


ALTER TABLE SDSADM.STD_POLICYHOLDERTYPE ADD (
  CONSTRAINT PK_STD_POLICYHOLDERTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_POLICYHOLDERTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_POLICYHOLDERTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_POLICYHOLDERTYPECODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_POLICYHOLDERTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_POLICYHOLDERTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_POLICYHOLDERTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_POLICYHOLDERTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PLANCATEGORYTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PLANCATEGORYTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PLANCATEGORYTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PLANCATEGORYTYPEHISTORY ON SDSADM.STD_PLANCATEGORYTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PlanCategoryTypeHstry
after DELETE
ON SDSADM.STD_PLANCATEGORYTYPEHISTORY
BEGIN
	-- update the table for STD_PlanCategoryTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlanCategoryTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PlanCategoryTypeHstry
after INSERT
ON SDSADM.STD_PLANCATEGORYTYPEHISTORY
BEGIN
	-- update the table for STD_PlanCategoryTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlanCategoryTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PlanCategoryTypeHstry
after UPDATE
ON SDSADM.STD_PLANCATEGORYTYPEHISTORY
BEGIN
	-- update the table for STD_PlanCategoryTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlanCategoryTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PLANCATEGORYTYPEHISTORY FOR SDSADM.STD_PLANCATEGORYTYPEHISTORY;


ALTER TABLE SDSADM.STD_PLANCATEGORYTYPEHISTORY ADD (
  CONSTRAINT PK_STD_PLANCATEGORYTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PLANCATEGORYTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PLANCATEGORYTYPEHISTORY ADD (
  CONSTRAINT FKSTD_PLANCATEGORYTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PLANCATEGORYTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PLANCATEGORYTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PLANCATEGORYTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PLANCATEGORYTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(4 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PLANCATEGORYTYPE ON SDSADM.STD_PLANCATEGORYTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PLANCATEGORYTYPECODE ON SDSADM.STD_PLANCATEGORYTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PLANCATEGORYTYPENAME ON SDSADM.STD_PLANCATEGORYTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PlanCategoryType
after DELETE
ON SDSADM.STD_PLANCATEGORYTYPE
BEGIN
	-- update the table for STD_PlanCategoryType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlanCategoryType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PlanCategoryType
after INSERT
ON SDSADM.STD_PLANCATEGORYTYPE
BEGIN
	-- update the table for STD_PlanCategoryType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlanCategoryType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PlanCategoryType
after UPDATE
ON SDSADM.STD_PLANCATEGORYTYPE
BEGIN
	-- update the table for STD_PlanCategoryType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlanCategoryType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PLANCATEGORYTYPE FOR SDSADM.STD_PLANCATEGORYTYPE;


ALTER TABLE SDSADM.STD_PLANCATEGORYTYPE ADD (
  CONSTRAINT PK_STD_PLANCATEGORYTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PLANCATEGORYTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PLANCATEGORYTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PLANCATEGORYTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PLANCATEGORYTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PLANCATEGORYTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PLANCATEGORYTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PLANCATEGORYTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PLANCATEGORYTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PLANCATEGORYTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PLACEOFADMISSIONHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PLACEOFADMISSIONHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PLACEOFADMISSIONHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PLACEOFADMISSIONHISTORY ON SDSADM.STD_PLACEOFADMISSIONHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PlaceofAdmissionHstry
after DELETE
ON SDSADM.STD_PLACEOFADMISSIONHISTORY
BEGIN
	-- update the table for STD_PlaceofAdmissionHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlaceofAdmissionHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PlaceofAdmissionHstry
after INSERT
ON SDSADM.STD_PLACEOFADMISSIONHISTORY
BEGIN
	-- update the table for STD_PlaceofAdmissionHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlaceofAdmissionHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PlaceofAdmissionHstry
after UPDATE
ON SDSADM.STD_PLACEOFADMISSIONHISTORY
BEGIN
	-- update the table for STD_PlaceofAdmissionHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlaceofAdmissionHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PLACEOFADMISSIONHISTORY FOR SDSADM.STD_PLACEOFADMISSIONHISTORY;


ALTER TABLE SDSADM.STD_PLACEOFADMISSIONHISTORY ADD (
  CONSTRAINT PK_STD_PLACEOFADMISSIONHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PLACEOFADMISSIONHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PLACEOFADMISSIONHISTORY ADD (
  CONSTRAINT FKSTD_PLACEOFADMSSNHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PLACEOFADMISSION (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSIONHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PLACEOFADMISSION
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PLACEOFADMISSION CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PLACEOFADMISSION
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(20 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PLACEOFADMISSION ON SDSADM.STD_PLACEOFADMISSION
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PLACEOFADMISSIONCODE ON SDSADM.STD_PLACEOFADMISSION
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PLACEOFADMISSIONNAME ON SDSADM.STD_PLACEOFADMISSION
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PlaceofAdmission
after DELETE
ON SDSADM.STD_PLACEOFADMISSION
BEGIN
	-- update the table for STD_PlaceofAdmission operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlaceofAdmission';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PlaceofAdmission
after INSERT
ON SDSADM.STD_PLACEOFADMISSION
BEGIN
	-- update the table for STD_PlaceofAdmission operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlaceofAdmission';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PlaceofAdmission
after UPDATE
ON SDSADM.STD_PLACEOFADMISSION
BEGIN
	-- update the table for STD_PlaceofAdmission operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PlaceofAdmission';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PLACEOFADMISSION FOR SDSADM.STD_PLACEOFADMISSION;


ALTER TABLE SDSADM.STD_PLACEOFADMISSION ADD (
  CONSTRAINT PK_STD_PLACEOFADMISSION
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PLACEOFADMISSION
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PLACEOFADMISSIONCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PLACEOFADMISSIONCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PLACEOFADMISSIONNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PLACEOFADMISSIONNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PLACEOFADMISSION TO ADR;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSION TO ADREXT;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSION TO EESRV;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSION TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PLACEOFADMISSION TO LOBR;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSION TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PLACEOFADMISSION TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSION TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PLACEOFADMISSION TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PHONECONTACTTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PHONECONTACTTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PHONECONTACTTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PHONECONTACTTYPEHISTORY ON SDSADM.STD_PHONECONTACTTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PhoneContactTypeHstry
after DELETE
ON SDSADM.STD_PHONECONTACTTYPEHISTORY
BEGIN
	-- update the table for STD_PhoneContactTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneContactTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PhoneContactTypeHstry
after INSERT
ON SDSADM.STD_PHONECONTACTTYPEHISTORY
BEGIN
	-- update the table for STD_PhoneContactTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneContactTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PhoneContactTypeHstry
after UPDATE
ON SDSADM.STD_PHONECONTACTTYPEHISTORY
BEGIN
	-- update the table for STD_PhoneContactTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneContactTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PHONECONTACTTYPEHISTORY FOR SDSADM.STD_PHONECONTACTTYPEHISTORY;


ALTER TABLE SDSADM.STD_PHONECONTACTTYPEHISTORY ADD (
  CONSTRAINT PK_STD_PHONECONTACTTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PHONECONTACTTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PHONECONTACTTYPEHISTORY ADD (
  CONSTRAINT FKSTD_PHONECONTACTTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PHONECONTACTTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PHONECONTACTTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PHONECONTACTTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PHONECONTACTTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PHONECONTACTTYPE ON SDSADM.STD_PHONECONTACTTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PHONECONTACTTYPECODE ON SDSADM.STD_PHONECONTACTTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PHONECONTACTTYPENAME ON SDSADM.STD_PHONECONTACTTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PhoneContactType
after DELETE
ON SDSADM.STD_PHONECONTACTTYPE
BEGIN
	-- update the table for STD_PhoneContactType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneContactType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PhoneContactType
after INSERT
ON SDSADM.STD_PHONECONTACTTYPE
BEGIN
	-- update the table for STD_PhoneContactType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneContactType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PhoneContactType
after UPDATE
ON SDSADM.STD_PHONECONTACTTYPE
BEGIN
	-- update the table for STD_PhoneContactType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneContactType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PHONECONTACTTYPE FOR SDSADM.STD_PHONECONTACTTYPE;


ALTER TABLE SDSADM.STD_PHONECONTACTTYPE ADD (
  CONSTRAINT PK_STD_PHONECONTACTTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PHONECONTACTTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PHONECONTACTTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PHONECONTACTTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PHONECONTACTTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PHONECONTACTTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PHONECONTACTTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PHONECONTACTTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHONECONTACTTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PHONECONTACTTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PHONECHANGESOURCEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PHONECHANGESOURCEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PHONECHANGESOURCEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PHONECHANGESOURCEHSTRY ON SDSADM.STD_PHONECHANGESOURCEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PhoneChangeSrcHstry
after DELETE
ON SDSADM.STD_PHONECHANGESOURCEHISTORY
BEGIN
	-- update the table for STD_PhoneChangeSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneChangeSourceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PhoneChangeSrcHstry
after INSERT
ON SDSADM.STD_PHONECHANGESOURCEHISTORY
BEGIN
	-- update the table for STD_PhoneChangeSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneChangeSourceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PhoneChangeSrcHstry
after UPDATE
ON SDSADM.STD_PHONECHANGESOURCEHISTORY
BEGIN
	-- update the table for STD_PhoneChangeSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneChangeSourceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PHONECHANGESOURCEHISTORY FOR SDSADM.STD_PHONECHANGESOURCEHISTORY;


ALTER TABLE SDSADM.STD_PHONECHANGESOURCEHISTORY ADD (
  CONSTRAINT PK_STD_PHONECHANGESOURCEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PHONECHANGESOURCEHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PHONECHANGESOURCEHISTORY ADD (
  CONSTRAINT FKSTD_PHONECHANGESRCHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PHONECHANGESOURCE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PHONECHANGESOURCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PHONECHANGESOURCE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PHONECHANGESOURCE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PHONECHANGESOURCE ON SDSADM.STD_PHONECHANGESOURCE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PHONECHANGESOURCECODE ON SDSADM.STD_PHONECHANGESOURCE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PHONECHANGESOURCENAME ON SDSADM.STD_PHONECHANGESOURCE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PhoneChangeSource
after DELETE
ON SDSADM.STD_PHONECHANGESOURCE
BEGIN
	-- update the table for STD_PhoneChangeSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneChangeSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PhoneChangeSource
after INSERT
ON SDSADM.STD_PHONECHANGESOURCE
BEGIN
	-- update the table for STD_PhoneChangeSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneChangeSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PhoneChangeSource
after UPDATE
ON SDSADM.STD_PHONECHANGESOURCE
BEGIN
	-- update the table for STD_PhoneChangeSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PhoneChangeSource';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PHONECHANGESOURCE FOR SDSADM.STD_PHONECHANGESOURCE;


ALTER TABLE SDSADM.STD_PHONECHANGESOURCE ADD (
  CONSTRAINT PK_STD_PHONECHANGESOURCE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PHONECHANGESOURCE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PHONECHANGESOURCECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PHONECHANGESOURCECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PHONECHANGESOURCENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PHONECHANGESOURCENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PHONECHANGESOURCE TO ADR;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCE TO EESRV;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PHONECHANGESOURCE TO LOBR;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHONECHANGESOURCE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PHONECHANGESOURCE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PHDATASRCTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PHDATASRCTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PHDATASRCTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PHDATASRCTYPEHISTORY ON SDSADM.STD_PHDATASRCTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PHDataSrcTypeHistory
after DELETE
ON SDSADM.STD_PHDATASRCTYPEHISTORY
BEGIN
	-- update the table for STD_PHDataSrcTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PHDataSrcTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PHDataSrcTypeHistory
after INSERT
ON SDSADM.STD_PHDATASRCTYPEHISTORY
BEGIN
	-- update the table for STD_PHDataSrcTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PHDataSrcTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PHDataSrcTypeHistory
after UPDATE
ON SDSADM.STD_PHDATASRCTYPEHISTORY
BEGIN
	-- update the table for STD_PHDataSrcTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PHDataSrcTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PHDATASRCTYPEHISTORY FOR SDSADM.STD_PHDATASRCTYPEHISTORY;


ALTER TABLE SDSADM.STD_PHDATASRCTYPEHISTORY ADD (
  CONSTRAINT PK_STD_PHDATASRCTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PHDATASRCTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PHDATASRCTYPEHISTORY ADD (
  CONSTRAINT FKSTD_PHDATASRCTYPEHISTORYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PHDATASRCTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PHDATASRCTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PHDATASRCTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHDATASRCTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PHDATASRCTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PHDATASRCTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PHDATASRCTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(60 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PHDATASRCTYPE ON SDSADM.STD_PHDATASRCTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PHDATASRCTYPECODE ON SDSADM.STD_PHDATASRCTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PHDATASRCTYPENAME ON SDSADM.STD_PHDATASRCTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PHDataSrcType
after DELETE
ON SDSADM.STD_PHDATASRCTYPE
BEGIN
	-- update the table for STD_PHDataSrcType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PHDataSrcType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PHDataSrcType
after INSERT
ON SDSADM.STD_PHDATASRCTYPE
BEGIN
	-- update the table for STD_PHDataSrcType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PHDataSrcType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PHDataSrcType
after UPDATE
ON SDSADM.STD_PHDATASRCTYPE
BEGIN
	-- update the table for STD_PHDataSrcType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PHDataSrcType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PHDATASRCTYPE FOR SDSADM.STD_PHDATASRCTYPE;


ALTER TABLE SDSADM.STD_PHDATASRCTYPE ADD (
  CONSTRAINT PK_STD_PHDATASRCTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PHDATASRCTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PHDATASRCTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PHDATASRCTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PHDATASRCTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PHDATASRCTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PHDATASRCTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PHDATASRCTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PHDATASRCTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PHDATASRCTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONRELATIONHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONRELATIONHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONRELATIONHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONRELATIONHISTORY ON SDSADM.STD_PERSONRELATIONHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonRelationHistory
after DELETE
ON SDSADM.STD_PERSONRELATIONHISTORY
BEGIN
	-- update the table for STD_PersonRelationHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonRelationHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonRelationHistory
after INSERT
ON SDSADM.STD_PERSONRELATIONHISTORY
BEGIN
	-- update the table for STD_PersonRelationHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonRelationHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonRelationHistory
after UPDATE
ON SDSADM.STD_PERSONRELATIONHISTORY
BEGIN
	-- update the table for STD_PersonRelationHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonRelationHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONRELATIONHISTORY FOR SDSADM.STD_PERSONRELATIONHISTORY;


ALTER TABLE SDSADM.STD_PERSONRELATIONHISTORY ADD (
  CONSTRAINT PK_STD_PERSONRELATIONHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONRELATIONHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PERSONRELATIONHISTORY ADD (
  CONSTRAINT FKSTD_PERSONRELATIONHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PERSONRELATION (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONRELATIONHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONRELATIONHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONRELATIONHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONRELATIONHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONRELATIONHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONRELATIONHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONRELATIONHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONRELATIONHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONRELATIONHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONRELATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONRELATION CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONRELATION
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(5 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONRELATION ON SDSADM.STD_PERSONRELATION
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONRELATIONCODE ON SDSADM.STD_PERSONRELATION
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONRELATIONNAME ON SDSADM.STD_PERSONRELATION
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonRelation
after DELETE
ON SDSADM.STD_PERSONRELATION
BEGIN
	-- update the table for STD_PersonRelation operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonRelation';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonRelation
after INSERT
ON SDSADM.STD_PERSONRELATION
BEGIN
	-- update the table for STD_PersonRelation operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonRelation';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonRelation
after UPDATE
ON SDSADM.STD_PERSONRELATION
BEGIN
	-- update the table for STD_PersonRelation operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonRelation';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONRELATION FOR SDSADM.STD_PERSONRELATION;


ALTER TABLE SDSADM.STD_PERSONRELATION ADD (
  CONSTRAINT PK_STD_PERSONRELATION
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONRELATION
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONRELATIONCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PERSONRELATIONCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONRELATIONNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PERSONRELATIONNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONRELATION TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONRELATION TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONRELATION TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONRELATION TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONRELATION TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONRELATION TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONRELATION TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONRELATION TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONRELATION TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONMERGESTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONMERGESTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONMERGESTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONMERGESTATUSHSTRY ON SDSADM.STD_PERSONMERGESTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonMergeSttsHstry
after DELETE
ON SDSADM.STD_PERSONMERGESTATUSHISTORY
BEGIN
	-- update the table for STD_PersonMergeStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonMergeStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonMergeSttsHstry
after INSERT
ON SDSADM.STD_PERSONMERGESTATUSHISTORY
BEGIN
	-- update the table for STD_PersonMergeStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonMergeStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonMergeSttsHstry
after UPDATE
ON SDSADM.STD_PERSONMERGESTATUSHISTORY
BEGIN
	-- update the table for STD_PersonMergeStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonMergeStatusHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONMERGESTATUSHISTORY FOR SDSADM.STD_PERSONMERGESTATUSHISTORY;


ALTER TABLE SDSADM.STD_PERSONMERGESTATUSHISTORY ADD (
  CONSTRAINT PK_STD_PERSONMERGESTATUSHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONMERGESTATUSHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PERSONMERGESTATUSHISTORY ADD (
  CONSTRAINT FKSTD_PERSONMERGESTTSHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PERSONMERGESTATUS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONMERGESTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONMERGESTATUS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONMERGESTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(5 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONMERGESTATUS ON SDSADM.STD_PERSONMERGESTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONMERGESTATUSCODE ON SDSADM.STD_PERSONMERGESTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONMERGESTATUSNAME ON SDSADM.STD_PERSONMERGESTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonMergeStatus
after DELETE
ON SDSADM.STD_PERSONMERGESTATUS
BEGIN
	-- update the table for STD_PersonMergeStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonMergeStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonMergeStatus
after INSERT
ON SDSADM.STD_PERSONMERGESTATUS
BEGIN
	-- update the table for STD_PersonMergeStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonMergeStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonMergeStatus
after UPDATE
ON SDSADM.STD_PERSONMERGESTATUS
BEGIN
	-- update the table for STD_PersonMergeStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonMergeStatus';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONMERGESTATUS FOR SDSADM.STD_PERSONMERGESTATUS;


ALTER TABLE SDSADM.STD_PERSONMERGESTATUS ADD (
  CONSTRAINT PK_STD_PERSONMERGESTATUS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONMERGESTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONMERGESTATUSCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PERSONMERGESTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONMERGESTATUSNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PERSONMERGESTATUSNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONMERGESTATUS TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUS TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUS TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONMERGESTATUS TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONMERGESTATUS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONMERGESTATUS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONCONTACTTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONCONTACTTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONCONTACTTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONCONTACTTYPEHSTRY ON SDSADM.STD_PERSONCONTACTTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonContactTypHstry
after DELETE
ON SDSADM.STD_PERSONCONTACTTYPEHISTORY
BEGIN
	-- update the table for STD_PersonContactTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonContactTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonContactTypHstry
after INSERT
ON SDSADM.STD_PERSONCONTACTTYPEHISTORY
BEGIN
	-- update the table for STD_PersonContactTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonContactTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonContactTypHstry
after UPDATE
ON SDSADM.STD_PERSONCONTACTTYPEHISTORY
BEGIN
	-- update the table for STD_PersonContactTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonContactTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONCONTACTTYPEHISTORY FOR SDSADM.STD_PERSONCONTACTTYPEHISTORY;


ALTER TABLE SDSADM.STD_PERSONCONTACTTYPEHISTORY ADD (
  CONSTRAINT PK_STD_PERSONCONTACTTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONCONTACTTYPEHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PERSONCONTACTTYPEHISTORY ADD (
  CONSTRAINT FKSTD_PERSONCNTCTTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PERSONCONTACTTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONCONTACTTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONCONTACTTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONCONTACTTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONCONTACTTYPE ON SDSADM.STD_PERSONCONTACTTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONCONTACTTYPECODE ON SDSADM.STD_PERSONCONTACTTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONCONTACTTYPENAME ON SDSADM.STD_PERSONCONTACTTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonContactType
after DELETE
ON SDSADM.STD_PERSONCONTACTTYPE
BEGIN
	-- update the table for STD_PersonContactType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonContactType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonContactType
after INSERT
ON SDSADM.STD_PERSONCONTACTTYPE
BEGIN
	-- update the table for STD_PersonContactType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonContactType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonContactType
after UPDATE
ON SDSADM.STD_PERSONCONTACTTYPE
BEGIN
	-- update the table for STD_PersonContactType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonContactType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONCONTACTTYPE FOR SDSADM.STD_PERSONCONTACTTYPE;


ALTER TABLE SDSADM.STD_PERSONCONTACTTYPE ADD (
  CONSTRAINT PK_STD_PERSONCONTACTTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONCONTACTTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONCONTACTTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PERSONCONTACTTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONCONTACTTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PERSONCONTACTTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONCONTACTTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONCONTACTTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCONTACTTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONCONTACTTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONCLASSPTHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONCLASSPTHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONCLASSPTHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONCLASSPTHISTORY ON SDSADM.STD_PERSONCLASSPTHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonClassPTHistory
after DELETE
ON SDSADM.STD_PERSONCLASSPTHISTORY
BEGIN
	-- update the table for STD_PersonClassPTHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassPTHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonClassPTHistory
after INSERT
ON SDSADM.STD_PERSONCLASSPTHISTORY
BEGIN
	-- update the table for STD_PersonClassPTHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassPTHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonClassPTHistory
after UPDATE
ON SDSADM.STD_PERSONCLASSPTHISTORY
BEGIN
	-- update the table for STD_PersonClassPTHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassPTHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONCLASSPTHISTORY FOR SDSADM.STD_PERSONCLASSPTHISTORY;


ALTER TABLE SDSADM.STD_PERSONCLASSPTHISTORY ADD (
  CONSTRAINT PK_STD_PERSONCLASSPTHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONCLASSPTHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PERSONCLASSPTHISTORY ADD (
  CONSTRAINT FKSTD_PERSONCLASSPTHISTORYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PERSONCLASSPROVIDERTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONCLASSPTHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPTHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPTHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPTHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONCLASSPTHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPTHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASSPTHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPTHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPTHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONCLASSPROVIDERTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONCLASSPROVIDERTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONCLASSPROVIDERTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONCLASSPT ON SDSADM.STD_PERSONCLASSPROVIDERTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONCLASSPTNAME ON SDSADM.STD_PERSONCLASSPROVIDERTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonClassPT
after DELETE
ON SDSADM.STD_PERSONCLASSPROVIDERTYPE
BEGIN
	-- update the table for STD_PersonClassProviderType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassProviderType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonClassPT
after INSERT
ON SDSADM.STD_PERSONCLASSPROVIDERTYPE
BEGIN
	-- update the table for STD_PersonClassProviderType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassProviderType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonClassPT
after UPDATE
ON SDSADM.STD_PERSONCLASSPROVIDERTYPE
BEGIN
	-- update the table for STD_PersonClassProviderType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassProviderType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONCLASSPROVIDERTYPE FOR SDSADM.STD_PERSONCLASSPROVIDERTYPE;


ALTER TABLE SDSADM.STD_PERSONCLASSPROVIDERTYPE ADD (
  CONSTRAINT PK_STD_PERSONCLASSPT
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONCLASSPT
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONCLASSPTNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PERSONCLASSPTNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONCLASSPROVIDERTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONCLASSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONCLASSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONCLASSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONCLASSHISTORY ON SDSADM.STD_PERSONCLASSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonClassHistory
after DELETE
ON SDSADM.STD_PERSONCLASSHISTORY
BEGIN
	-- update the table for STD_PersonClassHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonClassHistory
after INSERT
ON SDSADM.STD_PERSONCLASSHISTORY
BEGIN
	-- update the table for STD_PersonClassHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonClassHistory
after UPDATE
ON SDSADM.STD_PERSONCLASSHISTORY
BEGIN
	-- update the table for STD_PersonClassHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONCLASSHISTORY FOR SDSADM.STD_PERSONCLASSHISTORY;


ALTER TABLE SDSADM.STD_PERSONCLASSHISTORY ADD (
  CONSTRAINT PK_STD_PERSONCLASSHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONCLASSHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PERSONCLASSHISTORY ADD (
  CONSTRAINT FKSTD_PERSONCLASSHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PERSONCLASS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONCLASSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONCLASSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONCLASSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONCLASSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONCLASSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONCLASSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONCLASSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONCLASSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONCLASSCLASSIFICATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONCLASSCLASSIFICATION CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONCLASSCLASSIFICATION
(
  ID           NUMBER(20)                       NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONCLASSC ON SDSADM.STD_PERSONCLASSCLASSIFICATION
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONCLASSCNAME ON SDSADM.STD_PERSONCLASSCLASSIFICATION
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonClassC
after DELETE
ON SDSADM.STD_PERSONCLASSCLASSIFICATION
BEGIN
	-- update the table for STD_PersonClassClassification operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassClassification';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonClassC
after INSERT
ON SDSADM.STD_PERSONCLASSCLASSIFICATION
BEGIN
	-- update the table for STD_PersonClassClassification operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassClassification';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonClassC
after UPDATE
ON SDSADM.STD_PERSONCLASSCLASSIFICATION
BEGIN
	-- update the table for STD_PersonClassClassification operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassClassification';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONCLASSCLASSIFICATION FOR SDSADM.STD_PERSONCLASSCLASSIFICATION;


ALTER TABLE SDSADM.STD_PERSONCLASSCLASSIFICATION ADD (
  CONSTRAINT PK_STD_PERSONCLASSC
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONCLASSC
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONCLASSCNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PERSONCLASSCNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCLASSIFICATION TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONCLASSCHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONCLASSCHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONCLASSCHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONCLASSCHISTORY ON SDSADM.STD_PERSONCLASSCHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonClassCHistory
after DELETE
ON SDSADM.STD_PERSONCLASSCHISTORY
BEGIN
	-- update the table for STD_PersonClassCHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassCHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonClassCHistory
after INSERT
ON SDSADM.STD_PERSONCLASSCHISTORY
BEGIN
	-- update the table for STD_PersonClassCHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassCHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonClassCHistory
after UPDATE
ON SDSADM.STD_PERSONCLASSCHISTORY
BEGIN
	-- update the table for STD_PersonClassCHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClassCHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONCLASSCHISTORY FOR SDSADM.STD_PERSONCLASSCHISTORY;


ALTER TABLE SDSADM.STD_PERSONCLASSCHISTORY ADD (
  CONSTRAINT PK_STD_PERSONCLASSCHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONCLASSCHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PERSONCLASSCHISTORY ADD (
  CONSTRAINT FKSTD_PERSONCLASSCHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PERSONCLASSCLASSIFICATION (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONCLASSCHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONCLASSCHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASSCHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONCLASSCHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONCLASS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONCLASS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONCLASS
(
  ID                    NUMBER(20)              NOT NULL,
  IEN                   NUMBER(10)              NOT NULL,
  VACODE                VARCHAR2(7 BYTE)        NOT NULL,
  AREAOFSPECIALIZATION  VARCHAR2(100 BYTE),
  ISTRAINEEPERSONCLASS  CHAR(1 BYTE),
  CLASSIFICATION_ID     NUMBER(20),
  PROVIDERTYPE_ID       NUMBER(20)              NOT NULL,
  X12CODE               VARCHAR2(10 BYTE),
  NUCCCODE              VARCHAR2(10 BYTE),
  DESCRIPTION           VARCHAR2(2000 BYTE),
  SOURCE                VARCHAR2(1000 BYTE),
  VERSION               INTEGER                 NOT NULL,
  CREATED               TIMESTAMP(6)            NOT NULL,
  UPDATED               TIMESTAMP(6),
  CREATEDBY             VARCHAR2(32 BYTE)       NOT NULL,
  UPDATEDBY             VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONCLASS ON SDSADM.STD_PERSONCLASS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONCLASSIEN ON SDSADM.STD_PERSONCLASS
(IEN)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONCLASSNUCCCODE ON SDSADM.STD_PERSONCLASS
(NUCCCODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONCLASSVACODE ON SDSADM.STD_PERSONCLASS
(VACODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONCLASSX12CODE ON SDSADM.STD_PERSONCLASS
(X12CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonClass
after DELETE
ON SDSADM.STD_PERSONCLASS
BEGIN
	-- update the table for STD_PersonClass operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClass';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonClass
after INSERT
ON SDSADM.STD_PERSONCLASS
BEGIN
	-- update the table for STD_PersonClass operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClass';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonClass
after UPDATE
ON SDSADM.STD_PERSONCLASS
BEGIN
	-- update the table for STD_PersonClass operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonClass';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONCLASS FOR SDSADM.STD_PERSONCLASS;


ALTER TABLE SDSADM.STD_PERSONCLASS ADD (
  CONSTRAINT PK_STD_PERSONCLASS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONCLASS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONCLASSIEN
  UNIQUE (IEN)
  USING INDEX SDSADM.UQSTD_PERSONCLASSIEN
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONCLASSNUCCCODE
  UNIQUE (NUCCCODE)
  USING INDEX SDSADM.UQSTD_PERSONCLASSNUCCCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONCLASSVACODE
  UNIQUE (VACODE)
  USING INDEX SDSADM.UQSTD_PERSONCLASSVACODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONCLASSX12CODE
  UNIQUE (X12CODE)
  USING INDEX SDSADM.UQSTD_PERSONCLASSX12CODE
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PERSONCLASS ADD (
  CONSTRAINT FKSTD_PERSONCLASSCLSSFCTN 
  FOREIGN KEY (CLASSIFICATION_ID) 
  REFERENCES SDSADM.STD_PERSONCLASSCLASSIFICATION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FKSTD_PERSONCLASSPROVIDERTYPE 
  FOREIGN KEY (PROVIDERTYPE_ID) 
  REFERENCES SDSADM.STD_PERSONCLASSPROVIDERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONCLASS TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONCLASS TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONCLASS TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONCLASS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONCLASS TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONCLASS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCLASS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONCLASS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONCLASS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONCATEGORYHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONCATEGORYHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONCATEGORYHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONCATEGORYHISTORY ON SDSADM.STD_PERSONCATEGORYHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonCategoryHistory
after DELETE
ON SDSADM.STD_PERSONCATEGORYHISTORY
BEGIN
	-- update the table for STD_PersonCategoryHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonCategoryHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonCategoryHistory
after INSERT
ON SDSADM.STD_PERSONCATEGORYHISTORY
BEGIN
	-- update the table for STD_PersonCategoryHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonCategoryHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonCategoryHistory
after UPDATE
ON SDSADM.STD_PERSONCATEGORYHISTORY
BEGIN
	-- update the table for STD_PersonCategoryHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonCategoryHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONCATEGORYHISTORY FOR SDSADM.STD_PERSONCATEGORYHISTORY;


ALTER TABLE SDSADM.STD_PERSONCATEGORYHISTORY ADD (
  CONSTRAINT PK_STD_PERSONCATEGORYHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONCATEGORYHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PERSONCATEGORYHISTORY ADD (
  CONSTRAINT FKSTD_PERSONCATEGORYHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PERSONCATEGORY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONCATEGORYHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORYHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORYHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORYHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONCATEGORYHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORYHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCATEGORYHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORYHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORYHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERSONCATEGORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERSONCATEGORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERSONCATEGORY
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERSONCATEGORY ON SDSADM.STD_PERSONCATEGORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONCATEGORYCODE ON SDSADM.STD_PERSONCATEGORY
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERSONCATEGORYNAME ON SDSADM.STD_PERSONCATEGORY
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PersonCategory
after DELETE
ON SDSADM.STD_PERSONCATEGORY
BEGIN
	-- update the table for STD_PersonCategory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonCategory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PersonCategory
after INSERT
ON SDSADM.STD_PERSONCATEGORY
BEGIN
	-- update the table for STD_PersonCategory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonCategory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PersonCategory
after UPDATE
ON SDSADM.STD_PERSONCATEGORY
BEGIN
	-- update the table for STD_PersonCategory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PersonCategory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERSONCATEGORY FOR SDSADM.STD_PERSONCATEGORY;


ALTER TABLE SDSADM.STD_PERSONCATEGORY ADD (
  CONSTRAINT PK_STD_PERSONCATEGORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERSONCATEGORY
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONCATEGORYCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PERSONCATEGORYCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERSONCATEGORYNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PERSONCATEGORYNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERSONCATEGORY TO ADR;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERSONCATEGORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERSONCATEGORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERSONCATEGORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERMANENTCODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERMANENTCODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERMANENTCODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERMANENTCODEHISTORY ON SDSADM.STD_PERMANENTCODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PermanentCodeHistory
after DELETE
ON SDSADM.STD_PERMANENTCODEHISTORY
BEGIN
	-- update the table for STD_PermanentCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PermanentCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PermanentCodeHistory
after INSERT
ON SDSADM.STD_PERMANENTCODEHISTORY
BEGIN
	-- update the table for STD_PermanentCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PermanentCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PermanentCodeHistory
after UPDATE
ON SDSADM.STD_PERMANENTCODEHISTORY
BEGIN
	-- update the table for STD_PermanentCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PermanentCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERMANENTCODEHISTORY FOR SDSADM.STD_PERMANENTCODEHISTORY;


ALTER TABLE SDSADM.STD_PERMANENTCODEHISTORY ADD (
  CONSTRAINT PK_STD_PERMANENTCODEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERMANENTCODEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PERMANENTCODEHISTORY ADD (
  CONSTRAINT FKSTD_PERMANENTCODEHISTORYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PERMANENTCODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERMANENTCODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PERMANENTCODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERMANENTCODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PERMANENTCODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERMANENTCODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PERMANENTCODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERMANENTCODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERMANENTCODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERMANENTCODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERMANENTCODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERMANENTCODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERMANENTCODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERMANENTCODE ON SDSADM.STD_PERMANENTCODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERMANENTCODECODE ON SDSADM.STD_PERMANENTCODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERMANENTCODENAME ON SDSADM.STD_PERMANENTCODE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PermanentCode
after DELETE
ON SDSADM.STD_PERMANENTCODE
BEGIN
	-- update the table for STD_PermanentCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PermanentCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PermanentCode
after INSERT
ON SDSADM.STD_PERMANENTCODE
BEGIN
	-- update the table for STD_PermanentCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PermanentCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PermanentCode
after UPDATE
ON SDSADM.STD_PERMANENTCODE
BEGIN
	-- update the table for STD_PermanentCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PermanentCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERMANENTCODE FOR SDSADM.STD_PERMANENTCODE;


ALTER TABLE SDSADM.STD_PERMANENTCODE ADD (
  CONSTRAINT PK_STD_PERMANENTCODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERMANENTCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERMANENTCODECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PERMANENTCODECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERMANENTCODENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PERMANENTCODENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERMANENTCODE TO ADR;

GRANT SELECT ON SDSADM.STD_PERMANENTCODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERMANENTCODE TO EESRV;

GRANT SELECT ON SDSADM.STD_PERMANENTCODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERMANENTCODE TO LOBR;

GRANT SELECT ON SDSADM.STD_PERMANENTCODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERMANENTCODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERMANENTCODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERMANENTCODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERIODOFSERVICEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERIODOFSERVICEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERIODOFSERVICEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERIODOFSERVICEHISTORY ON SDSADM.STD_PERIODOFSERVICEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PeriodOfServiceHstry
after DELETE
ON SDSADM.STD_PERIODOFSERVICEHISTORY
BEGIN
	-- update the table for STD_PeriodOfServiceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PeriodOfServiceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PeriodOfServiceHstry
after INSERT
ON SDSADM.STD_PERIODOFSERVICEHISTORY
BEGIN
	-- update the table for STD_PeriodOfServiceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PeriodOfServiceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PeriodOfServiceHstry
after UPDATE
ON SDSADM.STD_PERIODOFSERVICEHISTORY
BEGIN
	-- update the table for STD_PeriodOfServiceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PeriodOfServiceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERIODOFSERVICEHISTORY FOR SDSADM.STD_PERIODOFSERVICEHISTORY;


ALTER TABLE SDSADM.STD_PERIODOFSERVICEHISTORY ADD (
  CONSTRAINT PK_STD_PERIODOFSERVICEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERIODOFSERVICEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PERIODOFSERVICEHISTORY ADD (
  CONSTRAINT FKSTD_PERIODOFSERVICEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PERIODOFSERVICE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERIODOFSERVICEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERIODOFSERVICEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERIODOFSERVICEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PERIODOFSERVICE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PERIODOFSERVICE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PERIODOFSERVICE
(
  ID                 NUMBER(20)                 NOT NULL,
  CODE               CHAR(1 BYTE)               NOT NULL,
  NAME               VARCHAR2(25 BYTE)          NOT NULL,
  DESCRIPTION        VARCHAR2(26 BYTE),
  ALTERNATENAME      VARCHAR2(9 BYTE),
  BEGINDATE          DATE,
  ENDDATE            DATE,
  WARPEACE           CHAR(1 BYTE),
  LATESTDATEOFBIRTH  CHAR(4 BYTE),
  PTFCODE            CHAR(1 BYTE),
  VERSION            INTEGER                    NOT NULL,
  CREATED            TIMESTAMP(6)               NOT NULL,
  UPDATED            TIMESTAMP(6),
  CREATEDBY          VARCHAR2(32 BYTE)          NOT NULL,
  UPDATEDBY          VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PERIODOFSERVICE ON SDSADM.STD_PERIODOFSERVICE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERIODOFSERVICECODE ON SDSADM.STD_PERIODOFSERVICE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PERIODOFSERVICENAME ON SDSADM.STD_PERIODOFSERVICE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PeriodOfService
after DELETE
ON SDSADM.STD_PERIODOFSERVICE
BEGIN
	-- update the table for STD_PeriodOfService operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PeriodOfService';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PeriodOfService
after INSERT
ON SDSADM.STD_PERIODOFSERVICE
BEGIN
	-- update the table for STD_PeriodOfService operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PeriodOfService';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PeriodOfService
after UPDATE
ON SDSADM.STD_PERIODOFSERVICE
BEGIN
	-- update the table for STD_PeriodOfService operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PeriodOfService';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERIODOFSERVICE FOR SDSADM.STD_PERIODOFSERVICE;


ALTER TABLE SDSADM.STD_PERIODOFSERVICE ADD (
  CONSTRAINT PK_STD_PERIODOFSERVICE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PERIODOFSERVICE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERIODOFSERVICECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PERIODOFSERVICECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERIODOFSERVICENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PERIODOFSERVICENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PERIODOFSERVICE TO ADR;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICE TO EESRV;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PERIODOFSERVICE TO LOBR;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PERIODOFSERVICE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PERIODOFSERVICE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PATIENTTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PATIENTTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PATIENTTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PATIENTTYPEHISTORY ON SDSADM.STD_PATIENTTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PatientTypeHistory
after DELETE
ON SDSADM.STD_PATIENTTYPEHISTORY
BEGIN
	-- update the table for STD_PatientTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PatientTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PatientTypeHistory
after INSERT
ON SDSADM.STD_PATIENTTYPEHISTORY
BEGIN
	-- update the table for STD_PatientTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PatientTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PatientTypeHistory
after UPDATE
ON SDSADM.STD_PATIENTTYPEHISTORY
BEGIN
	-- update the table for STD_PatientTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PatientTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PATIENTTYPEHISTORY FOR SDSADM.STD_PATIENTTYPEHISTORY;


ALTER TABLE SDSADM.STD_PATIENTTYPEHISTORY ADD (
  CONSTRAINT PK_STD_PATIENTTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PATIENTTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_PATIENTTYPEHISTORY ADD (
  CONSTRAINT FKSTD_PATIENTTYPEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_PATIENTTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PATIENTTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_PATIENTTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_PATIENTTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_PATIENTTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PATIENTTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_PATIENTTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PATIENTTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PATIENTTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PATIENTTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_PATIENTTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_PATIENTTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_PATIENTTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_PATIENTTYPE ON SDSADM.STD_PATIENTTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PATIENTTYPECODE ON SDSADM.STD_PATIENTTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_PATIENTTYPENAME ON SDSADM.STD_PATIENTTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_PatientType
after DELETE
ON SDSADM.STD_PATIENTTYPE
BEGIN
	-- update the table for STD_PatientType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PatientType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_PatientType
after INSERT
ON SDSADM.STD_PATIENTTYPE
BEGIN
	-- update the table for STD_PatientType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PatientType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_PatientType
after UPDATE
ON SDSADM.STD_PATIENTTYPE
BEGIN
	-- update the table for STD_PatientType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_PatientType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PATIENTTYPE FOR SDSADM.STD_PATIENTTYPE;


ALTER TABLE SDSADM.STD_PATIENTTYPE ADD (
  CONSTRAINT PK_STD_PATIENTTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_PATIENTTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PATIENTTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_PATIENTTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PATIENTTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_PATIENTTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_PATIENTTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_PATIENTTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_PATIENTTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_PATIENTTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_PATIENTTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_PATIENTTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_PATIENTTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_PATIENTTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_PATIENTTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_OTHERFEDERALAGENCYHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_OTHERFEDERALAGENCYHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_OTHERFEDERALAGENCYHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_OTHERFEDERALAGENCYHSTRY ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_OtherFdrlAgncyHstry
after DELETE
ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY
BEGIN
	-- update the table for STD_OtherFederalAgencyHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OtherFederalAgencyHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_OtherFdrlAgncyHstry
after INSERT
ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY
BEGIN
	-- update the table for STD_OtherFederalAgencyHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OtherFederalAgencyHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_OtherFdrlAgncyHstry
after UPDATE
ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY
BEGIN
	-- update the table for STD_OtherFederalAgencyHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OtherFederalAgencyHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_OTHERFEDERALAGENCYHISTORY FOR SDSADM.STD_OTHERFEDERALAGENCYHISTORY;


ALTER TABLE SDSADM.STD_OTHERFEDERALAGENCYHISTORY ADD (
  CONSTRAINT PK_STD_OTHERFEDERALAGENCYHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_OTHERFEDERALAGENCYHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_OTHERFEDERALAGENCYHISTORY ADD (
  CONSTRAINT FKSTD_OTHERFDRLAGNCYHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_OTHERFEDERALAGENCY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCYHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_OTHERFEDERALAGENCY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_OTHERFEDERALAGENCY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_OTHERFEDERALAGENCY
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_OTHERFEDERALAGENCY ON SDSADM.STD_OTHERFEDERALAGENCY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_OTHERFEDERALAGENCYCODE ON SDSADM.STD_OTHERFEDERALAGENCY
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_OTHERFEDERALAGENCYNAME ON SDSADM.STD_OTHERFEDERALAGENCY
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_OtherFederalAgency
after DELETE
ON SDSADM.STD_OTHERFEDERALAGENCY
BEGIN
	-- update the table for STD_OtherFederalAgency operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OtherFederalAgency';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_OtherFederalAgency
after INSERT
ON SDSADM.STD_OTHERFEDERALAGENCY
BEGIN
	-- update the table for STD_OtherFederalAgency operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OtherFederalAgency';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_OtherFederalAgency
after UPDATE
ON SDSADM.STD_OTHERFEDERALAGENCY
BEGIN
	-- update the table for STD_OtherFederalAgency operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OtherFederalAgency';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_OTHERFEDERALAGENCY FOR SDSADM.STD_OTHERFEDERALAGENCY;


ALTER TABLE SDSADM.STD_OTHERFEDERALAGENCY ADD (
  CONSTRAINT PK_STD_OTHERFEDERALAGENCY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_OTHERFEDERALAGENCY
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_OTHERFEDERALAGENCYCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_OTHERFEDERALAGENCYCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_OTHERFEDERALAGENCYNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_OTHERFEDERALAGENCYNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_OTHERFEDERALAGENCY TO ADR;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCY TO ADREXT;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCY TO EESRV;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_OTHERFEDERALAGENCY TO LOBR;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_OTHERFEDERALAGENCY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_OTHERFEDERALAGENCY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ORGPROVTAXONOMYHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ORGPROVTAXONOMYHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ORGPROVTAXONOMYHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ORGPROVTAXONOMYHISTORY ON SDSADM.STD_ORGPROVTAXONOMYHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ORGPROVTAXONOMYHstry
after DELETE
ON SDSADM.STD_ORGPROVTAXONOMYHISTORY
BEGIN
	-- update the table for STD_ORGPROVTAXONOMYHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ORGPROVTAXONOMYHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ORGPROVTAXONOMYHstry
after INSERT
ON SDSADM.STD_ORGPROVTAXONOMYHISTORY
BEGIN
	-- update the table for STD_ORGPROVTAXONOMYHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ORGPROVTAXONOMYHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ORGPROVTAXONOMYHstry
after UPDATE
ON SDSADM.STD_ORGPROVTAXONOMYHISTORY
BEGIN
	-- update the table for STD_ORGPROVTAXONOMYHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ORGPROVTAXONOMYHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ORGPROVTAXONOMYHISTORY FOR SDSADM.STD_ORGPROVTAXONOMYHISTORY;


ALTER TABLE SDSADM.STD_ORGPROVTAXONOMYHISTORY ADD (
  CONSTRAINT PK_STD_ORGPROVTAXONOMYHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ORGPROVTAXONOMYHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_ORGPROVTAXONOMYHISTORY ADD (
  CONSTRAINT FKSTD_ORGPROVTAXONOMYHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_ORGPROVTAXONOMY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMYHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_ORGPROVTAXONOMY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_ORGPROVTAXONOMY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_ORGPROVTAXONOMY
(
  ID                    NUMBER(20)              NOT NULL,
  NUCCCODE              VARCHAR2(15 BYTE)       NOT NULL,
  PROVIDERTYPE          VARCHAR2(200 BYTE)      NOT NULL,
  CLASSIFICATION        VARCHAR2(200 BYTE),
  AREAOFSPECIALIZATION  VARCHAR2(100 BYTE),
  DESCRIPTION           VARCHAR2(2000 BYTE),
  VERSION               INTEGER                 NOT NULL,
  CREATED               TIMESTAMP(6)            NOT NULL,
  UPDATED               TIMESTAMP(6),
  CREATEDBY             VARCHAR2(32 BYTE)       NOT NULL,
  UPDATEDBY             VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_ORGPROVTAXONOMY ON SDSADM.STD_ORGPROVTAXONOMY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_ORGPROVTAXONOMYNUCCCODE ON SDSADM.STD_ORGPROVTAXONOMY
(NUCCCODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_ORGPROVTAXONOMY
after DELETE
ON SDSADM.STD_ORGPROVTAXONOMY
BEGIN
	-- update the table for STD_ORGPROVTAXONOMY operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ORGPROVTAXONOMY';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_ORGPROVTAXONOMY
after INSERT
ON SDSADM.STD_ORGPROVTAXONOMY
BEGIN
	-- update the table for STD_ORGPROVTAXONOMY operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ORGPROVTAXONOMY';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_ORGPROVTAXONOMY
after UPDATE
ON SDSADM.STD_ORGPROVTAXONOMY
BEGIN
	-- update the table for STD_ORGPROVTAXONOMY operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_ORGPROVTAXONOMY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_ORGPROVTAXONOMY FOR SDSADM.STD_ORGPROVTAXONOMY;


ALTER TABLE SDSADM.STD_ORGPROVTAXONOMY ADD (
  CONSTRAINT PK_STD_ORGPROVTAXONOMY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_ORGPROVTAXONOMY
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_ORGPROVTAXONOMYNUCCCODE
  UNIQUE (NUCCCODE)
  USING INDEX SDSADM.UQSTD_ORGPROVTAXONOMYNUCCCODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_ORGPROVTAXONOMY TO ADR;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMY TO ADREXT;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMY TO EESRV;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_ORGPROVTAXONOMY TO LOBR;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_ORGPROVTAXONOMY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_ORGPROVTAXONOMY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_OEFOIFSOURCEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_OEFOIFSOURCEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_OEFOIFSOURCEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_OEFOIFSOURCEHISTORY ON SDSADM.STD_OEFOIFSOURCEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_OefOifSourceHistory
after DELETE
ON SDSADM.STD_OEFOIFSOURCEHISTORY
BEGIN
	-- update the table for STD_OefOifSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OefOifSourceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_OefOifSourceHistory
after INSERT
ON SDSADM.STD_OEFOIFSOURCEHISTORY
BEGIN
	-- update the table for STD_OefOifSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OefOifSourceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_OefOifSourceHistory
after UPDATE
ON SDSADM.STD_OEFOIFSOURCEHISTORY
BEGIN
	-- update the table for STD_OefOifSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OefOifSourceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_OEFOIFSOURCEHISTORY FOR SDSADM.STD_OEFOIFSOURCEHISTORY;


ALTER TABLE SDSADM.STD_OEFOIFSOURCEHISTORY ADD (
  CONSTRAINT PK_STD_OEFOIFSOURCEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_OEFOIFSOURCEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_OEFOIFSOURCEHISTORY ADD (
  CONSTRAINT FKSTD_OEFOIFSOURCEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_OEFOIFSOURCE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_OEFOIFSOURCEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_OEFOIFSOURCEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_OEFOIFSOURCEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_OEFOIFSOURCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_OEFOIFSOURCE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_OEFOIFSOURCE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(4 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_OEFOIFSOURCE ON SDSADM.STD_OEFOIFSOURCE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_OEFOIFSOURCECODE ON SDSADM.STD_OEFOIFSOURCE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_OEFOIFSOURCENAME ON SDSADM.STD_OEFOIFSOURCE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_OefOifSource
after DELETE
ON SDSADM.STD_OEFOIFSOURCE
BEGIN
	-- update the table for STD_OefOifSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OefOifSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_OefOifSource
after INSERT
ON SDSADM.STD_OEFOIFSOURCE
BEGIN
	-- update the table for STD_OefOifSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OefOifSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_OefOifSource
after UPDATE
ON SDSADM.STD_OEFOIFSOURCE
BEGIN
	-- update the table for STD_OefOifSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_OefOifSource';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_OEFOIFSOURCE FOR SDSADM.STD_OEFOIFSOURCE;


ALTER TABLE SDSADM.STD_OEFOIFSOURCE ADD (
  CONSTRAINT PK_STD_OEFOIFSOURCE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_OEFOIFSOURCE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_OEFOIFSOURCECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_OEFOIFSOURCECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_OEFOIFSOURCENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_OEFOIFSOURCENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_OEFOIFSOURCE TO ADR;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCE TO ADREXT;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCE TO EESRV;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_OEFOIFSOURCE TO LOBR;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_OEFOIFSOURCE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_OEFOIFSOURCE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NTRVERIFICATNMTHDHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NTRVERIFICATNMTHDHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NTRVERIFICATNMTHDHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NTRVERIFICATNMTHDHSTRY ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NTRVrfctnMthdHstry
after DELETE
ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY
BEGIN
	-- update the table for STD_NTRVerificatnMthdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRVerificatnMthdHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NTRVrfctnMthdHstry
after INSERT
ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY
BEGIN
	-- update the table for STD_NTRVerificatnMthdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRVerificatnMthdHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NTRVrfctnMthdHstry
after UPDATE
ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY
BEGIN
	-- update the table for STD_NTRVerificatnMthdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRVerificatnMthdHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NTRVERIFICATNMTHDHISTORY FOR SDSADM.STD_NTRVERIFICATNMTHDHISTORY;


ALTER TABLE SDSADM.STD_NTRVERIFICATNMTHDHISTORY ADD (
  CONSTRAINT PK_STD_NTRVERIFICATNMTHDHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NTRVERIFICATNMTHDHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_NTRVERIFICATNMTHDHISTORY ADD (
  CONSTRAINT FKSTD_NTRVRFCTNMTHDHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_NTRVERIFICATIONMETHOD (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATNMTHDHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NTRVERIFICATIONMETHOD
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NTRVERIFICATIONMETHOD CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NTRVERIFICATIONMETHOD
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(1 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NTRVERIFICATNMTHD ON SDSADM.STD_NTRVERIFICATIONMETHOD
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NTRVERIFICATNMTHDCODE ON SDSADM.STD_NTRVERIFICATIONMETHOD
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NTRVERIFICATNMTHDNAME ON SDSADM.STD_NTRVERIFICATIONMETHOD
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NTRVerificatnMthd
after DELETE
ON SDSADM.STD_NTRVERIFICATIONMETHOD
BEGIN
	-- update the table for STD_NTRVerificationMethod operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRVerificationMethod';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NTRVerificatnMthd
after INSERT
ON SDSADM.STD_NTRVERIFICATIONMETHOD
BEGIN
	-- update the table for STD_NTRVerificationMethod operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRVerificationMethod';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NTRVerificatnMthd
after UPDATE
ON SDSADM.STD_NTRVERIFICATIONMETHOD
BEGIN
	-- update the table for STD_NTRVerificationMethod operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRVerificationMethod';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NTRVERIFICATIONMETHOD FOR SDSADM.STD_NTRVERIFICATIONMETHOD;


ALTER TABLE SDSADM.STD_NTRVERIFICATIONMETHOD ADD (
  CONSTRAINT PK_STD_NTRVERIFICATNMTHD
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NTRVERIFICATNMTHD
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NTRVERIFICATNMTHDCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_NTRVERIFICATNMTHDCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NTRVERIFICATNMTHDNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_NTRVERIFICATNMTHDNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NTRVERIFICATIONMETHOD TO ADR;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATIONMETHOD TO ADREXT;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATIONMETHOD TO EESRV;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATIONMETHOD TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NTRVERIFICATIONMETHOD TO LOBR;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATIONMETHOD TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NTRVERIFICATIONMETHOD TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATIONMETHOD TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NTRVERIFICATIONMETHOD TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NTRQUALIFIERHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NTRQUALIFIERHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NTRQUALIFIERHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NTRQUALIFIERHISTORY ON SDSADM.STD_NTRQUALIFIERHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NTRQualifierHistory
after DELETE
ON SDSADM.STD_NTRQUALIFIERHISTORY
BEGIN
	-- update the table for STD_NTRQualifierHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRQualifierHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NTRQualifierHistory
after INSERT
ON SDSADM.STD_NTRQUALIFIERHISTORY
BEGIN
	-- update the table for STD_NTRQualifierHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRQualifierHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NTRQualifierHistory
after UPDATE
ON SDSADM.STD_NTRQUALIFIERHISTORY
BEGIN
	-- update the table for STD_NTRQualifierHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRQualifierHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NTRQUALIFIERHISTORY FOR SDSADM.STD_NTRQUALIFIERHISTORY;


ALTER TABLE SDSADM.STD_NTRQUALIFIERHISTORY ADD (
  CONSTRAINT PK_STD_NTRQUALIFIERHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NTRQUALIFIERHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_NTRQUALIFIERHISTORY ADD (
  CONSTRAINT FKSTD_NTRQUALIFIERHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_NTRQUALIFIER (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NTRQUALIFIERHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIERHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIERHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIERHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NTRQUALIFIERHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIERHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NTRQUALIFIERHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIERHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIERHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NTRQUALIFIER
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NTRQUALIFIER CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NTRQUALIFIER
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NTRQUALIFIER ON SDSADM.STD_NTRQUALIFIER
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NTRQUALIFIERCODE ON SDSADM.STD_NTRQUALIFIER
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NTRQUALIFIERNAME ON SDSADM.STD_NTRQUALIFIER
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NTRQualifier
after DELETE
ON SDSADM.STD_NTRQUALIFIER
BEGIN
	-- update the table for STD_NTRQualifier operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRQualifier';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NTRQualifier
after INSERT
ON SDSADM.STD_NTRQUALIFIER
BEGIN
	-- update the table for STD_NTRQualifier operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRQualifier';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NTRQualifier
after UPDATE
ON SDSADM.STD_NTRQUALIFIER
BEGIN
	-- update the table for STD_NTRQualifier operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NTRQualifier';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NTRQUALIFIER FOR SDSADM.STD_NTRQUALIFIER;


ALTER TABLE SDSADM.STD_NTRQUALIFIER ADD (
  CONSTRAINT PK_STD_NTRQUALIFIER
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NTRQUALIFIER
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NTRQUALIFIERCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_NTRQUALIFIERCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NTRQUALIFIERNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_NTRQUALIFIERNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NTRQUALIFIER TO ADR;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIER TO ADREXT;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIER TO EESRV;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIER TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NTRQUALIFIER TO LOBR;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIER TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NTRQUALIFIER TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIER TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NTRQUALIFIER TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NPPESORGALTRSNHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NPPESORGALTRSNHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NPPESORGALTRSNHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NPPESORGALTRSNHISTORY ON SDSADM.STD_NPPESORGALTRSNHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NPPESOrgAltRsnHistory
after DELETE
ON SDSADM.STD_NPPESORGALTRSNHISTORY
BEGIN
	-- update the table for STD_NPPESOrgAltRsnHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltRsnHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NPPESOrgAltRsnHistory
after INSERT
ON SDSADM.STD_NPPESORGALTRSNHISTORY
BEGIN
	-- update the table for STD_NPPESOrgAltRsnHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltRsnHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NPPESOrgAltRsnHistory
after UPDATE
ON SDSADM.STD_NPPESORGALTRSNHISTORY
BEGIN
	-- update the table for STD_NPPESOrgAltRsnHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltRsnHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NPPESORGALTRSNHISTORY FOR SDSADM.STD_NPPESORGALTRSNHISTORY;


ALTER TABLE SDSADM.STD_NPPESORGALTRSNHISTORY ADD (
  CONSTRAINT PK_STD_NPPESORGALTRSNHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NPPESORGALTRSNHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_NPPESORGALTRSNHISTORY ADD (
  CONSTRAINT FKSTD_NPPESORGALTRSNHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_NPPESORGALTRSN (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NPPESORGALTRSNHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSNHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSNHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSNHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NPPESORGALTRSNHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSNHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALTRSNHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSNHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSNHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NPPESORGALTRSN
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NPPESORGALTRSN CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NPPESORGALTRSN
(
  ID                NUMBER(20)                  NOT NULL,
  REASONCODE        NUMBER(10)                  NOT NULL,
  SHORTDESCRIPTION  VARCHAR2(30 BYTE),
  LONGDESCRIPTION   VARCHAR2(60 BYTE),
  VERSION           INTEGER                     NOT NULL,
  CREATED           TIMESTAMP(6)                NOT NULL,
  UPDATED           TIMESTAMP(6),
  CREATEDBY         VARCHAR2(32 BYTE)           NOT NULL,
  UPDATEDBY         VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NPPESORGALTRSN ON SDSADM.STD_NPPESORGALTRSN
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NPPESORGALTRSNREASONCODE ON SDSADM.STD_NPPESORGALTRSN
(REASONCODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NPPESOrgAltRsn
after DELETE
ON SDSADM.STD_NPPESORGALTRSN
BEGIN
	-- update the table for STD_NPPESOrgAltRsn operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltRsn';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NPPESOrgAltRsn
after INSERT
ON SDSADM.STD_NPPESORGALTRSN
BEGIN
	-- update the table for STD_NPPESOrgAltRsn operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltRsn';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NPPESOrgAltRsn
after UPDATE
ON SDSADM.STD_NPPESORGALTRSN
BEGIN
	-- update the table for STD_NPPESOrgAltRsn operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltRsn';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NPPESORGALTRSN FOR SDSADM.STD_NPPESORGALTRSN;


ALTER TABLE SDSADM.STD_NPPESORGALTRSN ADD (
  CONSTRAINT PK_STD_NPPESORGALTRSN
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NPPESORGALTRSN
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NPPESORGALTRSNREASONCODE
  UNIQUE (REASONCODE)
  USING INDEX SDSADM.UQSTD_NPPESORGALTRSNREASONCODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NPPESORGALTRSN TO ADR;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSN TO ADREXT;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSN TO EESRV;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSN TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NPPESORGALTRSN TO LOBR;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSN TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALTRSN TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSN TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NPPESORGALTRSN TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NPPESORGALTIDHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NPPESORGALTIDHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NPPESORGALTIDHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NPPESORGALTIDHISTORY ON SDSADM.STD_NPPESORGALTIDHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NPPESOrgAltIdHistory
after DELETE
ON SDSADM.STD_NPPESORGALTIDHISTORY
BEGIN
	-- update the table for STD_NPPESOrgAltIdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltIdHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NPPESOrgAltIdHistory
after INSERT
ON SDSADM.STD_NPPESORGALTIDHISTORY
BEGIN
	-- update the table for STD_NPPESOrgAltIdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltIdHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NPPESOrgAltIdHistory
after UPDATE
ON SDSADM.STD_NPPESORGALTIDHISTORY
BEGIN
	-- update the table for STD_NPPESOrgAltIdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltIdHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NPPESORGALTIDHISTORY FOR SDSADM.STD_NPPESORGALTIDHISTORY;


ALTER TABLE SDSADM.STD_NPPESORGALTIDHISTORY ADD (
  CONSTRAINT PK_STD_NPPESORGALTIDHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NPPESORGALTIDHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_NPPESORGALTIDHISTORY ADD (
  CONSTRAINT FKSTD_NPPESORGALTIDHISTORYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_NPPESORGALTID (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NPPESORGALTIDHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_NPPESORGALTIDHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_NPPESORGALTIDHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_NPPESORGALTIDHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NPPESORGALTIDHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_NPPESORGALTIDHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALTIDHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NPPESORGALTIDHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NPPESORGALTIDHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NPPESORGALTID
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NPPESORGALTID CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NPPESORGALTID
(
  ID                NUMBER(20)                  NOT NULL,
  TYPECODE          NUMBER(10)                  NOT NULL,
  SHORTDESCRIPTION  VARCHAR2(30 BYTE),
  LONGDESCRIPTION   VARCHAR2(60 BYTE),
  VERSION           INTEGER                     NOT NULL,
  CREATED           TIMESTAMP(6)                NOT NULL,
  UPDATED           TIMESTAMP(6),
  CREATEDBY         VARCHAR2(32 BYTE)           NOT NULL,
  UPDATEDBY         VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NPPESORGALTID ON SDSADM.STD_NPPESORGALTID
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NPPESORGALTIDTYPECODE ON SDSADM.STD_NPPESORGALTID
(TYPECODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NPPESOrgAltId
after DELETE
ON SDSADM.STD_NPPESORGALTID
BEGIN
	-- update the table for STD_NPPESOrgAltId operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltId';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NPPESOrgAltId
after INSERT
ON SDSADM.STD_NPPESORGALTID
BEGIN
	-- update the table for STD_NPPESOrgAltId operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltId';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NPPESOrgAltId
after UPDATE
ON SDSADM.STD_NPPESORGALTID
BEGIN
	-- update the table for STD_NPPESOrgAltId operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAltId';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NPPESORGALTID FOR SDSADM.STD_NPPESORGALTID;


ALTER TABLE SDSADM.STD_NPPESORGALTID ADD (
  CONSTRAINT PK_STD_NPPESORGALTID
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NPPESORGALTID
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NPPESORGALTIDTYPECODE
  UNIQUE (TYPECODE)
  USING INDEX SDSADM.UQSTD_NPPESORGALTIDTYPECODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NPPESORGALTID TO ADR;

GRANT SELECT ON SDSADM.STD_NPPESORGALTID TO ADREXT;

GRANT SELECT ON SDSADM.STD_NPPESORGALTID TO EESRV;

GRANT SELECT ON SDSADM.STD_NPPESORGALTID TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NPPESORGALTID TO LOBR;

GRANT SELECT ON SDSADM.STD_NPPESORGALTID TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALTID TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NPPESORGALTID TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NPPESORGALTID TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NPPESORGALIASTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NPPESORGALIASTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NPPESORGALIASTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NPPESORGALIASTYPEHSTRY ON SDSADM.STD_NPPESORGALIASTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NPPESOrgAliasTypHstry
after DELETE
ON SDSADM.STD_NPPESORGALIASTYPEHISTORY
BEGIN
	-- update the table for STD_NPPESOrgAliasTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAliasTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NPPESOrgAliasTypHstry
after INSERT
ON SDSADM.STD_NPPESORGALIASTYPEHISTORY
BEGIN
	-- update the table for STD_NPPESOrgAliasTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAliasTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NPPESOrgAliasTypHstry
after UPDATE
ON SDSADM.STD_NPPESORGALIASTYPEHISTORY
BEGIN
	-- update the table for STD_NPPESOrgAliasTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAliasTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NPPESORGALIASTYPEHISTORY FOR SDSADM.STD_NPPESORGALIASTYPEHISTORY;


ALTER TABLE SDSADM.STD_NPPESORGALIASTYPEHISTORY ADD (
  CONSTRAINT PK_STD_NPPESORGALIASTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NPPESORGALIASTYPEHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_NPPESORGALIASTYPEHISTORY ADD (
  CONSTRAINT FKSTD_NPPESORGALSTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_NPPESORGALIASTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NPPESORGALIASTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NPPESORGALIASTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NPPESORGALIASTYPE
(
  ID                NUMBER(20)                  NOT NULL,
  ALIASTYPECODE     NUMBER(10)                  NOT NULL,
  SHORTDESCRIPTION  VARCHAR2(30 BYTE),
  LONGDESCRIPTION   VARCHAR2(60 BYTE),
  VERSION           INTEGER                     NOT NULL,
  CREATED           TIMESTAMP(6)                NOT NULL,
  UPDATED           TIMESTAMP(6),
  CREATEDBY         VARCHAR2(32 BYTE)           NOT NULL,
  UPDATEDBY         VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NPPESORGALIASTYPE ON SDSADM.STD_NPPESORGALIASTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NPPESORGALIASTYPALSTYPCD ON SDSADM.STD_NPPESORGALIASTYPE
(ALIASTYPECODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NPPESOrgAliasType
after DELETE
ON SDSADM.STD_NPPESORGALIASTYPE
BEGIN
	-- update the table for STD_NPPESOrgAliasType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAliasType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NPPESOrgAliasType
after INSERT
ON SDSADM.STD_NPPESORGALIASTYPE
BEGIN
	-- update the table for STD_NPPESOrgAliasType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAliasType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NPPESOrgAliasType
after UPDATE
ON SDSADM.STD_NPPESORGALIASTYPE
BEGIN
	-- update the table for STD_NPPESOrgAliasType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NPPESOrgAliasType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NPPESORGALIASTYPE FOR SDSADM.STD_NPPESORGALIASTYPE;


ALTER TABLE SDSADM.STD_NPPESORGALIASTYPE ADD (
  CONSTRAINT PK_STD_NPPESORGALIASTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NPPESORGALIASTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NPPESORGALIASTYPALSTYPCD
  UNIQUE (ALIASTYPECODE)
  USING INDEX SDSADM.UQSTD_NPPESORGALIASTYPALSTYPCD
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NPPESORGALIASTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NPPESORGALIASTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NPPESORGALIASTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NPPESORGALIASTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NOSITEUPLOADREASONHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NOSITEUPLOADREASONHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NOSITEUPLOADREASONHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NOSITEUPLOADREASONHSTRY ON SDSADM.STD_NOSITEUPLOADREASONHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NoSiteUploadRsnHstry
after DELETE
ON SDSADM.STD_NOSITEUPLOADREASONHISTORY
BEGIN
	-- update the table for STD_NoSiteUploadReasonHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NoSiteUploadReasonHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NoSiteUploadRsnHstry
after INSERT
ON SDSADM.STD_NOSITEUPLOADREASONHISTORY
BEGIN
	-- update the table for STD_NoSiteUploadReasonHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NoSiteUploadReasonHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NoSiteUploadRsnHstry
after UPDATE
ON SDSADM.STD_NOSITEUPLOADREASONHISTORY
BEGIN
	-- update the table for STD_NoSiteUploadReasonHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NoSiteUploadReasonHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NOSITEUPLOADREASONHISTORY FOR SDSADM.STD_NOSITEUPLOADREASONHISTORY;


ALTER TABLE SDSADM.STD_NOSITEUPLOADREASONHISTORY ADD (
  CONSTRAINT PK_STD_NOSITEUPLOADREASONHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NOSITEUPLOADREASONHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_NOSITEUPLOADREASONHISTORY ADD (
  CONSTRAINT FKSTD_NOSITEUPLOADRSNHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_NOSITEUPLOADREASON (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASONHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NOSITEUPLOADREASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NOSITEUPLOADREASON CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NOSITEUPLOADREASON
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NOSITEUPLOADREASON ON SDSADM.STD_NOSITEUPLOADREASON
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NOSITEUPLOADREASONCODE ON SDSADM.STD_NOSITEUPLOADREASON
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NOSITEUPLOADREASONNAME ON SDSADM.STD_NOSITEUPLOADREASON
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NoSiteUploadReason
after DELETE
ON SDSADM.STD_NOSITEUPLOADREASON
BEGIN
	-- update the table for STD_NoSiteUploadReason operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NoSiteUploadReason';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NoSiteUploadReason
after INSERT
ON SDSADM.STD_NOSITEUPLOADREASON
BEGIN
	-- update the table for STD_NoSiteUploadReason operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NoSiteUploadReason';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NoSiteUploadReason
after UPDATE
ON SDSADM.STD_NOSITEUPLOADREASON
BEGIN
	-- update the table for STD_NoSiteUploadReason operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NoSiteUploadReason';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NOSITEUPLOADREASON FOR SDSADM.STD_NOSITEUPLOADREASON;


ALTER TABLE SDSADM.STD_NOSITEUPLOADREASON ADD (
  CONSTRAINT PK_STD_NOSITEUPLOADREASON
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NOSITEUPLOADREASON
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NOSITEUPLOADREASONCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_NOSITEUPLOADREASONCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NOSITEUPLOADREASONNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_NOSITEUPLOADREASONNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NOSITEUPLOADREASON TO ADR;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASON TO ADREXT;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASON TO EESRV;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASON TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NOSITEUPLOADREASON TO LOBR;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASON TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NOSITEUPLOADREASON TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASON TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NOSITEUPLOADREASON TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NAMETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NAMETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NAMETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NAMETYPEHISTORY ON SDSADM.STD_NAMETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NameTypeHistory
after DELETE
ON SDSADM.STD_NAMETYPEHISTORY
BEGIN
	-- update the table for STD_NameTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NameTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NameTypeHistory
after INSERT
ON SDSADM.STD_NAMETYPEHISTORY
BEGIN
	-- update the table for STD_NameTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NameTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NameTypeHistory
after UPDATE
ON SDSADM.STD_NAMETYPEHISTORY
BEGIN
	-- update the table for STD_NameTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NameTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NAMETYPEHISTORY FOR SDSADM.STD_NAMETYPEHISTORY;


ALTER TABLE SDSADM.STD_NAMETYPEHISTORY ADD (
  CONSTRAINT PK_STD_NAMETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NAMETYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_NAMETYPEHISTORY ADD (
  CONSTRAINT FKSTD_NAMETYPEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_NAMETYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NAMETYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_NAMETYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_NAMETYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_NAMETYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NAMETYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_NAMETYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NAMETYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NAMETYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NAMETYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NAMETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NAMETYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NAMETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(32 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NAMETYPE ON SDSADM.STD_NAMETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NAMETYPECODE ON SDSADM.STD_NAMETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NAMETYPENAME ON SDSADM.STD_NAMETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NameType
after DELETE
ON SDSADM.STD_NAMETYPE
BEGIN
	-- update the table for STD_NameType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NameType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NameType
after INSERT
ON SDSADM.STD_NAMETYPE
BEGIN
	-- update the table for STD_NameType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NameType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NameType
after UPDATE
ON SDSADM.STD_NAMETYPE
BEGIN
	-- update the table for STD_NameType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NameType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NAMETYPE FOR SDSADM.STD_NAMETYPE;


ALTER TABLE SDSADM.STD_NAMETYPE ADD (
  CONSTRAINT PK_STD_NAMETYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NAMETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NAMETYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_NAMETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NAMETYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_NAMETYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NAMETYPE TO ADR;

GRANT SELECT ON SDSADM.STD_NAMETYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_NAMETYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_NAMETYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NAMETYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_NAMETYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NAMETYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NAMETYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NAMETYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NAMEDCONTINGENCYHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NAMEDCONTINGENCYHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NAMEDCONTINGENCYHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NAMEDCONTINGENCYHISTORY ON SDSADM.STD_NAMEDCONTINGENCYHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NamedContingencyHstry
after DELETE
ON SDSADM.STD_NAMEDCONTINGENCYHISTORY
BEGIN
	-- update the table for STD_NamedContingencyHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NamedContingencyHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NamedContingencyHstry
after INSERT
ON SDSADM.STD_NAMEDCONTINGENCYHISTORY
BEGIN
	-- update the table for STD_NamedContingencyHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NamedContingencyHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NamedContingencyHstry
after UPDATE
ON SDSADM.STD_NAMEDCONTINGENCYHISTORY
BEGIN
	-- update the table for STD_NamedContingencyHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NamedContingencyHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NAMEDCONTINGENCYHISTORY FOR SDSADM.STD_NAMEDCONTINGENCYHISTORY;


ALTER TABLE SDSADM.STD_NAMEDCONTINGENCYHISTORY ADD (
  CONSTRAINT PK_STD_NAMEDCONTINGENCYHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NAMEDCONTINGENCYHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_NAMEDCONTINGENCYHISTORY ADD (
  CONSTRAINT FKSTD_NAMEDCNTNGNCYHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_NAMEDCONTINGENCY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCYHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_NAMEDCONTINGENCY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_NAMEDCONTINGENCY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_NAMEDCONTINGENCY
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(8 BYTE)                 NOT NULL,
  NAME         VARCHAR2(120 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_NAMEDCONTINGENCY ON SDSADM.STD_NAMEDCONTINGENCY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NAMEDCONTINGENCYCODE ON SDSADM.STD_NAMEDCONTINGENCY
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_NAMEDCONTINGENCYNAME ON SDSADM.STD_NAMEDCONTINGENCY
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_NamedContingency
after DELETE
ON SDSADM.STD_NAMEDCONTINGENCY
BEGIN
	-- update the table for STD_NamedContingency operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NamedContingency';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_NamedContingency
after INSERT
ON SDSADM.STD_NAMEDCONTINGENCY
BEGIN
	-- update the table for STD_NamedContingency operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NamedContingency';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_NamedContingency
after UPDATE
ON SDSADM.STD_NAMEDCONTINGENCY
BEGIN
	-- update the table for STD_NamedContingency operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_NamedContingency';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NAMEDCONTINGENCY FOR SDSADM.STD_NAMEDCONTINGENCY;


ALTER TABLE SDSADM.STD_NAMEDCONTINGENCY ADD (
  CONSTRAINT PK_STD_NAMEDCONTINGENCY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_NAMEDCONTINGENCY
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NAMEDCONTINGENCYCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_NAMEDCONTINGENCYCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NAMEDCONTINGENCYNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_NAMEDCONTINGENCYNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_NAMEDCONTINGENCY TO ADR;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCY TO ADREXT;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCY TO EESRV;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_NAMEDCONTINGENCY TO LOBR;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_NAMEDCONTINGENCY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_NAMEDCONTINGENCY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MTNOTREQRSNTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MTNOTREQRSNTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MTNOTREQRSNTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MTNOTREQRSNTYPEHISTORY ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MTNotReqRsnTypeHstry
after DELETE
ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY
BEGIN
	-- update the table for STD_MTNotReqRsnTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MTNotReqRsnTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MTNotReqRsnTypeHstry
after INSERT
ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY
BEGIN
	-- update the table for STD_MTNotReqRsnTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MTNotReqRsnTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MTNotReqRsnTypeHstry
after UPDATE
ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY
BEGIN
	-- update the table for STD_MTNotReqRsnTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MTNotReqRsnTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MTNOTREQRSNTYPEHISTORY FOR SDSADM.STD_MTNOTREQRSNTYPEHISTORY;


ALTER TABLE SDSADM.STD_MTNOTREQRSNTYPEHISTORY ADD (
  CONSTRAINT PK_STD_MTNOTREQRSNTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MTNOTREQRSNTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MTNOTREQRSNTYPEHISTORY ADD (
  CONSTRAINT FKSTD_MTNOTREQRSNTYPEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MTNOTREQRSNTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MTNOTREQRSNTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MTNOTREQRSNTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MTNOTREQRSNTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(60 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MTNOTREQRSNTYPE ON SDSADM.STD_MTNOTREQRSNTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MTNOTREQRSNTYPECODE ON SDSADM.STD_MTNOTREQRSNTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MTNOTREQRSNTYPENAME ON SDSADM.STD_MTNOTREQRSNTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MTNotReqRsnType
after DELETE
ON SDSADM.STD_MTNOTREQRSNTYPE
BEGIN
	-- update the table for STD_MTNotReqRsnType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MTNotReqRsnType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MTNotReqRsnType
after INSERT
ON SDSADM.STD_MTNOTREQRSNTYPE
BEGIN
	-- update the table for STD_MTNotReqRsnType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MTNotReqRsnType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MTNotReqRsnType
after UPDATE
ON SDSADM.STD_MTNOTREQRSNTYPE
BEGIN
	-- update the table for STD_MTNotReqRsnType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MTNotReqRsnType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MTNOTREQRSNTYPE FOR SDSADM.STD_MTNOTREQRSNTYPE;


ALTER TABLE SDSADM.STD_MTNOTREQRSNTYPE ADD (
  CONSTRAINT PK_STD_MTNOTREQRSNTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MTNOTREQRSNTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MTNOTREQRSNTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MTNOTREQRSNTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MTNOTREQRSNTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MTNOTREQRSNTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MTNOTREQRSNTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MTNOTREQRSNTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MTNOTREQRSNTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MTNOTREQRSNTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MSTSTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MSTSTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MSTSTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MSTSTATUSHISTORY ON SDSADM.STD_MSTSTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MSTStatusHistory
after DELETE
ON SDSADM.STD_MSTSTATUSHISTORY
BEGIN
	-- update the table for STD_MSTStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSTStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MSTStatusHistory
after INSERT
ON SDSADM.STD_MSTSTATUSHISTORY
BEGIN
	-- update the table for STD_MSTStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSTStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MSTStatusHistory
after UPDATE
ON SDSADM.STD_MSTSTATUSHISTORY
BEGIN
	-- update the table for STD_MSTStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSTStatusHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MSTSTATUSHISTORY FOR SDSADM.STD_MSTSTATUSHISTORY;


ALTER TABLE SDSADM.STD_MSTSTATUSHISTORY ADD (
  CONSTRAINT PK_STD_MSTSTATUSHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MSTSTATUSHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MSTSTATUSHISTORY ADD (
  CONSTRAINT FKSTD_MSTSTATUSHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MSTSTATUS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MSTSTATUSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MSTSTATUSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MSTSTATUSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MSTSTATUSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MSTSTATUSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MSTSTATUSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MSTSTATUSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MSTSTATUSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MSTSTATUSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MSTSTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MSTSTATUS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MSTSTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(1 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MSTSTATUS ON SDSADM.STD_MSTSTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MSTSTATUSCODE ON SDSADM.STD_MSTSTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MSTSTATUSNAME ON SDSADM.STD_MSTSTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MSTStatus
after DELETE
ON SDSADM.STD_MSTSTATUS
BEGIN
	-- update the table for STD_MSTStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSTStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MSTStatus
after INSERT
ON SDSADM.STD_MSTSTATUS
BEGIN
	-- update the table for STD_MSTStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSTStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MSTStatus
after UPDATE
ON SDSADM.STD_MSTSTATUS
BEGIN
	-- update the table for STD_MSTStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSTStatus';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MSTSTATUS FOR SDSADM.STD_MSTSTATUS;


ALTER TABLE SDSADM.STD_MSTSTATUS ADD (
  CONSTRAINT PK_STD_MSTSTATUS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MSTSTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MSTSTATUSCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MSTSTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MSTSTATUSNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MSTSTATUSNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MSTSTATUS TO ADR;

GRANT SELECT ON SDSADM.STD_MSTSTATUS TO ADREXT;

GRANT SELECT ON SDSADM.STD_MSTSTATUS TO EESRV;

GRANT SELECT ON SDSADM.STD_MSTSTATUS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MSTSTATUS TO LOBR;

GRANT SELECT ON SDSADM.STD_MSTSTATUS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MSTSTATUS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MSTSTATUS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MSTSTATUS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MSDSCOUNTRYHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MSDSCOUNTRYHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MSDSCOUNTRYHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MSDSCOUNTRYHISTORY ON SDSADM.STD_MSDSCOUNTRYHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MSDSCountryHistory
after DELETE
ON SDSADM.STD_MSDSCOUNTRYHISTORY
BEGIN
	-- update the table for STD_MSDSCountryHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSDSCountryHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MSDSCountryHistory
after INSERT
ON SDSADM.STD_MSDSCOUNTRYHISTORY
BEGIN
	-- update the table for STD_MSDSCountryHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSDSCountryHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MSDSCountryHistory
after UPDATE
ON SDSADM.STD_MSDSCOUNTRYHISTORY
BEGIN
	-- update the table for STD_MSDSCountryHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSDSCountryHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MSDSCOUNTRYHISTORY FOR SDSADM.STD_MSDSCOUNTRYHISTORY;


ALTER TABLE SDSADM.STD_MSDSCOUNTRYHISTORY ADD (
  CONSTRAINT PK_STD_MSDSCOUNTRYHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MSDSCOUNTRYHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MSDSCOUNTRYHISTORY ADD (
  CONSTRAINT FKSTD_MSDSCOUNTRYHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MSDSCOUNTRY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MSDSCOUNTRYHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRYHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRYHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRYHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MSDSCOUNTRYHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRYHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MSDSCOUNTRYHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRYHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRYHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MSDSCOUNTRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MSDSCOUNTRY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MSDSCOUNTRY
(
  ID            NUMBER(20)                      NOT NULL,
  CODE          VARCHAR2(2 BYTE)                NOT NULL,
  COUNTRY_NAME  VARCHAR2(55 BYTE)               NOT NULL,
  DESCRIPTION   VARCHAR2(200 BYTE),
  ISACTIVE      NUMBER(10)                      NOT NULL,
  VERSION       INTEGER                         NOT NULL,
  CREATED       TIMESTAMP(6)                    NOT NULL,
  UPDATED       TIMESTAMP(6),
  CREATEDBY     VARCHAR2(32 BYTE)               NOT NULL,
  UPDATEDBY     VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MSDSCOUNTRY ON SDSADM.STD_MSDSCOUNTRY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MSDSCOUNTRYCODE ON SDSADM.STD_MSDSCOUNTRY
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MSDSCountry
after DELETE
ON SDSADM.STD_MSDSCOUNTRY
BEGIN
	-- update the table for STD_MSDSCountry operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSDSCountry';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MSDSCountry
after INSERT
ON SDSADM.STD_MSDSCOUNTRY
BEGIN
	-- update the table for STD_MSDSCountry operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSDSCountry';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MSDSCountry
after UPDATE
ON SDSADM.STD_MSDSCOUNTRY
BEGIN
	-- update the table for STD_MSDSCountry operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MSDSCountry';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MSDSCOUNTRY FOR SDSADM.STD_MSDSCOUNTRY;


ALTER TABLE SDSADM.STD_MSDSCOUNTRY ADD (
  CONSTRAINT PK_STD_MSDSCOUNTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MSDSCOUNTRY
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MSDSCOUNTRYCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MSDSCOUNTRYCODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MSDSCOUNTRY TO ADR;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRY TO EESRV;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MSDSCOUNTRY TO LOBR;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MSDSCOUNTRY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MSDSCOUNTRY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MONETARYBENEFITTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MONETARYBENEFITTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MONETARYBENEFITTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MONETARYBENEFITTYPHSTRY ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MonetaryBnftTypHstry
after DELETE
ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY
BEGIN
	-- update the table for STD_MonetaryBenefitTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MonetaryBenefitTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MonetaryBnftTypHstry
after INSERT
ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY
BEGIN
	-- update the table for STD_MonetaryBenefitTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MonetaryBenefitTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MonetaryBnftTypHstry
after UPDATE
ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY
BEGIN
	-- update the table for STD_MonetaryBenefitTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MonetaryBenefitTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MONETARYBENEFITTYPEHISTORY FOR SDSADM.STD_MONETARYBENEFITTYPEHISTORY;


ALTER TABLE SDSADM.STD_MONETARYBENEFITTYPEHISTORY ADD (
  CONSTRAINT PK_STD_MONETARYBENEFITTYPHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MONETARYBENEFITTYPHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MONETARYBENEFITTYPEHISTORY ADD (
  CONSTRAINT FKSTD_MONETARYBNFTTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MONETARYBENEFITTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MONETARYBENEFITTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MONETARYBENEFITTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MONETARYBENEFITTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(2 BYTE)                     NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MONETARYBENEFITTYPE ON SDSADM.STD_MONETARYBENEFITTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MONETARYBENEFITTYPECODE ON SDSADM.STD_MONETARYBENEFITTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MONETARYBENEFITTYPENAME ON SDSADM.STD_MONETARYBENEFITTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MonetaryBenefitType
after DELETE
ON SDSADM.STD_MONETARYBENEFITTYPE
BEGIN
	-- update the table for STD_MonetaryBenefitType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MonetaryBenefitType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MonetaryBenefitType
after INSERT
ON SDSADM.STD_MONETARYBENEFITTYPE
BEGIN
	-- update the table for STD_MonetaryBenefitType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MonetaryBenefitType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MonetaryBenefitType
after UPDATE
ON SDSADM.STD_MONETARYBENEFITTYPE
BEGIN
	-- update the table for STD_MonetaryBenefitType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MonetaryBenefitType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MONETARYBENEFITTYPE FOR SDSADM.STD_MONETARYBENEFITTYPE;


ALTER TABLE SDSADM.STD_MONETARYBENEFITTYPE ADD (
  CONSTRAINT PK_STD_MONETARYBENEFITTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MONETARYBENEFITTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MONETARYBENEFITTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MONETARYBENEFITTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MONETARYBENEFITTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MONETARYBENEFITTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MONETARYBENEFITTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MONETARYBENEFITTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MONETARYBENEFITTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MONETARYBENEFITTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MILITARYSVCQRYSTATHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MILITARYSVCQRYSTATHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MILITARYSVCQRYSTATHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MILITARYSVCQRYSTATHSTRY ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MltrySvcQrySttHstry
after DELETE
ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY
BEGIN
	-- update the table for STD_MilitarySvcQryStatHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcQryStatHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MltrySvcQrySttHstry
after INSERT
ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY
BEGIN
	-- update the table for STD_MilitarySvcQryStatHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcQryStatHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MltrySvcQrySttHstry
after UPDATE
ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY
BEGIN
	-- update the table for STD_MilitarySvcQryStatHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcQryStatHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MILITARYSVCQRYSTATHISTORY FOR SDSADM.STD_MILITARYSVCQRYSTATHISTORY;


ALTER TABLE SDSADM.STD_MILITARYSVCQRYSTATHISTORY ADD (
  CONSTRAINT PK_STD_MILITARYSVCQRYSTATHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MILITARYSVCQRYSTATHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MILITARYSVCQRYSTATHISTORY ADD (
  CONSTRAINT FKSTD_MLTRYSVCQRYSTTHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MILITARYSVCQRYSTAT (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTATHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MILITARYSVCQRYSTAT
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MILITARYSVCQRYSTAT CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MILITARYSVCQRYSTAT
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(8 BYTE)                 NOT NULL,
  NAME         VARCHAR2(35 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MILITARYSVCQRYSTAT ON SDSADM.STD_MILITARYSVCQRYSTAT
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MILITARYSVCQRYSTATCODE ON SDSADM.STD_MILITARYSVCQRYSTAT
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MILITARYSVCQRYSTATNAME ON SDSADM.STD_MILITARYSVCQRYSTAT
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MilitarySvcQryStat
after DELETE
ON SDSADM.STD_MILITARYSVCQRYSTAT
BEGIN
	-- update the table for STD_MilitarySvcQryStat operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcQryStat';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MilitarySvcQryStat
after INSERT
ON SDSADM.STD_MILITARYSVCQRYSTAT
BEGIN
	-- update the table for STD_MilitarySvcQryStat operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcQryStat';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MilitarySvcQryStat
after UPDATE
ON SDSADM.STD_MILITARYSVCQRYSTAT
BEGIN
	-- update the table for STD_MilitarySvcQryStat operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcQryStat';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MILITARYSVCQRYSTAT FOR SDSADM.STD_MILITARYSVCQRYSTAT;


ALTER TABLE SDSADM.STD_MILITARYSVCQRYSTAT ADD (
  CONSTRAINT PK_STD_MILITARYSVCQRYSTAT
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MILITARYSVCQRYSTAT
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MILITARYSVCQRYSTATCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MILITARYSVCQRYSTATCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MILITARYSVCQRYSTATNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MILITARYSVCQRYSTATNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MILITARYSVCQRYSTAT TO ADR;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTAT TO ADREXT;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTAT TO EESRV;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTAT TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MILITARYSVCQRYSTAT TO LOBR;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTAT TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILITARYSVCQRYSTAT TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTAT TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MILITARYSVCQRYSTAT TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MILITARYSVCCOMPHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MILITARYSVCCOMPHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MILITARYSVCCOMPHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MILITARYSVCCOMPHISTORY ON SDSADM.STD_MILITARYSVCCOMPHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MilitarySvcCompHstry
after DELETE
ON SDSADM.STD_MILITARYSVCCOMPHISTORY
BEGIN
	-- update the table for STD_MilitarySvcCompHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcCompHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MilitarySvcCompHstry
after INSERT
ON SDSADM.STD_MILITARYSVCCOMPHISTORY
BEGIN
	-- update the table for STD_MilitarySvcCompHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcCompHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MilitarySvcCompHstry
after UPDATE
ON SDSADM.STD_MILITARYSVCCOMPHISTORY
BEGIN
	-- update the table for STD_MilitarySvcCompHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcCompHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MILITARYSVCCOMPHISTORY FOR SDSADM.STD_MILITARYSVCCOMPHISTORY;


ALTER TABLE SDSADM.STD_MILITARYSVCCOMPHISTORY ADD (
  CONSTRAINT PK_STD_MILITARYSVCCOMPHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MILITARYSVCCOMPHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MILITARYSVCCOMPHISTORY ADD (
  CONSTRAINT FKSTD_MILITARYSVCCOMPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MILITARYSVCCOMP (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMPHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MILITARYSVCCOMP
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MILITARYSVCCOMP CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MILITARYSVCCOMP
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MILITARYSVCCOMP ON SDSADM.STD_MILITARYSVCCOMP
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MILITARYSVCCOMPCODE ON SDSADM.STD_MILITARYSVCCOMP
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MILITARYSVCCOMPNAME ON SDSADM.STD_MILITARYSVCCOMP
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MilitarySvcComp
after DELETE
ON SDSADM.STD_MILITARYSVCCOMP
BEGIN
	-- update the table for STD_MilitarySvcComp operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcComp';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MilitarySvcComp
after INSERT
ON SDSADM.STD_MILITARYSVCCOMP
BEGIN
	-- update the table for STD_MilitarySvcComp operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcComp';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MilitarySvcComp
after UPDATE
ON SDSADM.STD_MILITARYSVCCOMP
BEGIN
	-- update the table for STD_MilitarySvcComp operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilitarySvcComp';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MILITARYSVCCOMP FOR SDSADM.STD_MILITARYSVCCOMP;


ALTER TABLE SDSADM.STD_MILITARYSVCCOMP ADD (
  CONSTRAINT PK_STD_MILITARYSVCCOMP
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MILITARYSVCCOMP
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MILITARYSVCCOMPCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MILITARYSVCCOMPCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MILITARYSVCCOMPNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MILITARYSVCCOMPNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MILITARYSVCCOMP TO ADR;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMP TO ADREXT;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMP TO EESRV;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMP TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MILITARYSVCCOMP TO LOBR;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMP TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILITARYSVCCOMP TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMP TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MILITARYSVCCOMP TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MILHISTORYTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MILHISTORYTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MILHISTORYTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MILHISTORYTYPEHISTORY ON SDSADM.STD_MILHISTORYTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MilHistoryTypeHistory
after DELETE
ON SDSADM.STD_MILHISTORYTYPEHISTORY
BEGIN
	-- update the table for STD_MilHistoryTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilHistoryTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MilHistoryTypeHistory
after INSERT
ON SDSADM.STD_MILHISTORYTYPEHISTORY
BEGIN
	-- update the table for STD_MilHistoryTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilHistoryTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MilHistoryTypeHistory
after UPDATE
ON SDSADM.STD_MILHISTORYTYPEHISTORY
BEGIN
	-- update the table for STD_MilHistoryTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilHistoryTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MILHISTORYTYPEHISTORY FOR SDSADM.STD_MILHISTORYTYPEHISTORY;


ALTER TABLE SDSADM.STD_MILHISTORYTYPEHISTORY ADD (
  CONSTRAINT PK_STD_MILHISTORYTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MILHISTORYTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MILHISTORYTYPEHISTORY ADD (
  CONSTRAINT FKSTD_MILHISTORYTYPEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MILHISTORYTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MILHISTORYTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MILHISTORYTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILHISTORYTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MILHISTORYTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MILHISTORYTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MILHISTORYTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(4 BYTE)                 NOT NULL,
  NAME         VARCHAR2(40 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MILHISTORYTYPE ON SDSADM.STD_MILHISTORYTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MILHISTORYTYPECODE ON SDSADM.STD_MILHISTORYTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MILHISTORYTYPENAME ON SDSADM.STD_MILHISTORYTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MilHistoryType
after DELETE
ON SDSADM.STD_MILHISTORYTYPE
BEGIN
	-- update the table for STD_MilHistoryType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilHistoryType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MilHistoryType
after INSERT
ON SDSADM.STD_MILHISTORYTYPE
BEGIN
	-- update the table for STD_MilHistoryType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilHistoryType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MilHistoryType
after UPDATE
ON SDSADM.STD_MILHISTORYTYPE
BEGIN
	-- update the table for STD_MilHistoryType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MilHistoryType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MILHISTORYTYPE FOR SDSADM.STD_MILHISTORYTYPE;


ALTER TABLE SDSADM.STD_MILHISTORYTYPE ADD (
  CONSTRAINT PK_STD_MILHISTORYTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MILHISTORYTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MILHISTORYTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MILHISTORYTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MILHISTORYTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MILHISTORYTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MILHISTORYTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MILHISTORYTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MILHISTORYTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MILHISTORYTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MHDATASOURCEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MHDATASOURCEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MHDATASOURCEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MHDATASOURCEHISTORY ON SDSADM.STD_MHDATASOURCEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MHDataSourceHistory
after DELETE
ON SDSADM.STD_MHDATASOURCEHISTORY
BEGIN
	-- update the table for STD_MHDataSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MHDataSourceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MHDataSourceHistory
after INSERT
ON SDSADM.STD_MHDATASOURCEHISTORY
BEGIN
	-- update the table for STD_MHDataSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MHDataSourceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MHDataSourceHistory
after UPDATE
ON SDSADM.STD_MHDATASOURCEHISTORY
BEGIN
	-- update the table for STD_MHDataSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MHDataSourceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MHDATASOURCEHISTORY FOR SDSADM.STD_MHDATASOURCEHISTORY;


ALTER TABLE SDSADM.STD_MHDATASOURCEHISTORY ADD (
  CONSTRAINT PK_STD_MHDATASOURCEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MHDATASOURCEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MHDATASOURCEHISTORY ADD (
  CONSTRAINT FKSTD_MHDATASOURCEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MHDATASOURCE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MHDATASOURCEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MHDATASOURCEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MHDATASOURCEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MHDATASOURCEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MHDATASOURCEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MHDATASOURCEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MHDATASOURCEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MHDATASOURCEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MHDATASOURCEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MHDATASOURCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MHDATASOURCE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MHDATASOURCE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(8 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MHDATASOURCE ON SDSADM.STD_MHDATASOURCE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MHDATASOURCECODE ON SDSADM.STD_MHDATASOURCE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MHDATASOURCENAME ON SDSADM.STD_MHDATASOURCE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MHDataSource
after DELETE
ON SDSADM.STD_MHDATASOURCE
BEGIN
	-- update the table for STD_MHDataSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MHDataSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MHDataSource
after INSERT
ON SDSADM.STD_MHDATASOURCE
BEGIN
	-- update the table for STD_MHDataSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MHDataSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MHDataSource
after UPDATE
ON SDSADM.STD_MHDATASOURCE
BEGIN
	-- update the table for STD_MHDataSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MHDataSource';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MHDATASOURCE FOR SDSADM.STD_MHDATASOURCE;


ALTER TABLE SDSADM.STD_MHDATASOURCE ADD (
  CONSTRAINT PK_STD_MHDATASOURCE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MHDATASOURCE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MHDATASOURCECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MHDATASOURCECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MHDATASOURCENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MHDATASOURCENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MHDATASOURCE TO ADR;

GRANT SELECT ON SDSADM.STD_MHDATASOURCE TO ADREXT;

GRANT SELECT ON SDSADM.STD_MHDATASOURCE TO EESRV;

GRANT SELECT ON SDSADM.STD_MHDATASOURCE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MHDATASOURCE TO LOBR;

GRANT SELECT ON SDSADM.STD_MHDATASOURCE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MHDATASOURCE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MHDATASOURCE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MHDATASOURCE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MESSAGETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MESSAGETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MESSAGETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MESSAGETYPEHISTORY ON SDSADM.STD_MESSAGETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MessageTypeHistory
after DELETE
ON SDSADM.STD_MESSAGETYPEHISTORY
BEGIN
	-- update the table for STD_MessageTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MessageTypeHistory
after INSERT
ON SDSADM.STD_MESSAGETYPEHISTORY
BEGIN
	-- update the table for STD_MessageTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MessageTypeHistory
after UPDATE
ON SDSADM.STD_MESSAGETYPEHISTORY
BEGIN
	-- update the table for STD_MessageTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MESSAGETYPEHISTORY FOR SDSADM.STD_MESSAGETYPEHISTORY;


ALTER TABLE SDSADM.STD_MESSAGETYPEHISTORY ADD (
  CONSTRAINT PK_STD_MESSAGETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MESSAGETYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MESSAGETYPEHISTORY ADD (
  CONSTRAINT FKSTD_MESSAGETYPEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MESSAGETYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MESSAGETYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MESSAGETYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MESSAGETYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MESSAGETYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MESSAGETYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MESSAGETYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MESSAGETYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MESSAGETYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MESSAGETYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MESSAGETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MESSAGETYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MESSAGETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(8 BYTE)                     NOT NULL,
  NAME         VARCHAR2(60 BYTE)                NOT NULL,
  DIRECTION    CHAR(1 BYTE)                     NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MESSAGETYPE ON SDSADM.STD_MESSAGETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MESSAGETYPECODE ON SDSADM.STD_MESSAGETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MESSAGETYPENAME ON SDSADM.STD_MESSAGETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.DEL4_STD_MESSAGETYPE
after DELETE
ON SDSADM.STD_MESSAGETYPE
BEGIN
	-- update the table for STD_MessageType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.INS4_STD_MESSAGETYPE
after INSERT
ON SDSADM.STD_MESSAGETYPE
BEGIN
	-- update the table for STD_MessageType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.UPD4_STD_MESSAGETYPE
after UPDATE
ON SDSADM.STD_MESSAGETYPE
BEGIN
	-- update the table for STD_MessageType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MESSAGETYPE FOR SDSADM.STD_MESSAGETYPE;


ALTER TABLE SDSADM.STD_MESSAGETYPE ADD (
  CONSTRAINT PK_STD_MESSAGETYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MESSAGETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MESSAGETYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MESSAGETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MESSAGETYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MESSAGETYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MESSAGETYPE TO ADR;

GRANT SELECT ON SDSADM.STD_MESSAGETYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_MESSAGETYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_MESSAGETYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MESSAGETYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_MESSAGETYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MESSAGETYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MESSAGETYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MESSAGETYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MESSAGESTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MESSAGESTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MESSAGESTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MESSAGESTATUSHISTORY ON SDSADM.STD_MESSAGESTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MessageStatusHistory
after DELETE
ON SDSADM.STD_MESSAGESTATUSHISTORY
BEGIN
	-- update the table for STD_MessageStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MessageStatusHistory
after INSERT
ON SDSADM.STD_MESSAGESTATUSHISTORY
BEGIN
	-- update the table for STD_MessageStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MessageStatusHistory
after UPDATE
ON SDSADM.STD_MESSAGESTATUSHISTORY
BEGIN
	-- update the table for STD_MessageStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageStatusHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MESSAGESTATUSHISTORY FOR SDSADM.STD_MESSAGESTATUSHISTORY;


ALTER TABLE SDSADM.STD_MESSAGESTATUSHISTORY ADD (
  CONSTRAINT PK_STD_MESSAGESTATUSHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MESSAGESTATUSHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MESSAGESTATUSHISTORY ADD (
  CONSTRAINT FKSTD_MESSAGESTATUSHISTORYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MESSAGESTATUS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MESSAGESTATUSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MESSAGESTATUSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MESSAGESTATUSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MESSAGESTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MESSAGESTATUS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MESSAGESTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MESSAGESTATUS ON SDSADM.STD_MESSAGESTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MESSAGESTATUSCODE ON SDSADM.STD_MESSAGESTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MESSAGESTATUSNAME ON SDSADM.STD_MESSAGESTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.DEL4_STD_MESSAGESTATUS
after DELETE
ON SDSADM.STD_MESSAGESTATUS
BEGIN
	-- update the table for STD_MessageStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.INS4_STD_MESSAGESTATUS
after INSERT
ON SDSADM.STD_MESSAGESTATUS
BEGIN
	-- update the table for STD_MessageStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.UPD4_STD_MESSAGESTATUS
after UPDATE
ON SDSADM.STD_MESSAGESTATUS
BEGIN
	-- update the table for STD_MessageStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MessageStatus';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MESSAGESTATUS FOR SDSADM.STD_MESSAGESTATUS;


ALTER TABLE SDSADM.STD_MESSAGESTATUS ADD (
  CONSTRAINT PK_STD_MESSAGESTATUS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MESSAGESTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MESSAGESTATUSCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MESSAGESTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MESSAGESTATUSNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MESSAGESTATUSNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MESSAGESTATUS TO ADR;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUS TO ADREXT;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUS TO EESRV;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MESSAGESTATUS TO LOBR;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MESSAGESTATUS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MESSAGESTATUS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MEANSTESTSTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MEANSTESTSTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MEANSTESTSTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MEANSTESTSTATUSHISTORY ON SDSADM.STD_MEANSTESTSTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MeansTestStatusHstry
after DELETE
ON SDSADM.STD_MEANSTESTSTATUSHISTORY
BEGIN
	-- update the table for STD_MeansTestStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MeansTestStatusHstry
after INSERT
ON SDSADM.STD_MEANSTESTSTATUSHISTORY
BEGIN
	-- update the table for STD_MeansTestStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MeansTestStatusHstry
after UPDATE
ON SDSADM.STD_MEANSTESTSTATUSHISTORY
BEGIN
	-- update the table for STD_MeansTestStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestStatusHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MEANSTESTSTATUSHISTORY FOR SDSADM.STD_MEANSTESTSTATUSHISTORY;


ALTER TABLE SDSADM.STD_MEANSTESTSTATUSHISTORY ADD (
  CONSTRAINT PK_STD_MEANSTESTSTATUSHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MEANSTESTSTATUSHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MEANSTESTSTATUSHISTORY ADD (
  CONSTRAINT FKSTD_MEANSTESTSTATUSHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MEANSTESTSTATUS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MEANSTESTSTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MEANSTESTSTATUS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MEANSTESTSTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(1 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MEANSTESTSTATUS ON SDSADM.STD_MEANSTESTSTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MEANSTESTSTATUSCODE ON SDSADM.STD_MEANSTESTSTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MEANSTESTSTATUSNAME ON SDSADM.STD_MEANSTESTSTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MeansTestStatus
after DELETE
ON SDSADM.STD_MEANSTESTSTATUS
BEGIN
	-- update the table for STD_MeansTestStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MeansTestStatus
after INSERT
ON SDSADM.STD_MEANSTESTSTATUS
BEGIN
	-- update the table for STD_MeansTestStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MeansTestStatus
after UPDATE
ON SDSADM.STD_MEANSTESTSTATUS
BEGIN
	-- update the table for STD_MeansTestStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestStatus';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MEANSTESTSTATUS FOR SDSADM.STD_MEANSTESTSTATUS;


ALTER TABLE SDSADM.STD_MEANSTESTSTATUS ADD (
  CONSTRAINT PK_STD_MEANSTESTSTATUS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MEANSTESTSTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MEANSTESTSTATUSCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MEANSTESTSTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MEANSTESTSTATUSNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MEANSTESTSTATUSNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MEANSTESTSTATUS TO ADR;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUS TO ADREXT;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUS TO EESRV;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MEANSTESTSTATUS TO LOBR;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MEANSTESTSTATUS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MEANSTESTSTATUS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MEANSTESTSIGSTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MEANSTESTSIGSTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MEANSTESTSIGSTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MEANSTESTSIGSTATUSHSTRY ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MeansTestSigSttsHstry
after DELETE
ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY
BEGIN
	-- update the table for STD_MeansTestSigStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestSigStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MeansTestSigSttsHstry
after INSERT
ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY
BEGIN
	-- update the table for STD_MeansTestSigStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestSigStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MeansTestSigSttsHstry
after UPDATE
ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY
BEGIN
	-- update the table for STD_MeansTestSigStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestSigStatusHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MEANSTESTSIGSTATUSHISTORY FOR SDSADM.STD_MEANSTESTSIGSTATUSHISTORY;


ALTER TABLE SDSADM.STD_MEANSTESTSIGSTATUSHISTORY ADD (
  CONSTRAINT PK_STD_MEANSTESTSIGSTATUSHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MEANSTESTSIGSTATUSHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MEANSTESTSIGSTATUSHISTORY ADD (
  CONSTRAINT FKSTD_MEANSTESTSGSTTSHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MEANSTESTSIGSTATUS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MEANSTESTSIGSTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MEANSTESTSIGSTATUS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MEANSTESTSIGSTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MEANSTESTSIGSTATUS ON SDSADM.STD_MEANSTESTSIGSTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MEANSTESTSIGSTATUSCODE ON SDSADM.STD_MEANSTESTSIGSTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MEANSTESTSIGSTATUSNAME ON SDSADM.STD_MEANSTESTSIGSTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MeansTestSigStatus
after DELETE
ON SDSADM.STD_MEANSTESTSIGSTATUS
BEGIN
	-- update the table for STD_MeansTestSigStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestSigStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MeansTestSigStatus
after INSERT
ON SDSADM.STD_MEANSTESTSIGSTATUS
BEGIN
	-- update the table for STD_MeansTestSigStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestSigStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MeansTestSigStatus
after UPDATE
ON SDSADM.STD_MEANSTESTSIGSTATUS
BEGIN
	-- update the table for STD_MeansTestSigStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MeansTestSigStatus';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MEANSTESTSIGSTATUS FOR SDSADM.STD_MEANSTESTSIGSTATUS;


ALTER TABLE SDSADM.STD_MEANSTESTSIGSTATUS ADD (
  CONSTRAINT PK_STD_MEANSTESTSIGSTATUS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MEANSTESTSIGSTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MEANSTESTSIGSTATUSCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MEANSTESTSIGSTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MEANSTESTSIGSTATUSNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MEANSTESTSIGSTATUSNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MEANSTESTSIGSTATUS TO ADR;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUS TO ADREXT;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUS TO EESRV;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MEANSTESTSIGSTATUS TO LOBR;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MEANSTESTSIGSTATUS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MEANSTESTSIGSTATUS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MASMTTHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MASMTTHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MASMTTHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MASMTTHISTORY ON SDSADM.STD_MASMTTHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MASMTTHistory
after DELETE
ON SDSADM.STD_MASMTTHISTORY
BEGIN
	-- update the table for STD_MASMTTHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MASMTTHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MASMTTHistory
after INSERT
ON SDSADM.STD_MASMTTHISTORY
BEGIN
	-- update the table for STD_MASMTTHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MASMTTHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MASMTTHistory
after UPDATE
ON SDSADM.STD_MASMTTHISTORY
BEGIN
	-- update the table for STD_MASMTTHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MASMTTHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MASMTTHISTORY FOR SDSADM.STD_MASMTTHISTORY;


ALTER TABLE SDSADM.STD_MASMTTHISTORY ADD (
  CONSTRAINT PK_STD_MASMTTHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MASMTTHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MASMTTHISTORY ADD (
  CONSTRAINT FKSTD_MASMTTHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MASMTTHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MASMTTHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MASMTTHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MASMTTHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MASMTTHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MASMTTHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MASMTTHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MASMTTHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MASMTTHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MASMTT ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MASMTTNAME ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MASMTT
after DELETE
ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE
BEGIN
	-- update the table for STD_MASMovementTransactionType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MASMovementTransactionType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MASMTT
after INSERT
ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE
BEGIN
	-- update the table for STD_MASMovementTransactionType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MASMovementTransactionType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MASMTT
after UPDATE
ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE
BEGIN
	-- update the table for STD_MASMovementTransactionType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MASMovementTransactionType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MASMOVEMENTTRANSACTIONTYPE FOR SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE;


ALTER TABLE SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE ADD (
  CONSTRAINT PK_STD_MASMTT
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MASMTT
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MASMTTNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MASMTTNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MASMOVEMENTTRANSACTIONTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MARITALSTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MARITALSTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MARITALSTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MARITALSTATUSHISTORY ON SDSADM.STD_MARITALSTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MaritalStatusHistory
after DELETE
ON SDSADM.STD_MARITALSTATUSHISTORY
BEGIN
	-- update the table for STD_MaritalStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MaritalStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MaritalStatusHistory
after INSERT
ON SDSADM.STD_MARITALSTATUSHISTORY
BEGIN
	-- update the table for STD_MaritalStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MaritalStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MaritalStatusHistory
after UPDATE
ON SDSADM.STD_MARITALSTATUSHISTORY
BEGIN
	-- update the table for STD_MaritalStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MaritalStatusHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MARITALSTATUSHISTORY FOR SDSADM.STD_MARITALSTATUSHISTORY;


ALTER TABLE SDSADM.STD_MARITALSTATUSHISTORY ADD (
  CONSTRAINT PK_STD_MARITALSTATUSHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MARITALSTATUSHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_MARITALSTATUSHISTORY ADD (
  CONSTRAINT FKSTD_MARITALSTATUSHISTORYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_MARITALSTATUS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MARITALSTATUSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_MARITALSTATUSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_MARITALSTATUSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_MARITALSTATUSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MARITALSTATUSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_MARITALSTATUSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MARITALSTATUSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MARITALSTATUSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MARITALSTATUSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_MARITALSTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_MARITALSTATUS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_MARITALSTATUS
(
  ID            NUMBER(20)                      NOT NULL,
  CODE          VARCHAR2(3 BYTE)                NOT NULL,
  NAME          VARCHAR2(30 BYTE)               NOT NULL,
  DESCRIPTION   VARCHAR2(70 BYTE),
  ABBREVIATION  VARCHAR2(5 BYTE),
  VERSION       INTEGER                         NOT NULL,
  CREATED       TIMESTAMP(6)                    NOT NULL,
  UPDATED       TIMESTAMP(6),
  CREATEDBY     VARCHAR2(32 BYTE)               NOT NULL,
  UPDATEDBY     VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_MARITALSTATUS ON SDSADM.STD_MARITALSTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MARITALSTATUSCODE ON SDSADM.STD_MARITALSTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_MARITALSTATUSNAME ON SDSADM.STD_MARITALSTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_MaritalStatus
after DELETE
ON SDSADM.STD_MARITALSTATUS
BEGIN
	-- update the table for STD_MaritalStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MaritalStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_MaritalStatus
after INSERT
ON SDSADM.STD_MARITALSTATUS
BEGIN
	-- update the table for STD_MaritalStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MaritalStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_MaritalStatus
after UPDATE
ON SDSADM.STD_MARITALSTATUS
BEGIN
	-- update the table for STD_MaritalStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_MaritalStatus';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_MARITALSTATUS FOR SDSADM.STD_MARITALSTATUS;


ALTER TABLE SDSADM.STD_MARITALSTATUS ADD (
  CONSTRAINT PK_STD_MARITALSTATUS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_MARITALSTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MARITALSTATUSCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_MARITALSTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_MARITALSTATUSNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_MARITALSTATUSNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_MARITALSTATUS TO ADR;

GRANT SELECT ON SDSADM.STD_MARITALSTATUS TO ADREXT;

GRANT SELECT ON SDSADM.STD_MARITALSTATUS TO EESRV;

GRANT SELECT ON SDSADM.STD_MARITALSTATUS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_MARITALSTATUS TO LOBR;

GRANT SELECT ON SDSADM.STD_MARITALSTATUS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_MARITALSTATUS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_MARITALSTATUS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_MARITALSTATUS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_LOCATIONTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_LOCATIONTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_LOCATIONTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_LOCATIONTYPEHISTORY ON SDSADM.STD_LOCATIONTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_LocationTypeHistory
after DELETE
ON SDSADM.STD_LOCATIONTYPEHISTORY
BEGIN
	-- update the table for STD_LocationTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_LocationTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_LocationTypeHistory
after INSERT
ON SDSADM.STD_LOCATIONTYPEHISTORY
BEGIN
	-- update the table for STD_LocationTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_LocationTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_LocationTypeHistory
after UPDATE
ON SDSADM.STD_LOCATIONTYPEHISTORY
BEGIN
	-- update the table for STD_LocationTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_LocationTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_LOCATIONTYPEHISTORY FOR SDSADM.STD_LOCATIONTYPEHISTORY;


ALTER TABLE SDSADM.STD_LOCATIONTYPEHISTORY ADD (
  CONSTRAINT PK_STD_LOCATIONTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_LOCATIONTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_LOCATIONTYPEHISTORY ADD (
  CONSTRAINT FKSTD_LOCATIONTYPEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_LOCATIONTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_LOCATIONTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_LOCATIONTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_LOCATIONTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_LOCATIONTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_LOCATIONTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_LOCATIONTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(1 BYTE)                     NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_LOCATIONTYPE ON SDSADM.STD_LOCATIONTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_LOCATIONTYPECODE ON SDSADM.STD_LOCATIONTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_LOCATIONTYPENAME ON SDSADM.STD_LOCATIONTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_LocationType
after DELETE
ON SDSADM.STD_LOCATIONTYPE
BEGIN
	-- update the table for STD_LocationType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_LocationType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_LocationType
after INSERT
ON SDSADM.STD_LOCATIONTYPE
BEGIN
	-- update the table for STD_LocationType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_LocationType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_LocationType
after UPDATE
ON SDSADM.STD_LOCATIONTYPE
BEGIN
	-- update the table for STD_LocationType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_LocationType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_LOCATIONTYPE FOR SDSADM.STD_LOCATIONTYPE;


ALTER TABLE SDSADM.STD_LOCATIONTYPE ADD (
  CONSTRAINT PK_STD_LOCATIONTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_LOCATIONTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_LOCATIONTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_LOCATIONTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_LOCATIONTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_LOCATIONTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_LOCATIONTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_LOCATIONTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_LOCATIONTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_LOCATIONTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IVMUNITHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IVMUNITHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IVMUNITHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IVMUNITHISTORY ON SDSADM.STD_IVMUNITHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IVMUnitHistory
after DELETE
ON SDSADM.STD_IVMUNITHISTORY
BEGIN
	-- update the table for STD_IVMUnitHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMUnitHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IVMUnitHistory
after INSERT
ON SDSADM.STD_IVMUNITHISTORY
BEGIN
	-- update the table for STD_IVMUnitHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMUnitHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IVMUnitHistory
after UPDATE
ON SDSADM.STD_IVMUNITHISTORY
BEGIN
	-- update the table for STD_IVMUnitHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMUnitHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IVMUNITHISTORY FOR SDSADM.STD_IVMUNITHISTORY;


ALTER TABLE SDSADM.STD_IVMUNITHISTORY ADD (
  CONSTRAINT PK_STD_IVMUNITHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IVMUNITHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_IVMUNITHISTORY ADD (
  CONSTRAINT FKSTD_IVMUNITHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_IVMUNIT (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IVMUNITHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_IVMUNITHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_IVMUNITHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_IVMUNITHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IVMUNITHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_IVMUNITHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMUNITHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IVMUNITHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IVMUNITHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IVMUNIT
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IVMUNIT CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IVMUNIT
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IVMUNIT ON SDSADM.STD_IVMUNIT
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IVMUNITCODE ON SDSADM.STD_IVMUNIT
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IVMUNITNAME ON SDSADM.STD_IVMUNIT
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IVMUnit
after DELETE
ON SDSADM.STD_IVMUNIT
BEGIN
	-- update the table for STD_IVMUnit operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMUnit';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IVMUnit
after INSERT
ON SDSADM.STD_IVMUNIT
BEGIN
	-- update the table for STD_IVMUnit operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMUnit';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IVMUnit
after UPDATE
ON SDSADM.STD_IVMUNIT
BEGIN
	-- update the table for STD_IVMUnit operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMUnit';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IVMUNIT FOR SDSADM.STD_IVMUNIT;


ALTER TABLE SDSADM.STD_IVMUNIT ADD (
  CONSTRAINT PK_STD_IVMUNIT
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IVMUNIT
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IVMUNITCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_IVMUNITCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IVMUNITNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_IVMUNITNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IVMUNIT TO ADR;

GRANT SELECT ON SDSADM.STD_IVMUNIT TO ADREXT;

GRANT SELECT ON SDSADM.STD_IVMUNIT TO EESRV;

GRANT SELECT ON SDSADM.STD_IVMUNIT TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IVMUNIT TO LOBR;

GRANT SELECT ON SDSADM.STD_IVMUNIT TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMUNIT TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IVMUNIT TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IVMUNIT TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IVMMIGRATETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IVMMIGRATETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IVMMIGRATETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IVMMIGRATETYPEHISTORY ON SDSADM.STD_IVMMIGRATETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IVMMigrateTypeHistory
after DELETE
ON SDSADM.STD_IVMMIGRATETYPEHISTORY
BEGIN
	-- update the table for STD_IVMMigrateTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMMigrateTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IVMMigrateTypeHistory
after INSERT
ON SDSADM.STD_IVMMIGRATETYPEHISTORY
BEGIN
	-- update the table for STD_IVMMigrateTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMMigrateTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IVMMigrateTypeHistory
after UPDATE
ON SDSADM.STD_IVMMIGRATETYPEHISTORY
BEGIN
	-- update the table for STD_IVMMigrateTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMMigrateTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IVMMIGRATETYPEHISTORY FOR SDSADM.STD_IVMMIGRATETYPEHISTORY;


ALTER TABLE SDSADM.STD_IVMMIGRATETYPEHISTORY ADD (
  CONSTRAINT PK_STD_IVMMIGRATETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IVMMIGRATETYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_IVMMIGRATETYPEHISTORY ADD (
  CONSTRAINT FKSTD_IVMMIGRATETYPEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_IVMMIGRATETYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IVMMIGRATETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IVMMIGRATETYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IVMMIGRATETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IVMMIGRATETYPE ON SDSADM.STD_IVMMIGRATETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IVMMIGRATETYPECODE ON SDSADM.STD_IVMMIGRATETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IVMMigrateType
after DELETE
ON SDSADM.STD_IVMMIGRATETYPE
BEGIN
	-- update the table for STD_IVMMigrateType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMMigrateType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IVMMigrateType
after INSERT
ON SDSADM.STD_IVMMIGRATETYPE
BEGIN
	-- update the table for STD_IVMMigrateType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMMigrateType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IVMMigrateType
after UPDATE
ON SDSADM.STD_IVMMIGRATETYPE
BEGIN
	-- update the table for STD_IVMMigrateType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMMigrateType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IVMMIGRATETYPE FOR SDSADM.STD_IVMMIGRATETYPE;


ALTER TABLE SDSADM.STD_IVMMIGRATETYPE ADD (
  CONSTRAINT PK_STD_IVMMIGRATETYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IVMMIGRATETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IVMMIGRATETYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_IVMMIGRATETYPECODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IVMMIGRATETYPE TO ADR;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IVMMIGRATETYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMMIGRATETYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IVMMIGRATETYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IVMDECISIONTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IVMDECISIONTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IVMDECISIONTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IVMDECISIONTYPEHISTORY ON SDSADM.STD_IVMDECISIONTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IVMDecisionTypeHstry
after DELETE
ON SDSADM.STD_IVMDECISIONTYPEHISTORY
BEGIN
	-- update the table for STD_IVMDecisionTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMDecisionTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IVMDecisionTypeHstry
after INSERT
ON SDSADM.STD_IVMDECISIONTYPEHISTORY
BEGIN
	-- update the table for STD_IVMDecisionTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMDecisionTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IVMDecisionTypeHstry
after UPDATE
ON SDSADM.STD_IVMDECISIONTYPEHISTORY
BEGIN
	-- update the table for STD_IVMDecisionTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMDecisionTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IVMDECISIONTYPEHISTORY FOR SDSADM.STD_IVMDECISIONTYPEHISTORY;


ALTER TABLE SDSADM.STD_IVMDECISIONTYPEHISTORY ADD (
  CONSTRAINT PK_STD_IVMDECISIONTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IVMDECISIONTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_IVMDECISIONTYPEHISTORY ADD (
  CONSTRAINT FKSTD_IVMDECISIONTYPEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_IVMDECISIONTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IVMDECISIONTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IVMDECISIONTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IVMDECISIONTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IVMDECISIONTYPE ON SDSADM.STD_IVMDECISIONTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IVMDECISIONTYPECODE ON SDSADM.STD_IVMDECISIONTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IVMDECISIONTYPENAME ON SDSADM.STD_IVMDECISIONTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IVMDecisionType
after DELETE
ON SDSADM.STD_IVMDECISIONTYPE
BEGIN
	-- update the table for STD_IVMDecisionType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMDecisionType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IVMDecisionType
after INSERT
ON SDSADM.STD_IVMDECISIONTYPE
BEGIN
	-- update the table for STD_IVMDecisionType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMDecisionType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IVMDecisionType
after UPDATE
ON SDSADM.STD_IVMDECISIONTYPE
BEGIN
	-- update the table for STD_IVMDecisionType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMDecisionType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IVMDECISIONTYPE FOR SDSADM.STD_IVMDECISIONTYPE;


ALTER TABLE SDSADM.STD_IVMDECISIONTYPE ADD (
  CONSTRAINT PK_STD_IVMDECISIONTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IVMDECISIONTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IVMDECISIONTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_IVMDECISIONTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IVMDECISIONTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_IVMDECISIONTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IVMDECISIONTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IVMDECISIONTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMDECISIONTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IVMDECISIONTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IVMCASEPRIORCRITHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IVMCASEPRIORCRITHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IVMCASEPRIORCRITHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IVMCASEPRIORCRITHISTORY ON SDSADM.STD_IVMCASEPRIORCRITHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IVMCasePriorCritHstry
after DELETE
ON SDSADM.STD_IVMCASEPRIORCRITHISTORY
BEGIN
	-- update the table for STD_IVMCasePriorCritHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMCasePriorCritHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IVMCasePriorCritHstry
after INSERT
ON SDSADM.STD_IVMCASEPRIORCRITHISTORY
BEGIN
	-- update the table for STD_IVMCasePriorCritHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMCasePriorCritHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IVMCasePriorCritHstry
after UPDATE
ON SDSADM.STD_IVMCASEPRIORCRITHISTORY
BEGIN
	-- update the table for STD_IVMCasePriorCritHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMCasePriorCritHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IVMCASEPRIORCRITHISTORY FOR SDSADM.STD_IVMCASEPRIORCRITHISTORY;


ALTER TABLE SDSADM.STD_IVMCASEPRIORCRITHISTORY ADD (
  CONSTRAINT PK_STD_IVMCASEPRIORCRITHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IVMCASEPRIORCRITHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_IVMCASEPRIORCRITHISTORY ADD (
  CONSTRAINT FKSTD_IVMCASEPRIORCRTHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_IVMCASEPRIORCRIT (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRITHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IVMCASEPRIORCRIT
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IVMCASEPRIORCRIT CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IVMCASEPRIORCRIT
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IVMCASEPRIORCRIT ON SDSADM.STD_IVMCASEPRIORCRIT
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IVMCASEPRIORCRITCODE ON SDSADM.STD_IVMCASEPRIORCRIT
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IVMCASEPRIORCRITNAME ON SDSADM.STD_IVMCASEPRIORCRIT
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IVMCasePriorCrit
after DELETE
ON SDSADM.STD_IVMCASEPRIORCRIT
BEGIN
	-- update the table for STD_IVMCasePriorCrit operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMCasePriorCrit';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IVMCasePriorCrit
after INSERT
ON SDSADM.STD_IVMCASEPRIORCRIT
BEGIN
	-- update the table for STD_IVMCasePriorCrit operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMCasePriorCrit';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IVMCasePriorCrit
after UPDATE
ON SDSADM.STD_IVMCASEPRIORCRIT
BEGIN
	-- update the table for STD_IVMCasePriorCrit operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IVMCasePriorCrit';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IVMCASEPRIORCRIT FOR SDSADM.STD_IVMCASEPRIORCRIT;


ALTER TABLE SDSADM.STD_IVMCASEPRIORCRIT ADD (
  CONSTRAINT PK_STD_IVMCASEPRIORCRIT
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IVMCASEPRIORCRIT
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IVMCASEPRIORCRITCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_IVMCASEPRIORCRITCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IVMCASEPRIORCRITNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_IVMCASEPRIORCRITNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IVMCASEPRIORCRIT TO ADR;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRIT TO ADREXT;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRIT TO EESRV;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRIT TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IVMCASEPRIORCRIT TO LOBR;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRIT TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IVMCASEPRIORCRIT TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRIT TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IVMCASEPRIORCRIT TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSURANCETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSURANCETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSURANCETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSURANCETYPEHISTORY ON SDSADM.STD_INSURANCETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InsuranceTypeHistory
after DELETE
ON SDSADM.STD_INSURANCETYPEHISTORY
BEGIN
	-- update the table for STD_InsuranceTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InsuranceTypeHistory
after INSERT
ON SDSADM.STD_INSURANCETYPEHISTORY
BEGIN
	-- update the table for STD_InsuranceTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InsuranceTypeHistory
after UPDATE
ON SDSADM.STD_INSURANCETYPEHISTORY
BEGIN
	-- update the table for STD_InsuranceTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSURANCETYPEHISTORY FOR SDSADM.STD_INSURANCETYPEHISTORY;


ALTER TABLE SDSADM.STD_INSURANCETYPEHISTORY ADD (
  CONSTRAINT PK_STD_INSURANCETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSURANCETYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INSURANCETYPEHISTORY ADD (
  CONSTRAINT FKSTD_INSURANCETYPEHISTORYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_INSURANCETYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSURANCETYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_INSURANCETYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSURANCETYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_INSURANCETYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSURANCETYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_INSURANCETYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCETYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSURANCETYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSURANCETYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSURANCETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSURANCETYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSURANCETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSURANCETYPE ON SDSADM.STD_INSURANCETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSURANCETYPECODE ON SDSADM.STD_INSURANCETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSURANCETYPENAME ON SDSADM.STD_INSURANCETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InsuranceType
after DELETE
ON SDSADM.STD_INSURANCETYPE
BEGIN
	-- update the table for STD_InsuranceType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InsuranceType
after INSERT
ON SDSADM.STD_INSURANCETYPE
BEGIN
	-- update the table for STD_InsuranceType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InsuranceType
after UPDATE
ON SDSADM.STD_INSURANCETYPE
BEGIN
	-- update the table for STD_InsuranceType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSURANCETYPE FOR SDSADM.STD_INSURANCETYPE;


ALTER TABLE SDSADM.STD_INSURANCETYPE ADD (
  CONSTRAINT PK_STD_INSURANCETYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSURANCETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSURANCETYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_INSURANCETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSURANCETYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_INSURANCETYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSURANCETYPE TO ADR;

GRANT SELECT ON SDSADM.STD_INSURANCETYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSURANCETYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_INSURANCETYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSURANCETYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_INSURANCETYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCETYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSURANCETYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSURANCETYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSURANCEREPORTSOURCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSURANCEREPORTSOURCE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSURANCEREPORTSOURCE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSRPRTSRC ON SDSADM.STD_INSURANCEREPORTSOURCE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSRPRTSRCCODE ON SDSADM.STD_INSURANCEREPORTSOURCE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSRPRTSRCNAME ON SDSADM.STD_INSURANCEREPORTSOURCE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InsRprtSrc
after DELETE
ON SDSADM.STD_INSURANCEREPORTSOURCE
BEGIN
	-- update the table for STD_InsuranceReportSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceReportSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InsRprtSrc
after INSERT
ON SDSADM.STD_INSURANCEREPORTSOURCE
BEGIN
	-- update the table for STD_InsuranceReportSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceReportSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InsRprtSrc
after UPDATE
ON SDSADM.STD_INSURANCEREPORTSOURCE
BEGIN
	-- update the table for STD_InsuranceReportSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceReportSource';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSURANCEREPORTSOURCE FOR SDSADM.STD_INSURANCEREPORTSOURCE;


ALTER TABLE SDSADM.STD_INSURANCEREPORTSOURCE ADD (
  CONSTRAINT PK_STD_INSRPRTSRC
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSRPRTSRC
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSRPRTSRCCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_INSRPRTSRCCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSRPRTSRCNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_INSRPRTSRCNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSURANCEREPORTSOURCE TO ADR;

GRANT SELECT ON SDSADM.STD_INSURANCEREPORTSOURCE TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSURANCEREPORTSOURCE TO EESRV;

GRANT SELECT ON SDSADM.STD_INSURANCEREPORTSOURCE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSURANCEREPORTSOURCE TO LOBR;

GRANT SELECT ON SDSADM.STD_INSURANCEREPORTSOURCE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEREPORTSOURCE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSURANCEREPORTSOURCE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSURANCEREPORTSOURCE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSURANCEPLANTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSURANCEPLANTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSURANCEPLANTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSPLANTYPE ON SDSADM.STD_INSURANCEPLANTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSPLANTYPECODE ON SDSADM.STD_INSURANCEPLANTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSPLANTYPENAME ON SDSADM.STD_INSURANCEPLANTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InsPlanType
after DELETE
ON SDSADM.STD_INSURANCEPLANTYPE
BEGIN
	-- update the table for STD_InsurancePlanType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsurancePlanType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InsPlanType
after INSERT
ON SDSADM.STD_INSURANCEPLANTYPE
BEGIN
	-- update the table for STD_InsurancePlanType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsurancePlanType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InsPlanType
after UPDATE
ON SDSADM.STD_INSURANCEPLANTYPE
BEGIN
	-- update the table for STD_InsurancePlanType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsurancePlanType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSURANCEPLANTYPE FOR SDSADM.STD_INSURANCEPLANTYPE;


ALTER TABLE SDSADM.STD_INSURANCEPLANTYPE ADD (
  CONSTRAINT PK_STD_INSPLANTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSPLANTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSPLANTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_INSPLANTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSPLANTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_INSPLANTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSURANCEPLANTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_INSURANCEPLANTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSURANCEPLANTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_INSURANCEPLANTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSURANCEPLANTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_INSURANCEPLANTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEPLANTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSURANCEPLANTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSURANCEPLANTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSURANCEMAPPINGHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSURANCEMAPPINGHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSURANCEMAPPINGHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSURANCEMAPPINGHISTORY ON SDSADM.STD_INSURANCEMAPPINGHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InsuranceMappingHstry
after DELETE
ON SDSADM.STD_INSURANCEMAPPINGHISTORY
BEGIN
	-- update the table for STD_InsuranceMappingHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceMappingHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InsuranceMappingHstry
after INSERT
ON SDSADM.STD_INSURANCEMAPPINGHISTORY
BEGIN
	-- update the table for STD_InsuranceMappingHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceMappingHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InsuranceMappingHstry
after UPDATE
ON SDSADM.STD_INSURANCEMAPPINGHISTORY
BEGIN
	-- update the table for STD_InsuranceMappingHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceMappingHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSURANCEMAPPINGHISTORY FOR SDSADM.STD_INSURANCEMAPPINGHISTORY;


ALTER TABLE SDSADM.STD_INSURANCEMAPPINGHISTORY ADD (
  CONSTRAINT PK_STD_INSURANCEMAPPINGHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSURANCEMAPPINGHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INSURANCEMAPPINGHISTORY ADD (
  CONSTRAINT FKSTD_INSURANCEMPPNGHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_INSURANCEMAPPING (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPINGHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSURANCEMAPPING
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSURANCEMAPPING CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSURANCEMAPPING
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(5 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSURANCEMAPPING ON SDSADM.STD_INSURANCEMAPPING
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSURANCEMAPPINGCODE ON SDSADM.STD_INSURANCEMAPPING
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSURANCEMAPPINGNAME ON SDSADM.STD_INSURANCEMAPPING
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InsuranceMapping
after DELETE
ON SDSADM.STD_INSURANCEMAPPING
BEGIN
	-- update the table for STD_InsuranceMapping operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceMapping';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InsuranceMapping
after INSERT
ON SDSADM.STD_INSURANCEMAPPING
BEGIN
	-- update the table for STD_InsuranceMapping operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceMapping';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InsuranceMapping
after UPDATE
ON SDSADM.STD_INSURANCEMAPPING
BEGIN
	-- update the table for STD_InsuranceMapping operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceMapping';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSURANCEMAPPING FOR SDSADM.STD_INSURANCEMAPPING;


ALTER TABLE SDSADM.STD_INSURANCEMAPPING ADD (
  CONSTRAINT PK_STD_INSURANCEMAPPING
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSURANCEMAPPING
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSURANCEMAPPINGCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_INSURANCEMAPPINGCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSURANCEMAPPINGNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_INSURANCEMAPPINGNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSURANCEMAPPING TO ADR;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPING TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPING TO EESRV;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPING TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSURANCEMAPPING TO LOBR;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPING TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEMAPPING TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPING TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSURANCEMAPPING TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSURANCEHOLDERTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSURANCEHOLDERTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSURANCEHOLDERTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSURANCEHOLDERTYPHSTRY ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InsuranceHldrTypHstry
after DELETE
ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY
BEGIN
	-- update the table for STD_InsuranceHolderTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceHolderTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InsuranceHldrTypHstry
after INSERT
ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY
BEGIN
	-- update the table for STD_InsuranceHolderTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceHolderTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InsuranceHldrTypHstry
after UPDATE
ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY
BEGIN
	-- update the table for STD_InsuranceHolderTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceHolderTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSURANCEHOLDERTYPEHISTORY FOR SDSADM.STD_INSURANCEHOLDERTYPEHISTORY;


ALTER TABLE SDSADM.STD_INSURANCEHOLDERTYPEHISTORY ADD (
  CONSTRAINT PK_STD_INSURANCEHOLDERTYPHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSURANCEHOLDERTYPHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INSURANCEHOLDERTYPEHISTORY ADD (
  CONSTRAINT FKSTD_INSRNCHLDRTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_INSURANCEHOLDERTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSURANCEHOLDERTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSURANCEHOLDERTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSURANCEHOLDERTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(1 BYTE)                 NOT NULL,
  NAME         VARCHAR2(40 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSURANCEHOLDERTYPE ON SDSADM.STD_INSURANCEHOLDERTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSURANCEHOLDERTYPECODE ON SDSADM.STD_INSURANCEHOLDERTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSURANCEHOLDERTYPENAME ON SDSADM.STD_INSURANCEHOLDERTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InsuranceHolderType
after DELETE
ON SDSADM.STD_INSURANCEHOLDERTYPE
BEGIN
	-- update the table for STD_InsuranceHolderType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceHolderType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InsuranceHolderType
after INSERT
ON SDSADM.STD_INSURANCEHOLDERTYPE
BEGIN
	-- update the table for STD_InsuranceHolderType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceHolderType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InsuranceHolderType
after UPDATE
ON SDSADM.STD_INSURANCEHOLDERTYPE
BEGIN
	-- update the table for STD_InsuranceHolderType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsuranceHolderType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSURANCEHOLDERTYPE FOR SDSADM.STD_INSURANCEHOLDERTYPE;


ALTER TABLE SDSADM.STD_INSURANCEHOLDERTYPE ADD (
  CONSTRAINT PK_STD_INSURANCEHOLDERTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSURANCEHOLDERTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSURANCEHOLDERTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_INSURANCEHOLDERTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSURANCEHOLDERTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_INSURANCEHOLDERTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSURANCEHOLDERTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSURANCEHOLDERTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSURANCEHOLDERTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSURANCEHOLDERTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSTITUTIONCODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSTITUTIONCODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSTITUTIONCODE
(
  ID               NUMBER(20)                   NOT NULL,
  INSTITUTION_ID   NUMBER(20)                   NOT NULL,
  CODINGSYSTEM_ID  NUMBER(20)                   NOT NULL,
  CODEVALUE        VARCHAR2(20 BYTE)            NOT NULL,
  VERSION          INTEGER                      NOT NULL,
  CREATED          TIMESTAMP(6)                 NOT NULL,
  UPDATED          TIMESTAMP(6),
  CREATEDBY        VARCHAR2(32 BYTE)            NOT NULL,
  UPDATEDBY        VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSTCD ON SDSADM.STD_INSTITUTIONCODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSTCDCODEVALUE ON SDSADM.STD_INSTITUTIONCODE
(CODEVALUE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InstCd
after DELETE
ON SDSADM.STD_INSTITUTIONCODE
BEGIN
	-- update the table for STD_InstitutionCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InstitutionCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InstCd
after INSERT
ON SDSADM.STD_INSTITUTIONCODE
BEGIN
	-- update the table for STD_InstitutionCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InstitutionCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InstCd
after UPDATE
ON SDSADM.STD_INSTITUTIONCODE
BEGIN
	-- update the table for STD_InstitutionCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InstitutionCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSTITUTIONCODE FOR SDSADM.STD_INSTITUTIONCODE;


ALTER TABLE SDSADM.STD_INSTITUTIONCODE ADD (
  CONSTRAINT PK_STD_INSTCD
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSTCD
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSTCDCODEVALUE
  UNIQUE (CODEVALUE)
  USING INDEX SDSADM.UQSTD_INSTCDCODEVALUE
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INSTITUTIONCODE ADD (
  CONSTRAINT FKSTD_INSTCDCODINGSYSTEM 
  FOREIGN KEY (CODINGSYSTEM_ID) 
  REFERENCES SDSADM.STD_CODINGSYSTEM (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FKSTD_INSTCDINSTITUTION 
  FOREIGN KEY (INSTITUTION_ID) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSTITUTIONCODE TO ADR;

GRANT SELECT ON SDSADM.STD_INSTITUTIONCODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSTITUTIONCODE TO EESRV;

GRANT SELECT ON SDSADM.STD_INSTITUTIONCODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSTITUTIONCODE TO LOBR;

GRANT SELECT ON SDSADM.STD_INSTITUTIONCODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSTITUTIONCODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSTITUTIONCODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSTITUTIONCODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSTITUTION
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSTITUTION CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSTITUTION
(
  ID                   NUMBER(20)               NOT NULL,
  ACTIVATIONDATE       DATE,
  DEACTIVATIONDATE     DATE,
  NAME                 VARCHAR2(80 BYTE)        NOT NULL,
  STATIONNUMBER        VARCHAR2(7 BYTE),
  VISTANAME            VARCHAR2(30 BYTE)        NOT NULL,
  AGENCY_ID            NUMBER(20),
  STREETCOUNTRY_ID     NUMBER(20),
  STREETADDRESSLINE1   VARCHAR2(64 BYTE),
  STREETADDRESSLINE2   VARCHAR2(64 BYTE),
  STREETADDRESSLINE3   VARCHAR2(64 BYTE),
  STREETCITY           VARCHAR2(50 BYTE),
  STREETSTATE_ID       NUMBER(20),
  STREETCOUNTY_ID      NUMBER(20),
  STREETPOSTALCODE     VARCHAR2(10 BYTE),
  MAILINGCOUNTRY_ID    NUMBER(20),
  MAILINGADDRESSLINE1  VARCHAR2(64 BYTE),
  MAILINGADDRESSLINE2  VARCHAR2(64 BYTE),
  MAILINGADDRESSLINE3  VARCHAR2(64 BYTE),
  MAILINGCITY          VARCHAR2(50 BYTE),
  MAILINGSTATE_ID      NUMBER(20),
  MAILINGCOUNTY_ID     NUMBER(20),
  MAILINGPOSTALCODE    VARCHAR2(10 BYTE),
  FACILITYTYPE_ID      NUMBER(20)               NOT NULL,
  MFN_ZEG_RECIPIENT    CHAR(1 BYTE)             NOT NULL,
  PARENT_ID            NUMBER(20),
  REALIGNEDFROM_ID     NUMBER(20),
  REALIGNEDTO_ID       NUMBER(20),
  VISN_ID              NUMBER(20),
  VERSION              INTEGER                  NOT NULL,
  CREATED              TIMESTAMP(6)             NOT NULL,
  UPDATED              TIMESTAMP(6),
  CREATEDBY            VARCHAR2(32 BYTE)        NOT NULL,
  UPDATEDBY            VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          640K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INST ON SDSADM.STD_INSTITUTION
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INSTSTATIONNUMBER ON SDSADM.STD_INSTITUTION
(STATIONNUMBER)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.DEL4_STD_INST
after DELETE
ON SDSADM.STD_INSTITUTION
BEGIN
	-- update the table for STD_Institution operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Institution';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.INS4_STD_INST
after INSERT
ON SDSADM.STD_INSTITUTION
BEGIN
	-- update the table for STD_Institution operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Institution';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.UPD4_STD_INST
after UPDATE
ON SDSADM.STD_INSTITUTION
BEGIN
	-- update the table for STD_Institution operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_Institution';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSTITUTION FOR SDSADM.STD_INSTITUTION;


ALTER TABLE SDSADM.STD_INSTITUTION ADD (
  CONSTRAINT PK_STD_INST
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INST
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INSTSTATIONNUMBER
  UNIQUE (STATIONNUMBER)
  USING INDEX SDSADM.UQSTD_INSTSTATIONNUMBER
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INSTITUTION ADD (
  CONSTRAINT FKSTD_INSTPARENT 
  FOREIGN KEY (PARENT_ID) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FKSTD_INSTREALIGNEDFROM 
  FOREIGN KEY (REALIGNEDFROM_ID) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FKSTD_INSTREALIGNEDTO 
  FOREIGN KEY (REALIGNEDTO_ID) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT FKSTD_INSTVISN 
  FOREIGN KEY (VISN_ID) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON SDSADM.STD_INSTITUTION TO ADR;

GRANT SELECT ON SDSADM.STD_INSTITUTION TO ADREXT;

GRANT REFERENCES, SELECT ON SDSADM.STD_INSTITUTION TO EESRV;

GRANT SELECT ON SDSADM.STD_INSTITUTION TO EEUSR WITH GRANT OPTION;

GRANT SELECT ON SDSADM.STD_INSTITUTION TO IAM_R;

GRANT SELECT ON SDSADM.STD_INSTITUTION TO IAM_RW;

GRANT REFERENCES ON SDSADM.STD_INSTITUTION TO LOBR;

GRANT REFERENCES, SELECT ON SDSADM.STD_INSTITUTION TO PATS;

GRANT REFERENCES, SELECT ON SDSADM.STD_INSTITUTION TO PATSRPTS;

GRANT REFERENCES, SELECT ON SDSADM.STD_INSTITUTION TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSTITUTION TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSTITUTION TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSTITUTION TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSRPRTSRCHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSRPRTSRCHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSRPRTSRCHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSRPRTSRCHISTORY ON SDSADM.STD_INSRPRTSRCHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InsRprtSrcHistory
after DELETE
ON SDSADM.STD_INSRPRTSRCHISTORY
BEGIN
	-- update the table for STD_InsRprtSrcHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsRprtSrcHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InsRprtSrcHistory
after INSERT
ON SDSADM.STD_INSRPRTSRCHISTORY
BEGIN
	-- update the table for STD_InsRprtSrcHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsRprtSrcHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InsRprtSrcHistory
after UPDATE
ON SDSADM.STD_INSRPRTSRCHISTORY
BEGIN
	-- update the table for STD_InsRprtSrcHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsRprtSrcHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSRPRTSRCHISTORY FOR SDSADM.STD_INSRPRTSRCHISTORY;


ALTER TABLE SDSADM.STD_INSRPRTSRCHISTORY ADD (
  CONSTRAINT PK_STD_INSRPRTSRCHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSRPRTSRCHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INSRPRTSRCHISTORY ADD (
  CONSTRAINT FKSTD_INSRPRTSRCHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_INSURANCEREPORTSOURCE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSRPRTSRCHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_INSRPRTSRCHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSRPRTSRCHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_INSRPRTSRCHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSRPRTSRCHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_INSRPRTSRCHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSRPRTSRCHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSRPRTSRCHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSRPRTSRCHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INSPLANTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INSPLANTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INSPLANTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INSPLANTYPEHISTORY ON SDSADM.STD_INSPLANTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_InsPlanTypeHistory
after DELETE
ON SDSADM.STD_INSPLANTYPEHISTORY
BEGIN
	-- update the table for STD_InsPlanTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsPlanTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_InsPlanTypeHistory
after INSERT
ON SDSADM.STD_INSPLANTYPEHISTORY
BEGIN
	-- update the table for STD_InsPlanTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsPlanTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_InsPlanTypeHistory
after UPDATE
ON SDSADM.STD_INSPLANTYPEHISTORY
BEGIN
	-- update the table for STD_InsPlanTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_InsPlanTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INSPLANTYPEHISTORY FOR SDSADM.STD_INSPLANTYPEHISTORY;


ALTER TABLE SDSADM.STD_INSPLANTYPEHISTORY ADD (
  CONSTRAINT PK_STD_INSPLANTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INSPLANTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INSPLANTYPEHISTORY ADD (
  CONSTRAINT FKSTD_INSPLANTYPEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_INSURANCEPLANTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INSPLANTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_INSPLANTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_INSPLANTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_INSPLANTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INSPLANTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_INSPLANTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INSPLANTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INSPLANTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INSPLANTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INCOMEVERIFSTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INCOMEVERIFSTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INCOMEVERIFSTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INCOMEVERIFSTATUSHSTRY ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IncomeVerifSttsHstry
after DELETE
ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY
BEGIN
	-- update the table for STD_IncomeVerifStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeVerifStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IncomeVerifSttsHstry
after INSERT
ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY
BEGIN
	-- update the table for STD_IncomeVerifStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeVerifStatusHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IncomeVerifSttsHstry
after UPDATE
ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY
BEGIN
	-- update the table for STD_IncomeVerifStatusHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeVerifStatusHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INCOMEVERIFSTATUSHISTORY FOR SDSADM.STD_INCOMEVERIFSTATUSHISTORY;


ALTER TABLE SDSADM.STD_INCOMEVERIFSTATUSHISTORY ADD (
  CONSTRAINT PK_STD_INCOMEVERIFSTATUSHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INCOMEVERIFSTATUSHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INCOMEVERIFSTATUSHISTORY ADD (
  CONSTRAINT FKSTD_INCOMEVERIFSTTSHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_INCOMEVERIFSTATUS (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUSHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INCOMEVERIFSTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INCOMEVERIFSTATUS CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INCOMEVERIFSTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(40 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INCOMEVERIFSTATUS ON SDSADM.STD_INCOMEVERIFSTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INCOMEVERIFSTATUSCODE ON SDSADM.STD_INCOMEVERIFSTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INCOMEVERIFSTATUSNAME ON SDSADM.STD_INCOMEVERIFSTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IncomeVerifStatus
after DELETE
ON SDSADM.STD_INCOMEVERIFSTATUS
BEGIN
	-- update the table for STD_IncomeVerifStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeVerifStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IncomeVerifStatus
after INSERT
ON SDSADM.STD_INCOMEVERIFSTATUS
BEGIN
	-- update the table for STD_IncomeVerifStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeVerifStatus';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IncomeVerifStatus
after UPDATE
ON SDSADM.STD_INCOMEVERIFSTATUS
BEGIN
	-- update the table for STD_IncomeVerifStatus operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeVerifStatus';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INCOMEVERIFSTATUS FOR SDSADM.STD_INCOMEVERIFSTATUS;


ALTER TABLE SDSADM.STD_INCOMEVERIFSTATUS ADD (
  CONSTRAINT PK_STD_INCOMEVERIFSTATUS
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INCOMEVERIFSTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INCOMEVERIFSTATUSCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_INCOMEVERIFSTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INCOMEVERIFSTATUSNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_INCOMEVERIFSTATUSNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INCOMEVERIFSTATUS TO ADR;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUS TO ADREXT;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUS TO EESRV;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUS TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INCOMEVERIFSTATUS TO LOBR;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUS TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMEVERIFSTATUS TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUS TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INCOMEVERIFSTATUS TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INCOMETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INCOMETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INCOMETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INCOMETYPEHISTORY ON SDSADM.STD_INCOMETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IncomeTypeHistory
after DELETE
ON SDSADM.STD_INCOMETYPEHISTORY
BEGIN
	-- update the table for STD_IncomeTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IncomeTypeHistory
after INSERT
ON SDSADM.STD_INCOMETYPEHISTORY
BEGIN
	-- update the table for STD_IncomeTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IncomeTypeHistory
after UPDATE
ON SDSADM.STD_INCOMETYPEHISTORY
BEGIN
	-- update the table for STD_IncomeTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INCOMETYPEHISTORY FOR SDSADM.STD_INCOMETYPEHISTORY;


ALTER TABLE SDSADM.STD_INCOMETYPEHISTORY ADD (
  CONSTRAINT PK_STD_INCOMETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INCOMETYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INCOMETYPEHISTORY ADD (
  CONSTRAINT FKSTD_INCOMETYPEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_INCOMETYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INCOMETYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_INCOMETYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_INCOMETYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_INCOMETYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INCOMETYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_INCOMETYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INCOMETYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INCOMETYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INCOMETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INCOMETYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INCOMETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INCOMETYPE ON SDSADM.STD_INCOMETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INCOMETYPECODE ON SDSADM.STD_INCOMETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INCOMETYPENAME ON SDSADM.STD_INCOMETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IncomeType
after DELETE
ON SDSADM.STD_INCOMETYPE
BEGIN
	-- update the table for STD_IncomeType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IncomeType
after INSERT
ON SDSADM.STD_INCOMETYPE
BEGIN
	-- update the table for STD_IncomeType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IncomeType
after UPDATE
ON SDSADM.STD_INCOMETYPE
BEGIN
	-- update the table for STD_IncomeType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INCOMETYPE FOR SDSADM.STD_INCOMETYPE;


ALTER TABLE SDSADM.STD_INCOMETYPE ADD (
  CONSTRAINT PK_STD_INCOMETYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INCOMETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INCOMETYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_INCOMETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INCOMETYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_INCOMETYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INCOMETYPE TO ADR;

GRANT SELECT ON SDSADM.STD_INCOMETYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_INCOMETYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_INCOMETYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INCOMETYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_INCOMETYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INCOMETYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INCOMETYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INCOMETHRESHOLDHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INCOMETHRESHOLDHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INCOMETHRESHOLDHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INCOMETHRESHOLDHISTORY ON SDSADM.STD_INCOMETHRESHOLDHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IncomeThresholdHstry
after DELETE
ON SDSADM.STD_INCOMETHRESHOLDHISTORY
BEGIN
	-- update the table for STD_IncomeThresholdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeThresholdHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IncomeThresholdHstry
after INSERT
ON SDSADM.STD_INCOMETHRESHOLDHISTORY
BEGIN
	-- update the table for STD_IncomeThresholdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeThresholdHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IncomeThresholdHstry
after UPDATE
ON SDSADM.STD_INCOMETHRESHOLDHISTORY
BEGIN
	-- update the table for STD_IncomeThresholdHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeThresholdHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INCOMETHRESHOLDHISTORY FOR SDSADM.STD_INCOMETHRESHOLDHISTORY;


ALTER TABLE SDSADM.STD_INCOMETHRESHOLDHISTORY ADD (
  CONSTRAINT PK_STD_INCOMETHRESHOLDHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INCOMETHRESHOLDHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INCOMETHRESHOLDHISTORY ADD (
  CONSTRAINT FKSTD_INCOMETHRESHOLDHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_INCOMETHRESHOLD (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLDHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INCOMETHRESHOLD
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INCOMETHRESHOLD CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INCOMETHRESHOLD
(
  ID                            NUMBER(20)      NOT NULL,
  INCOME_THRESHOLD_YEAR         NUMBER(4)       NOT NULL,
  EXEMPT_AMOUNT                 NUMBER(10,2),
  MEDICAL_EXPENSE_DEDUCTIBLE    NUMBER(10,2),
  CHILD_INCOME_EXCLUSION        NUMBER(10,2),
  DEPENDENT                     NUMBER(10,2),
  ADD_DEPENDENT_THRESHOLD       NUMBER(10,2),
  PROPERTY_THRESHOLD            NUMBER(10,2),
  PENSION_THRESHOLD             NUMBER(10,2),
  PENSION_1_DEPENDENT           NUMBER(10,2),
  ADD_DEPENDENT_PENSION         NUMBER(10,2),
  NINETY_DAY_HOSPITAL_COPAY     NUMBER(10,2),
  ADD_90_DAY_HOSPITAL_COPAY     NUMBER(10,2),
  OUTPATIENT_BASIC_CARE_COPAY   NUMBER(10,2),
  OUTPATIENT_SPECIALTY_COPAY    NUMBER(10,2),
  THRESHOLD_EFFECTIVE_DATE      DATE,
  AID_AND_ATTENDANCE_THRESHOLD  NUMBER(10,2),
  OUTPATIENT_PREVENTIVE_COPAY   NUMBER(10,2),
  MEDICATION_COPAY              NUMBER(10,2),
  MEDICATION_COPAY_ANNUAL_CAP   NUMBER(10,2),
  LTC_INPATIENT_COPAY           NUMBER(10,2),
  LTC_OUTPATIENT_COPAY          NUMBER(10,2),
  LTC_DOMICILIARY_COPAY         NUMBER(10,2),
  INPATIENT_PER_DIEM            NUMBER(10,2),
  DESCRIPTION                   VARCHAR2(2000 BYTE),
  VERSION                       INTEGER         NOT NULL,
  CREATED                       TIMESTAMP(6)    NOT NULL,
  UPDATED                       TIMESTAMP(6),
  CREATEDBY                     VARCHAR2(32 BYTE) NOT NULL,
  UPDATEDBY                     VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INCOMETHRESHOLD ON SDSADM.STD_INCOMETHRESHOLD
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IncomeThreshold
after DELETE
ON SDSADM.STD_INCOMETHRESHOLD
BEGIN
	-- update the table for STD_IncomeThreshold operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeThreshold';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IncomeThreshold
after INSERT
ON SDSADM.STD_INCOMETHRESHOLD
BEGIN
	-- update the table for STD_IncomeThreshold operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeThreshold';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IncomeThreshold
after UPDATE
ON SDSADM.STD_INCOMETHRESHOLD
BEGIN
	-- update the table for STD_IncomeThreshold operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeThreshold';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INCOMETHRESHOLD FOR SDSADM.STD_INCOMETHRESHOLD;


ALTER TABLE SDSADM.STD_INCOMETHRESHOLD ADD (
  CONSTRAINT PK_STD_INCOMETHRESHOLD
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INCOMETHRESHOLD
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INCOMETHRESHOLD TO ADR;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLD TO ADREXT;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLD TO EESRV;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLD TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INCOMETHRESHOLD TO LOBR;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLD TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETHRESHOLD TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLD TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INCOMETHRESHOLD TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INCOMETESTTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INCOMETESTTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INCOMETESTTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INCOMETESTTYPEHISTORY ON SDSADM.STD_INCOMETESTTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IncomeTestTypeHistory
after DELETE
ON SDSADM.STD_INCOMETESTTYPEHISTORY
BEGIN
	-- update the table for STD_IncomeTestTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IncomeTestTypeHistory
after INSERT
ON SDSADM.STD_INCOMETESTTYPEHISTORY
BEGIN
	-- update the table for STD_IncomeTestTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IncomeTestTypeHistory
after UPDATE
ON SDSADM.STD_INCOMETESTTYPEHISTORY
BEGIN
	-- update the table for STD_IncomeTestTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INCOMETESTTYPEHISTORY FOR SDSADM.STD_INCOMETESTTYPEHISTORY;


ALTER TABLE SDSADM.STD_INCOMETESTTYPEHISTORY ADD (
  CONSTRAINT PK_STD_INCOMETESTTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INCOMETESTTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INCOMETESTTYPEHISTORY ADD (
  CONSTRAINT FKSTD_INCOMETESTTYPEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_INCOMETESTTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INCOMETESTTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INCOMETESTTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETESTTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INCOMETESTTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INCOMETESTTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INCOMETESTTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INCOMETESTTYPE ON SDSADM.STD_INCOMETESTTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INCOMETESTTYPECODE ON SDSADM.STD_INCOMETESTTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INCOMETESTTYPENAME ON SDSADM.STD_INCOMETESTTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IncomeTestType
after DELETE
ON SDSADM.STD_INCOMETESTTYPE
BEGIN
	-- update the table for STD_IncomeTestType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IncomeTestType
after INSERT
ON SDSADM.STD_INCOMETESTTYPE
BEGIN
	-- update the table for STD_IncomeTestType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IncomeTestType
after UPDATE
ON SDSADM.STD_INCOMETESTTYPE
BEGIN
	-- update the table for STD_IncomeTestType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INCOMETESTTYPE FOR SDSADM.STD_INCOMETESTTYPE;


ALTER TABLE SDSADM.STD_INCOMETESTTYPE ADD (
  CONSTRAINT PK_STD_INCOMETESTTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INCOMETESTTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INCOMETESTTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_INCOMETESTTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INCOMETESTTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_INCOMETESTTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INCOMETESTTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INCOMETESTTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETESTTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INCOMETESTTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INCOMETESTSOURCEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INCOMETESTSOURCEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INCOMETESTSOURCEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INCOMETESTSOURCEHISTORY ON SDSADM.STD_INCOMETESTSOURCEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IncomeTestSourceHstry
after DELETE
ON SDSADM.STD_INCOMETESTSOURCEHISTORY
BEGIN
	-- update the table for STD_IncomeTestSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestSourceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IncomeTestSourceHstry
after INSERT
ON SDSADM.STD_INCOMETESTSOURCEHISTORY
BEGIN
	-- update the table for STD_IncomeTestSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestSourceHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IncomeTestSourceHstry
after UPDATE
ON SDSADM.STD_INCOMETESTSOURCEHISTORY
BEGIN
	-- update the table for STD_IncomeTestSourceHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestSourceHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INCOMETESTSOURCEHISTORY FOR SDSADM.STD_INCOMETESTSOURCEHISTORY;


ALTER TABLE SDSADM.STD_INCOMETESTSOURCEHISTORY ADD (
  CONSTRAINT PK_STD_INCOMETESTSOURCEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INCOMETESTSOURCEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_INCOMETESTSOURCEHISTORY ADD (
  CONSTRAINT FKSTD_INCOMETESTSRCHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_INCOMETESTSOURCE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_INCOMETESTSOURCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_INCOMETESTSOURCE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_INCOMETESTSOURCE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_INCOMETESTSOURCE ON SDSADM.STD_INCOMETESTSOURCE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_INCOMETESTSOURCECODE ON SDSADM.STD_INCOMETESTSOURCE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IncomeTestSource
after DELETE
ON SDSADM.STD_INCOMETESTSOURCE
BEGIN
	-- update the table for STD_IncomeTestSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IncomeTestSource
after INSERT
ON SDSADM.STD_INCOMETESTSOURCE
BEGIN
	-- update the table for STD_IncomeTestSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestSource';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IncomeTestSource
after UPDATE
ON SDSADM.STD_INCOMETESTSOURCE
BEGIN
	-- update the table for STD_IncomeTestSource operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IncomeTestSource';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_INCOMETESTSOURCE FOR SDSADM.STD_INCOMETESTSOURCE;


ALTER TABLE SDSADM.STD_INCOMETESTSOURCE ADD (
  CONSTRAINT PK_STD_INCOMETESTSOURCE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_INCOMETESTSOURCE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_INCOMETESTSOURCECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_INCOMETESTSOURCECODE
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_INCOMETESTSOURCE TO ADR;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCE TO ADREXT;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCE TO EESRV;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_INCOMETESTSOURCE TO LOBR;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_INCOMETESTSOURCE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_INCOMETESTSOURCE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IDTASKSTATUSTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IDTASKSTATUSTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IDTASKSTATUSTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IDTASKSTATUSTYPEHISTORY ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IdTaskStatusTypeHstry
after DELETE
ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY
BEGIN
	-- update the table for STD_IdTaskStatusTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskStatusTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IdTaskStatusTypeHstry
after INSERT
ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY
BEGIN
	-- update the table for STD_IdTaskStatusTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskStatusTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IdTaskStatusTypeHstry
after UPDATE
ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY
BEGIN
	-- update the table for STD_IdTaskStatusTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskStatusTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IDTASKSTATUSTYPEHISTORY FOR SDSADM.STD_IDTASKSTATUSTYPEHISTORY;


ALTER TABLE SDSADM.STD_IDTASKSTATUSTYPEHISTORY ADD (
  CONSTRAINT PK_STD_IDTASKSTATUSTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IDTASKSTATUSTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_IDTASKSTATUSTYPEHISTORY ADD (
  CONSTRAINT FKSTD_IDTASKSTATUSTYPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_IDTASKSTATUSTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IDTASKSTATUSTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IDTASKSTATUSTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IDTASKSTATUSTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(20 BYTE)                NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IDTASKSTATUSTYPE ON SDSADM.STD_IDTASKSTATUSTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IDTASKSTATUSTYPECODE ON SDSADM.STD_IDTASKSTATUSTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IDTASKSTATUSTYPENAME ON SDSADM.STD_IDTASKSTATUSTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IdTaskStatusType
after DELETE
ON SDSADM.STD_IDTASKSTATUSTYPE
BEGIN
	-- update the table for STD_IdTaskStatusType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskStatusType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IdTaskStatusType
after INSERT
ON SDSADM.STD_IDTASKSTATUSTYPE
BEGIN
	-- update the table for STD_IdTaskStatusType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskStatusType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IdTaskStatusType
after UPDATE
ON SDSADM.STD_IDTASKSTATUSTYPE
BEGIN
	-- update the table for STD_IdTaskStatusType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskStatusType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IDTASKSTATUSTYPE FOR SDSADM.STD_IDTASKSTATUSTYPE;


ALTER TABLE SDSADM.STD_IDTASKSTATUSTYPE ADD (
  CONSTRAINT PK_STD_IDTASKSTATUSTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IDTASKSTATUSTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IDTASKSTATUSTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_IDTASKSTATUSTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IDTASKSTATUSTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_IDTASKSTATUSTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IDTASKSTATUSTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IDTASKSTATUSTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDTASKSTATUSTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IDTASKSTATUSTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IDTASKPROBCATEGORYHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IDTASKPROBCATEGORYHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IDTASKPROBCATEGORYHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IDTASKPROBCATEGORYHSTRY ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IdTaskProbCtgryHstry
after DELETE
ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY
BEGIN
	-- update the table for STD_IdTaskProbCategoryHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskProbCategoryHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IdTaskProbCtgryHstry
after INSERT
ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY
BEGIN
	-- update the table for STD_IdTaskProbCategoryHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskProbCategoryHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IdTaskProbCtgryHstry
after UPDATE
ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY
BEGIN
	-- update the table for STD_IdTaskProbCategoryHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskProbCategoryHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IDTASKPROBCATEGORYHISTORY FOR SDSADM.STD_IDTASKPROBCATEGORYHISTORY;


ALTER TABLE SDSADM.STD_IDTASKPROBCATEGORYHISTORY ADD (
  CONSTRAINT PK_STD_IDTASKPROBCATEGORYHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IDTASKPROBCATEGORYHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_IDTASKPROBCATEGORYHISTORY ADD (
  CONSTRAINT FKSTD_IDTASKPROBCTGRYHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_IDTASKPROBCATEGORY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORYHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IDTASKPROBCATEGORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IDTASKPROBCATEGORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IDTASKPROBCATEGORY
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(20 BYTE)                NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IDTASKPROBCATEGORY ON SDSADM.STD_IDTASKPROBCATEGORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IDTASKPROBCATEGORYCODE ON SDSADM.STD_IDTASKPROBCATEGORY
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IDTASKPROBCATEGORYNAME ON SDSADM.STD_IDTASKPROBCATEGORY
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IdTaskProbCategory
after DELETE
ON SDSADM.STD_IDTASKPROBCATEGORY
BEGIN
	-- update the table for STD_IdTaskProbCategory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskProbCategory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IdTaskProbCategory
after INSERT
ON SDSADM.STD_IDTASKPROBCATEGORY
BEGIN
	-- update the table for STD_IdTaskProbCategory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskProbCategory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IdTaskProbCategory
after UPDATE
ON SDSADM.STD_IDTASKPROBCATEGORY
BEGIN
	-- update the table for STD_IdTaskProbCategory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdTaskProbCategory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IDTASKPROBCATEGORY FOR SDSADM.STD_IDTASKPROBCATEGORY;


ALTER TABLE SDSADM.STD_IDTASKPROBCATEGORY ADD (
  CONSTRAINT PK_STD_IDTASKPROBCATEGORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IDTASKPROBCATEGORY
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IDTASKPROBCATEGORYCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_IDTASKPROBCATEGORYCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IDTASKPROBCATEGORYNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_IDTASKPROBCATEGORYNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IDTASKPROBCATEGORY TO ADR;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORY TO EESRV;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IDTASKPROBCATEGORY TO LOBR;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDTASKPROBCATEGORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IDTASKPROBCATEGORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IDEXCEPTYPEGROUPHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IDEXCEPTYPEGROUPHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IDEXCEPTYPEGROUPHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IDEXCEPTYPEGROUPHISTORY ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IdExcepTypeGroupHstry
after DELETE
ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY
BEGIN
	-- update the table for STD_IdExcepTypeGroupHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdExcepTypeGroupHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IdExcepTypeGroupHstry
after INSERT
ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY
BEGIN
	-- update the table for STD_IdExcepTypeGroupHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdExcepTypeGroupHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IdExcepTypeGroupHstry
after UPDATE
ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY
BEGIN
	-- update the table for STD_IdExcepTypeGroupHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdExcepTypeGroupHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IDEXCEPTYPEGROUPHISTORY FOR SDSADM.STD_IDEXCEPTYPEGROUPHISTORY;


ALTER TABLE SDSADM.STD_IDEXCEPTYPEGROUPHISTORY ADD (
  CONSTRAINT PK_STD_IDEXCEPTYPEGROUPHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IDEXCEPTYPEGROUPHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_IDEXCEPTYPEGROUPHISTORY ADD (
  CONSTRAINT FKSTD_IDEXCEPTYPEGRPHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_IDEXCEPTYPEGROUP (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUPHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IDEXCEPTYPEGROUP
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IDEXCEPTYPEGROUP CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IDEXCEPTYPEGROUP
(
  ID               NUMBER(20)                   NOT NULL,
  NAME             VARCHAR2(50 BYTE)            NOT NULL,
  CREATE_TASK_IND  NUMBER(10)                   NOT NULL,
  DESCRIPTION      VARCHAR2(60 BYTE),
  VERSION          INTEGER                      NOT NULL,
  CREATED          TIMESTAMP(6)                 NOT NULL,
  UPDATED          TIMESTAMP(6),
  CREATEDBY        VARCHAR2(32 BYTE)            NOT NULL,
  UPDATEDBY        VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IDEXCEPTYPEGROUP ON SDSADM.STD_IDEXCEPTYPEGROUP
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IDEXCEPTYPEGROUPNAME ON SDSADM.STD_IDEXCEPTYPEGROUP
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IDEXCEPTYPEGRPCRT_TSK_ND ON SDSADM.STD_IDEXCEPTYPEGROUP
(CREATE_TASK_IND)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IdExcepTypeGroup
after DELETE
ON SDSADM.STD_IDEXCEPTYPEGROUP
BEGIN
	-- update the table for STD_IdExcepTypeGroup operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdExcepTypeGroup';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IdExcepTypeGroup
after INSERT
ON SDSADM.STD_IDEXCEPTYPEGROUP
BEGIN
	-- update the table for STD_IdExcepTypeGroup operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdExcepTypeGroup';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IdExcepTypeGroup
after UPDATE
ON SDSADM.STD_IDEXCEPTYPEGROUP
BEGIN
	-- update the table for STD_IdExcepTypeGroup operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdExcepTypeGroup';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IDEXCEPTYPEGROUP FOR SDSADM.STD_IDEXCEPTYPEGROUP;


ALTER TABLE SDSADM.STD_IDEXCEPTYPEGROUP ADD (
  CONSTRAINT PK_STD_IDEXCEPTYPEGROUP
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IDEXCEPTYPEGROUP
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IDEXCEPTYPEGROUPNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_IDEXCEPTYPEGROUPNAME
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IDEXCEPTYPEGRPCRT_TSK_ND
  UNIQUE (CREATE_TASK_IND)
  USING INDEX SDSADM.UQSTD_IDEXCEPTYPEGRPCRT_TSK_ND
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IDEXCEPTYPEGROUP TO ADR;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUP TO ADREXT;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUP TO EESRV;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUP TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IDEXCEPTYPEGROUP TO LOBR;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUP TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDEXCEPTYPEGROUP TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUP TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IDEXCEPTYPEGROUP TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IDEVENTTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IDEVENTTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IDEVENTTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IDEVENTTYPEHISTORY ON SDSADM.STD_IDEVENTTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IdEventTypeHistory
after DELETE
ON SDSADM.STD_IDEVENTTYPEHISTORY
BEGIN
	-- update the table for STD_IdEventTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdEventTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IdEventTypeHistory
after INSERT
ON SDSADM.STD_IDEVENTTYPEHISTORY
BEGIN
	-- update the table for STD_IdEventTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdEventTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IdEventTypeHistory
after UPDATE
ON SDSADM.STD_IDEVENTTYPEHISTORY
BEGIN
	-- update the table for STD_IdEventTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdEventTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IDEVENTTYPEHISTORY FOR SDSADM.STD_IDEVENTTYPEHISTORY;


ALTER TABLE SDSADM.STD_IDEVENTTYPEHISTORY ADD (
  CONSTRAINT PK_STD_IDEVENTTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IDEVENTTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_IDEVENTTYPEHISTORY ADD (
  CONSTRAINT FKSTD_IDEVENTTYPEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_IDEVENTTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IDEVENTTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IDEVENTTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDEVENTTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IDEVENTTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IDEVENTTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IDEVENTTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(20 BYTE)                NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IDEVENTTYPE ON SDSADM.STD_IDEVENTTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IDEVENTTYPECODE ON SDSADM.STD_IDEVENTTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IDEVENTTYPENAME ON SDSADM.STD_IDEVENTTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IdEventType
after DELETE
ON SDSADM.STD_IDEVENTTYPE
BEGIN
	-- update the table for STD_IdEventType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdEventType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IdEventType
after INSERT
ON SDSADM.STD_IDEVENTTYPE
BEGIN
	-- update the table for STD_IdEventType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdEventType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IdEventType
after UPDATE
ON SDSADM.STD_IDEVENTTYPE
BEGIN
	-- update the table for STD_IdEventType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdEventType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IDEVENTTYPE FOR SDSADM.STD_IDEVENTTYPE;


ALTER TABLE SDSADM.STD_IDEVENTTYPE ADD (
  CONSTRAINT PK_STD_IDEVENTTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IDEVENTTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IDEVENTTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_IDEVENTTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IDEVENTTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_IDEVENTTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IDEVENTTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IDEVENTTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDEVENTTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IDEVENTTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IDENTIFIERTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IDENTIFIERTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IDENTIFIERTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IDENTIFIERTYPEHISTORY ON SDSADM.STD_IDENTIFIERTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IdentifierTypeHistory
after DELETE
ON SDSADM.STD_IDENTIFIERTYPEHISTORY
BEGIN
	-- update the table for STD_IdentifierTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdentifierTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IdentifierTypeHistory
after INSERT
ON SDSADM.STD_IDENTIFIERTYPEHISTORY
BEGIN
	-- update the table for STD_IdentifierTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdentifierTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IdentifierTypeHistory
after UPDATE
ON SDSADM.STD_IDENTIFIERTYPEHISTORY
BEGIN
	-- update the table for STD_IdentifierTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdentifierTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IDENTIFIERTYPEHISTORY FOR SDSADM.STD_IDENTIFIERTYPEHISTORY;


ALTER TABLE SDSADM.STD_IDENTIFIERTYPEHISTORY ADD (
  CONSTRAINT PK_STD_IDENTIFIERTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IDENTIFIERTYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_IDENTIFIERTYPEHISTORY ADD (
  CONSTRAINT FKSTD_IDENTIFIERTYPEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_IDENTIFIERTYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_IDENTIFIERTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_IDENTIFIERTYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_IDENTIFIERTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(5 BYTE)                 NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_IDENTIFIERTYPE ON SDSADM.STD_IDENTIFIERTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IDENTIFIERTYPECODE ON SDSADM.STD_IDENTIFIERTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_IDENTIFIERTYPENAME ON SDSADM.STD_IDENTIFIERTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_IdentifierType
after DELETE
ON SDSADM.STD_IDENTIFIERTYPE
BEGIN
	-- update the table for STD_IdentifierType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdentifierType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_IdentifierType
after INSERT
ON SDSADM.STD_IDENTIFIERTYPE
BEGIN
	-- update the table for STD_IdentifierType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdentifierType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_IdentifierType
after UPDATE
ON SDSADM.STD_IDENTIFIERTYPE
BEGIN
	-- update the table for STD_IdentifierType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_IdentifierType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_IDENTIFIERTYPE FOR SDSADM.STD_IDENTIFIERTYPE;


ALTER TABLE SDSADM.STD_IDENTIFIERTYPE ADD (
  CONSTRAINT PK_STD_IDENTIFIERTYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_IDENTIFIERTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IDENTIFIERTYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_IDENTIFIERTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_IDENTIFIERTYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_IDENTIFIERTYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_IDENTIFIERTYPE TO ADR;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_IDENTIFIERTYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_IDENTIFIERTYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_IDENTIFIERTYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7WHATSUBJECTFLTRHSTRY ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7WhatSbjctFltrHstry
after DELETE
ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY
BEGIN
	-- update the table for STD_HL7WhatSubjectFltrHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7WhatSubjectFltrHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7WhatSbjctFltrHstry
after INSERT
ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY
BEGIN
	-- update the table for STD_HL7WhatSubjectFltrHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7WhatSubjectFltrHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7WhatSbjctFltrHstry
after UPDATE
ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY
BEGIN
	-- update the table for STD_HL7WhatSubjectFltrHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7WhatSubjectFltrHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7WHATSUBJECTFLTRHISTORY FOR SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY;


ALTER TABLE SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY ADD (
  CONSTRAINT PK_STD_HL7WHATSUBJECTFLTRHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7WHATSUBJECTFLTRHSTRY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY ADD (
  CONSTRAINT FKSTD_HL7WHTSBJCTFLTRHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_HL7WHATSUBJECTFLTR (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTRHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7WHATSUBJECTFLTR
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7WHATSUBJECTFLTR CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7WHATSUBJECTFLTR
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(3 BYTE)                     NOT NULL,
  NAME         VARCHAR2(90 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7WHATSUBJECTFLTR ON SDSADM.STD_HL7WHATSUBJECTFLTR
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7WHATSUBJECTFLTRCODE ON SDSADM.STD_HL7WHATSUBJECTFLTR
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7WHATSUBJECTFLTRNAME ON SDSADM.STD_HL7WHATSUBJECTFLTR
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7WhatSubjectFltr
after DELETE
ON SDSADM.STD_HL7WHATSUBJECTFLTR
BEGIN
	-- update the table for STD_HL7WhatSubjectFltr operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7WhatSubjectFltr';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7WhatSubjectFltr
after INSERT
ON SDSADM.STD_HL7WHATSUBJECTFLTR
BEGIN
	-- update the table for STD_HL7WhatSubjectFltr operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7WhatSubjectFltr';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7WhatSubjectFltr
after UPDATE
ON SDSADM.STD_HL7WHATSUBJECTFLTR
BEGIN
	-- update the table for STD_HL7WhatSubjectFltr operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7WhatSubjectFltr';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7WHATSUBJECTFLTR FOR SDSADM.STD_HL7WHATSUBJECTFLTR;


ALTER TABLE SDSADM.STD_HL7WHATSUBJECTFLTR ADD (
  CONSTRAINT PK_STD_HL7WHATSUBJECTFLTR
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7WHATSUBJECTFLTR
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7WHATSUBJECTFLTRCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_HL7WHATSUBJECTFLTRCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7WHATSUBJECTFLTRNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_HL7WHATSUBJECTFLTRNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7WHATSUBJECTFLTR TO ADR;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTR TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTR TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTR TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7WHATSUBJECTFLTR TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTR TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7WHATSUBJECTFLTR TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTR TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7WHATSUBJECTFLTR TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7VERSIONIDHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7VERSIONIDHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7VERSIONIDHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7VERSIONIDHISTORY ON SDSADM.STD_HL7VERSIONIDHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7VersionIDHistory
after DELETE
ON SDSADM.STD_HL7VERSIONIDHISTORY
BEGIN
	-- update the table for STD_HL7VersionIDHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7VersionIDHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7VersionIDHistory
after INSERT
ON SDSADM.STD_HL7VERSIONIDHISTORY
BEGIN
	-- update the table for STD_HL7VersionIDHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7VersionIDHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7VersionIDHistory
after UPDATE
ON SDSADM.STD_HL7VERSIONIDHISTORY
BEGIN
	-- update the table for STD_HL7VersionIDHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7VersionIDHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7VERSIONIDHISTORY FOR SDSADM.STD_HL7VERSIONIDHISTORY;


ALTER TABLE SDSADM.STD_HL7VERSIONIDHISTORY ADD (
  CONSTRAINT PK_STD_HL7VERSIONIDHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7VERSIONIDHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_HL7VERSIONIDHISTORY ADD (
  CONSTRAINT FKSTD_HL7VERSIONIDHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_HL7VERSIONID (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7VERSIONIDHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_HL7VERSIONIDHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7VERSIONIDHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7VERSIONIDHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7VERSIONIDHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7VERSIONIDHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7VERSIONIDHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7VERSIONIDHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7VERSIONIDHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7VERSIONID
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7VERSIONID CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7VERSIONID
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(7 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7VERSIONID ON SDSADM.STD_HL7VERSIONID
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7VERSIONIDCODE ON SDSADM.STD_HL7VERSIONID
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7VERSIONIDNAME ON SDSADM.STD_HL7VERSIONID
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7VersionID
after DELETE
ON SDSADM.STD_HL7VERSIONID
BEGIN
	-- update the table for STD_HL7VersionID operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7VersionID';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7VersionID
after INSERT
ON SDSADM.STD_HL7VERSIONID
BEGIN
	-- update the table for STD_HL7VersionID operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7VersionID';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7VersionID
after UPDATE
ON SDSADM.STD_HL7VERSIONID
BEGIN
	-- update the table for STD_HL7VersionID operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7VersionID';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7VERSIONID FOR SDSADM.STD_HL7VERSIONID;


ALTER TABLE SDSADM.STD_HL7VERSIONID ADD (
  CONSTRAINT PK_STD_HL7VERSIONID
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7VERSIONID
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7VERSIONIDCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_HL7VERSIONIDCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7VERSIONIDNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_HL7VERSIONIDNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7VERSIONID TO ADR;

GRANT SELECT ON SDSADM.STD_HL7VERSIONID TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7VERSIONID TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7VERSIONID TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7VERSIONID TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7VERSIONID TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7VERSIONID TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7VERSIONID TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7VERSIONID TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7VALUETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7VALUETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7VALUETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7VALUETYPEHISTORY ON SDSADM.STD_HL7VALUETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7ValueTypeHistory
after DELETE
ON SDSADM.STD_HL7VALUETYPEHISTORY
BEGIN
	-- update the table for STD_HL7ValueTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7ValueTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7ValueTypeHistory
after INSERT
ON SDSADM.STD_HL7VALUETYPEHISTORY
BEGIN
	-- update the table for STD_HL7ValueTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7ValueTypeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7ValueTypeHistory
after UPDATE
ON SDSADM.STD_HL7VALUETYPEHISTORY
BEGIN
	-- update the table for STD_HL7ValueTypeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7ValueTypeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7VALUETYPEHISTORY FOR SDSADM.STD_HL7VALUETYPEHISTORY;


ALTER TABLE SDSADM.STD_HL7VALUETYPEHISTORY ADD (
  CONSTRAINT PK_STD_HL7VALUETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7VALUETYPEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_HL7VALUETYPEHISTORY ADD (
  CONSTRAINT FKSTD_HL7VALUETYPEHISTORYOWNER 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_HL7VALUETYPE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7VALUETYPEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7VALUETYPEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7VALUETYPEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7VALUETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7VALUETYPE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7VALUETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(60 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7VALUETYPE ON SDSADM.STD_HL7VALUETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7VALUETYPECODE ON SDSADM.STD_HL7VALUETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7VALUETYPENAME ON SDSADM.STD_HL7VALUETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7ValueType
after DELETE
ON SDSADM.STD_HL7VALUETYPE
BEGIN
	-- update the table for STD_HL7ValueType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7ValueType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7ValueType
after INSERT
ON SDSADM.STD_HL7VALUETYPE
BEGIN
	-- update the table for STD_HL7ValueType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7ValueType';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7ValueType
after UPDATE
ON SDSADM.STD_HL7VALUETYPE
BEGIN
	-- update the table for STD_HL7ValueType operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7ValueType';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7VALUETYPE FOR SDSADM.STD_HL7VALUETYPE;


ALTER TABLE SDSADM.STD_HL7VALUETYPE ADD (
  CONSTRAINT PK_STD_HL7VALUETYPE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7VALUETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7VALUETYPECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_HL7VALUETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7VALUETYPENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_HL7VALUETYPENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7VALUETYPE TO ADR;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPE TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPE TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7VALUETYPE TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7VALUETYPE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7VALUETYPE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7SRCOFCOMMENTHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7SRCOFCOMMENTHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7SRCOFCOMMENTHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7SRCOFCOMMENTHISTORY ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7SrcOfCommentHstry
after DELETE
ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY
BEGIN
	-- update the table for STD_HL7SrcOfCommentHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7SrcOfCommentHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7SrcOfCommentHstry
after INSERT
ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY
BEGIN
	-- update the table for STD_HL7SrcOfCommentHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7SrcOfCommentHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7SrcOfCommentHstry
after UPDATE
ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY
BEGIN
	-- update the table for STD_HL7SrcOfCommentHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7SrcOfCommentHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7SRCOFCOMMENTHISTORY FOR SDSADM.STD_HL7SRCOFCOMMENTHISTORY;


ALTER TABLE SDSADM.STD_HL7SRCOFCOMMENTHISTORY ADD (
  CONSTRAINT PK_STD_HL7SRCOFCOMMENTHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7SRCOFCOMMENTHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_HL7SRCOFCOMMENTHISTORY ADD (
  CONSTRAINT FKSTD_HL7SRCOFCOMMENTHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_HL7SRCOFCOMMENT (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENTHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7SRCOFCOMMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7SRCOFCOMMENT CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7SRCOFCOMMENT
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(1 BYTE)                 NOT NULL,
  NAME         VARCHAR2(60 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7SRCOFCOMMENT ON SDSADM.STD_HL7SRCOFCOMMENT
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7SRCOFCOMMENTCODE ON SDSADM.STD_HL7SRCOFCOMMENT
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7SRCOFCOMMENTNAME ON SDSADM.STD_HL7SRCOFCOMMENT
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7SrcOfComment
after DELETE
ON SDSADM.STD_HL7SRCOFCOMMENT
BEGIN
	-- update the table for STD_HL7SrcOfComment operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7SrcOfComment';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7SrcOfComment
after INSERT
ON SDSADM.STD_HL7SRCOFCOMMENT
BEGIN
	-- update the table for STD_HL7SrcOfComment operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7SrcOfComment';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7SrcOfComment
after UPDATE
ON SDSADM.STD_HL7SRCOFCOMMENT
BEGIN
	-- update the table for STD_HL7SrcOfComment operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7SrcOfComment';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7SRCOFCOMMENT FOR SDSADM.STD_HL7SRCOFCOMMENT;


ALTER TABLE SDSADM.STD_HL7SRCOFCOMMENT ADD (
  CONSTRAINT PK_STD_HL7SRCOFCOMMENT
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7SRCOFCOMMENT
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7SRCOFCOMMENTCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_HL7SRCOFCOMMENTCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7SRCOFCOMMENTNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_HL7SRCOFCOMMENTNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7SRCOFCOMMENT TO ADR;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENT TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENT TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENT TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7SRCOFCOMMENT TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENT TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7SRCOFCOMMENT TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENT TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7SRCOFCOMMENT TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7RESPMODALITYHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7RESPMODALITYHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7RESPMODALITYHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7RESPMODALITYHISTORY ON SDSADM.STD_HL7RESPMODALITYHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7RespModalityHstry
after DELETE
ON SDSADM.STD_HL7RESPMODALITYHISTORY
BEGIN
	-- update the table for STD_HL7RespModalityHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespModalityHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7RespModalityHstry
after INSERT
ON SDSADM.STD_HL7RESPMODALITYHISTORY
BEGIN
	-- update the table for STD_HL7RespModalityHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespModalityHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7RespModalityHstry
after UPDATE
ON SDSADM.STD_HL7RESPMODALITYHISTORY
BEGIN
	-- update the table for STD_HL7RespModalityHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespModalityHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7RESPMODALITYHISTORY FOR SDSADM.STD_HL7RESPMODALITYHISTORY;


ALTER TABLE SDSADM.STD_HL7RESPMODALITYHISTORY ADD (
  CONSTRAINT PK_STD_HL7RESPMODALITYHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7RESPMODALITYHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_HL7RESPMODALITYHISTORY ADD (
  CONSTRAINT FKSTD_HL7RESPMODALITYHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_HL7RESPMODALITY (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7RESPMODALITYHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITYHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITYHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITYHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7RESPMODALITYHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITYHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RESPMODALITYHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITYHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITYHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7RESPMODALITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7RESPMODALITY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7RESPMODALITY
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(1 BYTE)                     NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7RESPMODALITY ON SDSADM.STD_HL7RESPMODALITY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7RESPMODALITYCODE ON SDSADM.STD_HL7RESPMODALITY
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7RESPMODALITYNAME ON SDSADM.STD_HL7RESPMODALITY
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7RespModality
after DELETE
ON SDSADM.STD_HL7RESPMODALITY
BEGIN
	-- update the table for STD_HL7RespModality operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespModality';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7RespModality
after INSERT
ON SDSADM.STD_HL7RESPMODALITY
BEGIN
	-- update the table for STD_HL7RespModality operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespModality';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7RespModality
after UPDATE
ON SDSADM.STD_HL7RESPMODALITY
BEGIN
	-- update the table for STD_HL7RespModality operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespModality';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7RESPMODALITY FOR SDSADM.STD_HL7RESPMODALITY;


ALTER TABLE SDSADM.STD_HL7RESPMODALITY ADD (
  CONSTRAINT PK_STD_HL7RESPMODALITY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7RESPMODALITY
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7RESPMODALITYCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_HL7RESPMODALITYCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7RESPMODALITYNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_HL7RESPMODALITYNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7RESPMODALITY TO ADR;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITY TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITY TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7RESPMODALITY TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RESPMODALITY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7RESPMODALITY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7RESPLEVCODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7RESPLEVCODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7RESPLEVCODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7RESPLEVCODEHISTORY ON SDSADM.STD_HL7RESPLEVCODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7RespLevCodeHistory
after DELETE
ON SDSADM.STD_HL7RESPLEVCODEHISTORY
BEGIN
	-- update the table for STD_HL7RespLevCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespLevCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7RespLevCodeHistory
after INSERT
ON SDSADM.STD_HL7RESPLEVCODEHISTORY
BEGIN
	-- update the table for STD_HL7RespLevCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespLevCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7RespLevCodeHistory
after UPDATE
ON SDSADM.STD_HL7RESPLEVCODEHISTORY
BEGIN
	-- update the table for STD_HL7RespLevCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespLevCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7RESPLEVCODEHISTORY FOR SDSADM.STD_HL7RESPLEVCODEHISTORY;


ALTER TABLE SDSADM.STD_HL7RESPLEVCODEHISTORY ADD (
  CONSTRAINT PK_STD_HL7RESPLEVCODEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7RESPLEVCODEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_HL7RESPLEVCODEHISTORY ADD (
  CONSTRAINT FKSTD_HL7RESPLEVCODEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_HL7RESPLEVCODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7RESPLEVCODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7RESPLEVCODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7RESPLEVCODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(2 BYTE)                     NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7RESPLEVCODE ON SDSADM.STD_HL7RESPLEVCODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7RESPLEVCODECODE ON SDSADM.STD_HL7RESPLEVCODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7RESPLEVCODENAME ON SDSADM.STD_HL7RESPLEVCODE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7RespLevCode
after DELETE
ON SDSADM.STD_HL7RESPLEVCODE
BEGIN
	-- update the table for STD_HL7RespLevCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespLevCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7RespLevCode
after INSERT
ON SDSADM.STD_HL7RESPLEVCODE
BEGIN
	-- update the table for STD_HL7RespLevCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespLevCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7RespLevCode
after UPDATE
ON SDSADM.STD_HL7RESPLEVCODE
BEGIN
	-- update the table for STD_HL7RespLevCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RespLevCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7RESPLEVCODE FOR SDSADM.STD_HL7RESPLEVCODE;


ALTER TABLE SDSADM.STD_HL7RESPLEVCODE ADD (
  CONSTRAINT PK_STD_HL7RESPLEVCODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7RESPLEVCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7RESPLEVCODECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_HL7RESPLEVCODECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7RESPLEVCODENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_HL7RESPLEVCODENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7RESPLEVCODE TO ADR;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODE TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7RESPLEVCODE TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RESPLEVCODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7RESPLEVCODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7RECLEVEVCODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7RECLEVEVCODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7RECLEVEVCODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7RECLEVEVCODEHISTORY ON SDSADM.STD_HL7RECLEVEVCODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7RecLevEvCodeHstry
after DELETE
ON SDSADM.STD_HL7RECLEVEVCODEHISTORY
BEGIN
	-- update the table for STD_HL7RecLevEvCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevEvCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7RecLevEvCodeHstry
after INSERT
ON SDSADM.STD_HL7RECLEVEVCODEHISTORY
BEGIN
	-- update the table for STD_HL7RecLevEvCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevEvCodeHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7RecLevEvCodeHstry
after UPDATE
ON SDSADM.STD_HL7RECLEVEVCODEHISTORY
BEGIN
	-- update the table for STD_HL7RecLevEvCodeHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevEvCodeHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7RECLEVEVCODEHISTORY FOR SDSADM.STD_HL7RECLEVEVCODEHISTORY;


ALTER TABLE SDSADM.STD_HL7RECLEVEVCODEHISTORY ADD (
  CONSTRAINT PK_STD_HL7RECLEVEVCODEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7RECLEVEVCODEHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_HL7RECLEVEVCODEHISTORY ADD (
  CONSTRAINT FKSTD_HL7RECLEVEVCODEHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_HL7RECLEVEVCODE (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODEHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7RECLEVEVCODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7RECLEVEVCODE CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7RECLEVEVCODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(3 BYTE)                     NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7RECLEVEVCODE ON SDSADM.STD_HL7RECLEVEVCODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7RECLEVEVCODECODE ON SDSADM.STD_HL7RECLEVEVCODE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7RECLEVEVCODENAME ON SDSADM.STD_HL7RECLEVEVCODE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7RecLevEvCode
after DELETE
ON SDSADM.STD_HL7RECLEVEVCODE
BEGIN
	-- update the table for STD_HL7RecLevEvCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevEvCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7RecLevEvCode
after INSERT
ON SDSADM.STD_HL7RECLEVEVCODE
BEGIN
	-- update the table for STD_HL7RecLevEvCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevEvCode';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7RecLevEvCode
after UPDATE
ON SDSADM.STD_HL7RECLEVEVCODE
BEGIN
	-- update the table for STD_HL7RecLevEvCode operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevEvCode';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7RECLEVEVCODE FOR SDSADM.STD_HL7RECLEVEVCODE;


ALTER TABLE SDSADM.STD_HL7RECLEVEVCODE ADD (
  CONSTRAINT PK_STD_HL7RECLEVEVCODE
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7RECLEVEVCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7RECLEVEVCODECODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_HL7RECLEVEVCODECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7RECLEVEVCODENAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_HL7RECLEVEVCODENAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7RECLEVEVCODE TO ADR;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODE TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODE TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7RECLEVEVCODE TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODE TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RECLEVEVCODE TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODE TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7RECLEVEVCODE TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7RECLEVERRRETHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7RECLEVERRRETHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7RECLEVERRRETHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7RECLEVERRRETHISTORY ON SDSADM.STD_HL7RECLEVERRRETHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7RecLevErrRetHstry
after DELETE
ON SDSADM.STD_HL7RECLEVERRRETHISTORY
BEGIN
	-- update the table for STD_HL7RecLevErrRetHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevErrRetHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7RecLevErrRetHstry
after INSERT
ON SDSADM.STD_HL7RECLEVERRRETHISTORY
BEGIN
	-- update the table for STD_HL7RecLevErrRetHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevErrRetHistory';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7RecLevErrRetHstry
after UPDATE
ON SDSADM.STD_HL7RECLEVERRRETHISTORY
BEGIN
	-- update the table for STD_HL7RecLevErrRetHistory operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevErrRetHistory';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7RECLEVERRRETHISTORY FOR SDSADM.STD_HL7RECLEVERRRETHISTORY;


ALTER TABLE SDSADM.STD_HL7RECLEVERRRETHISTORY ADD (
  CONSTRAINT PK_STD_HL7RECLEVERRRETHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7RECLEVERRRETHISTORY
  ENABLE VALIDATE);

ALTER TABLE SDSADM.STD_HL7RECLEVERRRETHISTORY ADD (
  CONSTRAINT FKSTD_HL7RECLEVERRRETHSTRYOWNR 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES SDSADM.STD_HL7RECLEVERRRET (ID)
  ON DELETE CASCADE
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO ADR;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRETHISTORY TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7RECLEVERRRET
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7RECLEVERRRET CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7RECLEVERRRET
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(1 BYTE)                     NOT NULL,
  NAME         VARCHAR2(70 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX SDSADM.PK_STD_HL7RECLEVERRRET ON SDSADM.STD_HL7RECLEVERRRET
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7RECLEVERRRETCODE ON SDSADM.STD_HL7RECLEVERRRET
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX SDSADM.UQSTD_HL7RECLEVERRRETNAME ON SDSADM.STD_HL7RECLEVERRRET
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER SDSADM.del4_STD_HL7RecLevErrRet
after DELETE
ON SDSADM.STD_HL7RECLEVERRRET
BEGIN
	-- update the table for STD_HL7RecLevErrRet operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevErrRet';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.ins4_STD_HL7RecLevErrRet
after INSERT
ON SDSADM.STD_HL7RECLEVERRRET
BEGIN
	-- update the table for STD_HL7RecLevErrRet operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevErrRet';
END;
/


CREATE OR REPLACE TRIGGER SDSADM.upd4_STD_HL7RecLevErrRet
after UPDATE
ON SDSADM.STD_HL7RECLEVERRRET
BEGIN
	-- update the table for STD_HL7RecLevErrRet operation
	UPDATE STD_TableManager
	SET lastUpdated = CURRENT_TIMESTAMP
	WHERE tableName = 'STD_HL7RecLevErrRet';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HL7RECLEVERRRET FOR SDSADM.STD_HL7RECLEVERRRET;


ALTER TABLE SDSADM.STD_HL7RECLEVERRRET ADD (
  CONSTRAINT PK_STD_HL7RECLEVERRRET
  PRIMARY KEY
  (ID)
  USING INDEX SDSADM.PK_STD_HL7RECLEVERRRET
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7RECLEVERRRETCODE
  UNIQUE (CODE)
  USING INDEX SDSADM.UQSTD_HL7RECLEVERRRETCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_HL7RECLEVERRRETNAME
  UNIQUE (NAME)
  USING INDEX SDSADM.UQSTD_HL7RECLEVERRRETNAME
  ENABLE VALIDATE);

GRANT REFERENCES ON SDSADM.STD_HL7RECLEVERRRET TO ADR;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRET TO ADREXT;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRET TO EESRV;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRET TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES ON SDSADM.STD_HL7RECLEVERRRET TO LOBR;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRET TO PSIM;

GRANT INSERT, SELECT, UPDATE ON SDSADM.STD_HL7RECLEVERRRET TO SDS_EDIT;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRET TO SDS_PROXY;

GRANT SELECT ON SDSADM.STD_HL7RECLEVERRRET TO SDS_SELECT;
ALTER TABLE SDSADM.STD_HL7QUERYRESULTSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE SDSADM.STD_HL7QUERYRESULTSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE SDSADM.STD_HL7QUERYRESULTSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
   